/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IRichTopClient_showGift_EventArgs;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_loadGiftComponent_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onLeaveTurnTable_EventArgs;
import com.yy.mobile.plugin.main.events.IGiftUIListener_showGiftBag_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.turntable.info.TurnTableEntryInfo;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;

public class TurntablePropsDetailDialog
extends PopupComponent {
    public static final String TAG = "TurntablePropsDetailDialog";
    private final int dialogW = (int)ResolutionUtils.convertDpToPixel((float)220.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static boolean TurntablePropsDetailDialogUIShow = false;
    private TurnTableEntryInfo.GiftCfg itemInfo;
    private TextView mGiftName;
    private TextView mGiftNum;
    private TextView mGiftTips;
    private TextView mTvGotoSendGift;
    private TextView mTvSponor;
    private LinearLayout mSponorBar;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private Runnable showGiftBagRunnable = new Runnable(){

        @Override
        public void run() {
            RxBus.getDefault().post((Object)new IGiftUIListener_showGiftBag_EventArgs());
            RxBus.getDefault().post((Object)new IChannelTurntableClient_onLeaveTurnTable_EventArgs());
            TurntablePropsDetailDialog.this.dismissAllowingStateLoss();
        }
    };

    public static TurntablePropsDetailDialog newInstance() {
        TurntablePropsDetailDialog turntablePropsDetailDialog = new TurntablePropsDetailDialog();
        return turntablePropsDetailDialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.slide_dialog_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setGravity(85);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().setLayout(this.dialogW, -2);
        dialog.getWindow().clearFlags(2);
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.x = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.getActivity());
        lp.y = (int)ResolutionUtils.convertDpToPixel((float)36.0f, (Context)this.getActivity());
        dialog.getWindow().setAttributes(lp);
        return dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        try {
            view = inflater.inflate(R.layout.turntable_layout_props_detail, container);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)throwable.getMessage(), (Object[])new Object[0]);
            return null;
        }
        this.mSponorBar = (LinearLayout)view.findViewById(R.id.sponor_container);
        this.mTvSponor = (TextView)view.findViewById(R.id.tv_sponor_v2);
        this.mGiftName = (TextView)view.findViewById(R.id.tv_notice_gift_name_v2);
        this.mGiftNum = (TextView)view.findViewById(R.id.tv_notice_gift_num_v2);
        this.mGiftTips = (TextView)view.findViewById(R.id.tv_gift_tips_v2);
        this.mTvGotoSendGift = (TextView)view.findViewById(R.id.tv_goto_send_gift_v2);
        this.initView();
        return view;
    }

    public void updateView(TurnTableEntryInfo.GiftCfg giftCfg) {
        this.itemInfo = giftCfg;
    }

    private void initView() {
        if (this.itemInfo == null) {
            return;
        }
        if (this.itemInfo.name != null) {
            this.mGiftName.setText((CharSequence)this.itemInfo.name);
        }
        if (this.itemInfo.num >= 0) {
            this.mGiftNum.setText((CharSequence)("(\u62e5\u6709:" + String.valueOf(this.itemInfo.num) + "\u4e2a)"));
        }
        if (this.itemInfo.tips != null) {
            this.mGiftTips.setText((CharSequence)this.itemInfo.tips);
        }
        if (this.itemInfo.type == 1 || this.itemInfo.type == 3 || this.itemInfo.type == 4) {
            this.mSponorBar.setVisibility(this.itemInfo.type == 4 ? 8 : 0);
            this.mTvGotoSendGift.setVisibility(0);
            if (this.itemInfo.num > 0) {
                this.mTvGotoSendGift.setEnabled(true);
                this.mTvGotoSendGift.setTextColor(Color.parseColor((String)"#000000"));
                this.mTvGotoSendGift.setBackgroundResource(R.drawable.turntable_send_gift_btn_normal_v2);
            } else {
                this.mTvGotoSendGift.setEnabled(false);
                this.mTvGotoSendGift.setTextColor(Color.parseColor((String)"#ffffff"));
                this.mTvGotoSendGift.setBackgroundResource(R.drawable.turntable_send_gift_btn_null_v2);
            }
            if ("".equals(this.itemInfo.sponsor)) {
                this.itemInfo.sponsor = "\u865a\u4f4d\u4ee5\u5f85";
            }
            if (this.itemInfo.sponsor != null) {
                this.mTvSponor.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                this.mTvSponor.setText((CharSequence)this.itemInfo.sponsor);
                this.mTvSponor.setFocusableInTouchMode(true);
                this.mTvSponor.requestFocus();
            }
            this.mTvGotoSendGift.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if ("entertainment".equals(Temp.getCurrentBussinessId())) {
                        RxBus.getDefault().post((Object)new IChannelTurntableClient_loadGiftComponent_EventArgs());
                    } else {
                        PluginBus.INSTANCE.get().post((Object)new IRichTopClient_showGift_EventArgs());
                    }
                    if (TurntablePropsDetailDialog.this.handler != null) {
                        TurntablePropsDetailDialog.this.handler.postDelayed(TurntablePropsDetailDialog.this.showGiftBagRunnable, 200L);
                    }
                }
            });
        } else {
            this.mTvGotoSendGift.setVisibility(8);
            this.mSponorBar.setVisibility(8);
        }
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"TurntablePropsDetailDialog is onDestroy", (Object[])new Object[0]);
        TurntablePropsDetailDialogUIShow = false;
        this.handler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void onDismiss(DialogInterface dialog) {
        MLog.info((Object)TAG, (String)"TurntablePropsDetailDialog is onDismiss", (Object[])new Object[0]);
        TurntablePropsDetailDialogUIShow = false;
        super.onDismiss(dialog);
    }
}

