/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.streamlight;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.liveapi.commonnotice.event.EarningRxEvent;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.streamlight.StreamLightController;
import com.yy.mobile.ui.streamlight.StreamLightFactory;
import com.yy.mobile.ui.streamlight.StreamLightProxy;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.Proxy.LiveModuleManagerProxy;

public class StreamLightComponent
extends Component {
    public static final String ENV_KEY = "env_key";
    public static final String HASACTIVITY_KEY = "hasActivity_key";
    protected StreamLightController giftComponentController;
    protected int env = 0;
    protected RelativeLayout layout;

    public static StreamLightComponent singleton(int env, boolean hasActivity) {
        StreamLightComponent streamLightComponent = new StreamLightComponent();
        Bundle bundle = new Bundle();
        bundle.putInt(ENV_KEY, env);
        bundle.putBoolean(HASACTIVITY_KEY, hasActivity);
        streamLightComponent.setArguments(bundle);
        return streamLightComponent;
    }

    protected void createStreamLightController(int env) {
        EarningRxEvent event;
        this.giftComponentController = StreamLightFactory.createStreamLightController(env, this.getChildFragmentManager());
        if ((LiveModuleManagerProxy.getInstance().isBookMode(1) || LiveModuleManagerProxy.getInstance().getEarnigCommonEvent() != null) && LiveModuleManagerProxy.getInstance().getEarnigCommonEvent().getEventHashMap() != null && (event = (EarningRxEvent)LiveModuleManagerProxy.getInstance().getEarnigCommonEvent().getEventHashMap().get(1)) != null) {
            StreamLightProxy streamLightProxy = new StreamLightProxy();
            Point point = event.getPoint();
            Rect rect = event.getRect();
            streamLightProxy.setPoint(point);
            streamLightProxy.setOffsetMarginPortrait(rect);
            this.giftComponentController.setStreamLightProxy(streamLightProxy, false);
        }
        this.giftComponentController.setBottomValueCongfig(this.bottomValueConfig());
        this.giftComponentController.initArea((Context)this.getActivity(), this.layout);
    }

    protected void heyTapStreamLight() {
        this.giftComponentController.changeLinkGiftCombleController(false, null);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        boolean hasActivity = false;
        if (args != null) {
            this.env = args.getInt(ENV_KEY);
            hasActivity = args.getBoolean(HASACTIVITY_KEY);
        }
        this.layout = new RelativeLayout((Context)this.getActivity());
        this.layout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.createStreamLightController(this.env);
        this.heyTapStreamLight();
        return this.layout;
    }

    protected int bottomValueConfig() {
        return (int)ResolutionUtils.convertPixelsToDp((float)this.getContent().getResources().getDimensionPixelSize(R.dimen.new_chatlist_height), (Context)this.getContext());
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.giftComponentController != null) {
            this.giftComponentController.onOrientationChanges(isLandscape);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.giftComponentController != null) {
            this.giftComponentController.deInit();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.giftComponentController != null) {
            this.giftComponentController.onPause();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.giftComponentController != null) {
            this.giftComponentController.onResume();
        }
    }
}

