/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.richtext.NewChannelAirTicketFilter;
import com.yy.mobile.ui.publicchat.EnterRuleNoticeMessage;
import com.yy.mobile.ui.publicchat.model.IPublicChatFlushDataListener;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel$$EventBinder;
import com.yy.mobile.ui.publicchat.model.SpdtChatNotice;
import com.yy.mobile.ui.publicchat.model.event.AppendChannelMessageEvent;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatBaseParser;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatParseManager;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class PublicChatBaseModel
implements EventCompat,
PublicChatParseManager.ParseListener {
    private static final String TAG = "PublicChatBaseModel";
    public static final int PLAN_B_TEMPLATE_NOTICE_TEXT_SIZE = 11;
    public static final String DEFAULT_NOTICE = "\u5e73\u53f0\u6b63\u5bf9\u76f4\u64ad\u5185\u5bb9\u8fdb\u884c24\u5c0f\u65f6\u5de1\u67e5\uff0c\u4efb\u4f55\u4f20\u64ad\u8fdd\u6cd5\u3001\u8fdd\u89c4\u3001\u4f4e\u4fd7\u3001\u8272\u60c5\u3001\u66b4\u529b\u7b49\u4e0d\u826f\u4fe1\u606f\u5c06\u4f1a\u88ab\u5c01\u505c\u8d26\u53f7\uff1b\u8bf7\u52ff\u8f7b\u4fe1\u4ed6\u4eba\uff0c\u8c28\u9632\u4e0a\u5f53\u53d7\u9a97\u3002";
    protected Context mContext;
    protected final PublicChatParseManager parseManager;
    protected final PublicChatBaseParser parser;
    protected IPublicChatFlushDataListener flushDataListener;
    protected CompositeDisposable noticeDisposable = new CompositeDisposable();
    private SpdtChatNotice noticeResp;
    private EventBinder mPublicChatBaseModelSniperEventBinder;

    public PublicChatBaseModel() {
        this(0, 1);
    }

    public PublicChatBaseModel(int historyType, int type) {
        this.parseManager = this.onCreateParserManager();
        this.parser = this.onCreateParser();
        this.parser.mChatFilterType = type;
        this.parser.mHistoryType = historyType;
    }

    @NotNull
    protected PublicChatBaseParser onCreateParser() {
        return new PublicChatBaseParser();
    }

    protected PublicChatParseManager onCreateParserManager() {
        return new PublicChatParseManager();
    }

    public void initModel(Context context) {
        this.mContext = context;
        MLog.info((Object)TAG, (String)("Model onCreate" + this), (Object[])new Object[0]);
        this.parser.initModel(context);
        this.parseManager.addParseListener(this, this.parser);
        IChannelLinkCore core = ICoreManagerBase.getChannelLinkCore();
        if (core != null && core.getCurrentChannelInfo() != null && core.getChannelState() == ChannelState.In_Channel) {
            this.onJoinChannelSuccess();
        }
        this.onEventBind();
    }

    public void deInitModel() {
        MLog.info((Object)TAG, (String)("Model onDestroy" + this), (Object[])new Object[0]);
        this.noticeDisposable.clear();
        this.parser.deInitModel();
        this.onEventUnBind();
        this.parseManager.removeParseListener(this);
    }

    public void setFlushDataListener(IPublicChatFlushDataListener listener2) {
        this.flushDataListener = listener2;
    }

    @Override
    public boolean onInterceptBeforeParse(@NotNull ChannelMessage message) {
        this.onProcessBeforeParse(message);
        return false;
    }

    protected void onProcessBeforeParse(@NotNull ChannelMessage message) {
        this.parser.decorateNickNameBeforeParse(message);
    }

    @Override
    public boolean onInterceptBeforeShow(@NonNull ChannelMessage message) {
        return false;
    }

    protected String generateHostActivityName() {
        if (this.mContext != null) {
            return String.valueOf(this.mContext.hashCode());
        }
        return "";
    }

    protected void onJoinChannelSuccess() {
    }

    protected void onLeaveChannelSuccess() {
    }

    protected NoticeMessage createRuleNoticeMessage(String notice) {
        EnterRuleNoticeMessage message = new EnterRuleNoticeMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        message.uid = 0L;
        message.sid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid;
        message.nickname = "";
        message.text = notice;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        if (message.text.length() <= spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#bae05d")), 0, message.text.length(), 33);
        }
        message.spannable = spannable;
        return message;
    }

    protected void requestNotice() {
        if (this.noticeResp == null) {
            this.noticeResp = (SpdtChatNotice)Spdt.of(SpdtChatNotice.class);
        }
        this.noticeDisposable.add(this.noticeResp.getChatNotice().observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<List<String>>(){

            public void accept(List<String> list2) {
                MLog.info((Object)PublicChatBaseModel.TAG, (String)("requestNotice: result = " + list2), (Object[])new Object[0]);
                for (String notice : list2) {
                    RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)PublicChatBaseModel.this.createRuleNoticeMessage(notice)));
                }
                PublicChatBaseModel.this.doAfterRequestNotice();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                MLog.info((Object)PublicChatBaseModel.TAG, (String)("requestNotice: error = " + throwable.getMessage()), (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new AppendChannelMessageEvent((ChannelMessage)PublicChatBaseModel.this.createRuleNoticeMessage(PublicChatBaseModel.DEFAULT_NOTICE)));
                PublicChatBaseModel.this.doAfterRequestNotice();
            }
        }));
    }

    protected void doAfterRequestNotice() {
    }

    @BusEvent
    public final void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onJoinChannelSuccess", (Object[])new Object[0]);
        this.parseManager.onJoinChannelSuccess();
        if (this.flushDataListener != null) {
            this.flushDataListener.setChatData(Collections.emptyList());
        }
        this.onJoinChannelSuccess();
    }

    @BusEvent
    public final void onLeaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs eventArgs) {
        MLog.info((Object)TAG, (String)"onLeaveCurrentChannel", (Object[])new Object[0]);
        this.parseManager.onLeaveCurrentChannel();
        this.noticeDisposable.clear();
        this.onLeaveChannelSuccess();
    }

    @Override
    public final void onParseResult(@NotNull Collection<? extends ChannelMessage> messages) {
        if (this.flushDataListener != null) {
            this.flushDataListener.setChatData(messages);
        }
    }

    public PublicChatParseManager getParseManager() {
        return this.parseManager;
    }

    public void onEventBind() {
        if (this.mPublicChatBaseModelSniperEventBinder == null) {
            this.mPublicChatBaseModelSniperEventBinder = new PublicChatBaseModel$$EventBinder();
        }
        this.mPublicChatBaseModelSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPublicChatBaseModelSniperEventBinder != null) {
            this.mPublicChatBaseModelSniperEventBinder.unBindEvent();
        }
    }

    public SpannableStringBuilder parseMessageHeaderIcon(ChannelMessage message, SpannableStringBuilder spannable) {
        return this.parser.parseMessageHeaderIcon(message, spannable);
    }

    public void parseLoadedGiftMessage(Context context, GiftChannelMessage message, String nick, int contentStart) {
        this.parser.parseLoadedGiftMessage(context, message, nick, contentStart);
    }

    public boolean isGameTypeOrETPlanBType() {
        return this.getChatFilterType() == 3 || this.getChatFilterType() == 4;
    }

    public int getChatFilterType() {
        return this.parser.mChatFilterType;
    }

    public int getHistoryType() {
        return this.parser.mHistoryType;
    }

    public NewChannelAirTicketFilter.AirSpanClickListener getAirSpanClickListener() {
        return this.parser.airSpanClickListener;
    }

    public static enum ModelType {
        LIVE(0),
        REPLAY(1);

        public int type;

        private ModelType(int type) {
            this.type = type;
        }

        public static ModelType of(int type) {
            for (ModelType t : ModelType.values()) {
                if (t.type != type) continue;
                return t;
            }
            throw new NoSuchElementException("No this type " + type + ".");
        }
    }
}

