/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter.presenter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.small.Small;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.android.sniper.api.utils.CompatOptional;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.mvplifecycle2.MvpPresenterEvent;
import com.yy.mobile.mvplifecycle2.RxMvpPresenter;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_clickAllNewPlugin_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_hidePluginCenter_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.plugincenter.PluginCenterController;
import com.yy.mobile.ui.plugincenter.component.PluginCenterComponent;
import com.yy.mobile.ui.plugincenter.intercept.VotePluginIntercept;
import com.yy.mobile.ui.plugincenter.intercept.YiqiboPluginIntercept;
import com.yy.mobile.ui.plugincenter.presenter.PluginCenterAdapter;
import com.yy.mobile.ui.plugincenter.presenter.PluginCenterPresenter$$EventBinder;
import com.yy.mobile.ui.utils.ActivityCheckerUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.media.ILiveConfigCore;
import com.yymobile.core.media.LiveConfigType;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.core.plugincenter.PluginInfo;
import com.yymobile.core.plugincenter.config.IPlugHiidoCore;
import com.yymobile.core.plugincenter.config.PlugHiidoConfigData;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.liveapi.plugincenter.ExSinglePluginInfo;
import com.yymobile.liveapi.plugincenter.SinglePluginInfo;
import com.yymobile.liveapi.plugincenter.event.PluginCenterMutexEventArgv;
import io.reactivex.FlowableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PluginCenterPresenter
extends RxMvpPresenter<PluginCenterComponent>
implements EventCompat,
PluginCenterAdapter.OnItemSelectListener {
    private static final String TAG = "PluginCenterPresenter";
    private static final String IS_YIQIBO_FIRST_USED = "is_yiqibo_first_used";
    private PluginCenterAdapter mAdapter;
    private boolean mIsOw;
    private long mTemplateId = 0L;
    private int mYiqiboAuthCode = -1;
    private CompositeDisposable mDisposables = new CompositeDisposable();
    private EventBinder mPluginCenterPresenterSniperEventBinder;

    public void onEventBind() {
        if (this.mPluginCenterPresenterSniperEventBinder == null) {
            this.mPluginCenterPresenterSniperEventBinder = new PluginCenterPresenter$$EventBinder();
        }
        this.mPluginCenterPresenterSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPluginCenterPresenterSniperEventBinder != null) {
            this.mPluginCenterPresenterSniperEventBinder.unBindEvent();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onEventBind();
    }

    public void onViewCreated(Bundle arguements) {
        this.parseArguments(arguements);
        this.initPluginList();
        this.registerEvent();
    }

    private void parseArguments(Bundle arguments) {
        if (null == arguments) {
            return;
        }
        this.mIsOw = arguments.getBoolean("key_isowner");
        this.mTemplateId = arguments.getLong("key_templateId", 0L);
    }

    private void initPluginList() {
        this.setPluginInfos(((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPluginInfo());
        this.getPlugins();
    }

    public PluginCenterAdapter getAdapter() {
        if (null == this.mAdapter) {
            boolean isLandscape = null != this.getView() && ((PluginCenterComponent)this.getView()).isLandscape();
            this.mAdapter = new PluginCenterAdapter(isLandscape);
            this.mAdapter.setItemSelectListener(this);
        }
        return this.mAdapter;
    }

    private void registerEvent() {
        Disposable disposable2 = RxBus.getDefault().register(PluginCenterMutexEventArgv.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PluginCenterMutexEventArgv>(){

            public void accept(@NonNull PluginCenterMutexEventArgv pluginCenterMutexEventArgv) throws Exception {
                SinglePluginInfo activatedPlugin = pluginCenterMutexEventArgv.getActivatedPlugin();
                SinglePluginInfo pendingStartPlugin = pluginCenterMutexEventArgv.getPendingStartPlugin();
                MLog.info((Object)PluginCenterPresenter.TAG, (String)("onPluginCenterMutexEventArgv called , activatedPlugin=" + activatedPlugin + " , pendingStartPlugin=" + pendingStartPlugin), (Object[])new Object[0]);
                if (((VotePluginIntercept)Spdt.of(VotePluginIntercept.class)).pluginVoteRunningToast(pendingStartPlugin)) {
                    return;
                }
                SingleToastUtil.showToast((String)("\u6b63\u5728\u8fdb\u884c\u201c" + activatedPlugin.pluginName + "\u201d"));
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"PluginCenterMutexEventArgv error"));
        this.mDisposables.add(disposable2);
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        this.getPlugins();
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.getPlugins();
    }

    @BusEvent(sync=true)
    public void hidePluginCenter(IPluginCenterClient_hidePluginCenter_EventArgs busEventArgs) {
        this.getMvpView().notNull((CompatOptional.Function)new CompatOptional.Function<PluginCenterComponent>(){

            public void apply(PluginCenterComponent pluginCenterComponent) {
                if (ActivityCheckerUtils.isActivityValid((Activity)pluginCenterComponent.getActivity())) {
                    pluginCenterComponent.dismissAllowingStateLoss();
                }
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    private void getPlugins() {
        ChannelInfo channelInfo;
        if (null == this.getView()) {
            return;
        }
        if (!LoginUtil.isLogined()) {
            ((PluginCenterComponent)this.getView()).setNodataTipVisibility(0);
        }
        if (null == (channelInfo = ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getCurrentChannelInfo()) || channelInfo.topSid <= 0L) {
            ((PluginCenterComponent)this.getView()).setNodataTipVisibility(0);
        }
        ((PluginCenterComponent)this.getView()).setNodataTipVisibility(8);
        ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPlugins(LoginUtil.getUid(), channelInfo.topSid, channelInfo.subSid, this.mTemplateId).compose((FlowableTransformer)this.bindUntilEvent(MvpPresenterEvent.DESTROY)).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PluginInfo>(){

            public void accept(PluginInfo pluginInfo) throws Exception {
                PluginCenterPresenter.this.setPluginInfos(pluginInfo);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
            }
        });
    }

    private void setPluginInfos(PluginInfo pluginInfo) {
        if (null == pluginInfo) {
            return;
        }
        ArrayList pluginInfos = pluginInfo.plugs;
        this.getAdapter().setPluginList(pluginInfos);
        if (null != this.getView()) {
            ((PluginCenterComponent)this.getView()).setComponentSize(FP.size((Collection)pluginInfos));
        }
    }

    private List<SinglePluginInfo> filterPluginList(List<SinglePluginInfo> pluginInfos) {
        ArrayList<SinglePluginInfo> filteredPlugs = new ArrayList<SinglePluginInfo>();
        IPluginCenterCore core = (IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class);
        if (null == core) {
            return filteredPlugs;
        }
        for (SinglePluginInfo info : pluginInfos) {
            if (info instanceof ExSinglePluginInfo) {
                filteredPlugs.add(info);
                continue;
            }
            if (!info.showIcon || core.isNotSupportPlugin(info.pluginId) || core.isMultLiveNotSupportPlugin(info.pluginName)) continue;
            filteredPlugs.add(info);
        }
        if (this.isMultiLive()) {
            filteredPlugs.add(this.getMultiNoticePluginInfo());
        }
        return filteredPlugs;
    }

    private boolean isMultiLive() {
        return false;
    }

    private SinglePluginInfo getMultiNoticePluginInfo() {
        ExSinglePluginInfo info = new ExSinglePluginInfo();
        info.identification = "multi-wish";
        info.pluginName = "\u656c\u8bf7\u671f\u5f85";
        info.index = Integer.MAX_VALUE;
        info.iconResId = R.drawable.icon_game_more;
        info.isNewPlugin = false;
        info.pluginConfig = new SinglePluginInfo.PluginConfig();
        info.pluginConfig.androidInfo = new SinglePluginInfo.AndroidInfo();
        info.pluginConfig.androidInfo.androidId = "28";
        return info;
    }

    @Override
    public void onPluginItemSelect(SinglePluginInfo pluginInfo, View item2, int position) {
        if (null == pluginInfo) {
            return;
        }
        MLog.info((Object)TAG, (String)("onPluginItemSelect SinglePluginInfo : " + pluginInfo), (Object[])new Object[0]);
        this.reportGameClickStatistic(pluginInfo);
        if (pluginInfo instanceof ExSinglePluginInfo) {
            this.setNewPluginClick(pluginInfo);
            ExSinglePluginInfo ep = (ExSinglePluginInfo)pluginInfo;
            if (ep.onClickListener != null) {
                ep.onClickListener.onClick(item2);
            }
            return;
        }
        SinglePluginInfo currentActivedPlugin = this.getCurActivedPlugin();
        if (!(null == currentActivedPlugin || currentActivedPlugin.pluginId != pluginInfo.pluginId && currentActivedPlugin.isMultiActiveSupport())) {
            MLog.info((Object)TAG, (String)" current activated plugin is %s can not open another %s", (Object[])new Object[]{currentActivedPlugin.getAndroidId(), pluginInfo.getAndroidId()});
            this.reportGameClickMutexStatistic(pluginInfo);
            RxBus.getDefault().post((Object)new PluginCenterMutexEventArgv(currentActivedPlugin, pluginInfo));
            return;
        }
        if (!((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && pluginInfo.pluginId != 100L && pluginInfo.pluginId != 101L) {
            SingleToastUtil.showToast((String)"\u60a8\u5f53\u524d\u672a\u5f00\u64ad\uff0c\u65e0\u6cd5\u5f00\u542f\u6e38\u620f");
            return;
        }
        if (!this.canStartPlugin()) {
            return;
        }
        if ("28".equals(pluginInfo.getAndroidId())) {
            this.setNewPluginClick(pluginInfo);
            this.startMultiPlugins(pluginInfo);
            return;
        }
        if (((YiqiboPluginIntercept)Spdt.of(YiqiboPluginIntercept.class)).pluginYiqiboIntercept(pluginInfo)) {
            MLog.info((Object)TAG, (String)"intecept by Spdt", (Object[])new Object[0]);
            this.setNewPluginClick(pluginInfo);
            if (this.getView() != null) {
                ((PluginCenterComponent)this.getView()).dismissAllowingStateLoss();
            }
            return;
        }
        if (((VotePluginIntercept)Spdt.of(VotePluginIntercept.class)).pluginVoteIntercept(pluginInfo)) {
            this.setNewPluginClick(pluginInfo);
            if (this.getView() != null) {
                ((PluginCenterComponent)this.getView()).dismissAllowingStateLoss();
            }
            return;
        }
        this.startPlugin(pluginInfo);
    }

    private void startPlugin(SinglePluginInfo pluginInfo) {
        String clickEventID;
        if (!Small.isPluginShouldRun((String)pluginInfo.getAndroidId())) {
            MLog.info((Object)TAG, (String)("startPlugin error, plugin is not download->" + pluginInfo.getAndroidId()), (Object[])new Object[0]);
            SingleToastUtil.showToast((String)"\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            return;
        }
        IPlugHiidoCore pHiidoCore = (IPlugHiidoCore)ICoreManagerBase.getCore(IPlugHiidoCore.class);
        PlugHiidoConfigData hiidoData = pHiidoCore.getHiidoData();
        Map pClickMap = (Map)hiidoData.hiidoMap.get("plug_id_" + pluginInfo.pluginId);
        if (null != pClickMap && null != (clickEventID = this.mIsOw ? (String)pClickMap.get("anchor") : (String)pClickMap.get("user"))) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51710", clickEventID);
        }
        if (pluginInfo.pluginId != Long.MIN_VALUE) {
            this.setNewPluginClick(pluginInfo);
            PluginCenterController.INSTANCE.loadPlugin(pluginInfo, null, this.getCurActivedPlugin() == null);
        }
    }

    private void startMultiPlugins(SinglePluginInfo pluginInfo) {
        if (null == this.getView() || null == pluginInfo || "\u656c\u8bf7\u671f\u5f85".equals(pluginInfo.pluginName)) {
            return;
        }
        ((PluginCenterComponent)this.getView()).onMultiPluginsSelect(pluginInfo.pluginId, pluginInfo.getAndroidId());
    }

    private boolean canStartPlugin() {
        if (((ILiveConfigCore)ICoreManagerBase.getCore(ILiveConfigCore.class)).getLiveType() != LiveConfigType.Normal) {
            SingleToastUtil.showToast((String)"\u8bf7\u5148\u7ed3\u675f\u201c\u8fde\u9ea6\u201d");
            return false;
        }
        return true;
    }

    private SinglePluginInfo getCurActivedPlugin() {
        IPluginCenterCore pluginCenterCore = (IPluginCenterCore)CoreFactory.getCore(IPluginCenterCore.class);
        if (null != pluginCenterCore) {
            return pluginCenterCore.getCurrentActivatedPlugin();
        }
        return null;
    }

    private void setNewPluginClick(SinglePluginInfo p) {
        if (p.isNewPlugin) {
            p.isNewPlugin = false;
            String identification = "";
            if (p.pluginId != Long.MIN_VALUE) {
                identification = String.valueOf(p.pluginId);
            } else if (p instanceof ExSinglePluginInfo) {
                identification = ((ExSinglePluginInfo)p).identification;
            }
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setNewPluginClick(identification);
            if (!((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).hasNewPlugin()) {
                RxBus.getDefault().post((Object)new IPluginCenterClient_clickAllNewPlugin_EventArgs());
            }
        }
    }

    private void reportGameClickStatistic(SinglePluginInfo pluginInfo) {
        Property property = new Property();
        property.putString("key1", String.valueOf(pluginInfo.pluginId));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51320", "0002", (Serializable)property);
    }

    private void reportGameClickMutexStatistic(SinglePluginInfo pluginInfo) {
        Property property = new Property();
        property.putString("key1", String.valueOf(pluginInfo.pluginId));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51320", "0003", (Serializable)property);
    }

    protected void onDestroy() {
        this.onEventUnBind();
        RxUtils.dispose((Disposable)this.mDisposables);
        super.onDestroy();
    }
}

