/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.fullservicebroadcast;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.fullservicebroadcast.BroadcastLinearLayout;
import com.yy.mobile.ui.turntable.core.TurnTableAnimationResManager;
import com.yy.mobile.ui.utils.YYDownloadUtils;
import com.yy.mobile.ui.y2a.Y2AFileDownloader;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.y2aplayerandroid.Y2APlayer;
import com.yy.y2aplayerandroid.Y2APlayerListener;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BroadcastAnimationView
extends RelativeLayout {
    private static final String TAG = "BroadcastAnimationView";
    private static final int PLAY_SVGA = 1;
    private static final int checkTypeFromAsset = 1;
    private static final int checkTypeFromSdcard = 2;
    private SVGAImageView svgaImageView;
    private Context mContext;
    private Y2APlayer mPlayer;
    private BroadcastLinearLayout banner;
    private int screenW = 0;
    private int type = 0;
    private int level = 0;
    private boolean isStop = true;
    private String[] svgaFileNames = new String[]{"goldbonus.y2a", "diamondbonus.y2a", "goldballoon.y2a", "diamondballoon.y2a"};
    private Disposable y2aDisposable;
    private Map<String, Boolean> cacheCheckFiles = new HashMap<String, Boolean>();
    private UnZipCheckSvgaResRunnable unZipCheckSvgaResRunnable;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                String fileName = (String)msg.obj;
                if (BroadcastAnimationView.this.mPlayer != null) {
                    if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                        BroadcastAnimationView.this.mPlayer.load(fileName);
                        BroadcastAnimationView.this.mPlayer.play(1.0f, 1);
                    } else {
                        BroadcastAnimationView.this.post(BroadcastAnimationView.this.scaleRunnable);
                    }
                }
            }
        }
    };
    private Runnable bannerRunnable = new Runnable(){

        @Override
        public void run() {
            if (BroadcastAnimationView.this.banner != null) {
                BroadcastAnimationView.this.banner.playTotalAnim();
            }
        }
    };
    private Runnable visibleRunnable = new Runnable(){

        @Override
        public void run() {
            if (BroadcastAnimationView.this.isStop) {
                BroadcastAnimationView.this.setVisibility(8);
            } else {
                BroadcastAnimationView.this.setVisibility(0);
            }
        }
    };
    private Runnable scaleRunnable = new Runnable(){

        @Override
        public void run() {
            if (BroadcastAnimationView.this.mPlayer == null) {
                return;
            }
            Point p = BroadcastAnimationView.this.mPlayer.getY2ASizer();
            MLog.info((Object)BroadcastAnimationView.TAG, (String)("screenW=" + BroadcastAnimationView.this.screenW + " x=" + p.x + " y=" + p.y), (Object[])new Object[0]);
            int height = 0;
            if (p.x > 0) {
                height = Math.round((float)BroadcastAnimationView.this.screenW * ((float)p.y / (float)p.x));
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(BroadcastAnimationView.this.screenW, height);
                lp.topMargin = BroadcastAnimationView.this.level == 2 || BroadcastAnimationView.this.level == 3 ? -((int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)BasicConfig.getInstance().getAppContext())) : (BroadcastAnimationView.this.level == 5 ? -((int)ResolutionUtils.convertDpToPixel((float)75.0f, (Context)BasicConfig.getInstance().getAppContext())) : (BroadcastAnimationView.this.level == 100 ? -((int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)BasicConfig.getInstance().getAppContext())) : (BroadcastAnimationView.this.level == 65281 || BroadcastAnimationView.this.level == 65282 ? -((int)ResolutionUtils.convertDpToPixel((float)8.0f, (Context)BasicConfig.getInstance().getAppContext())) : -((int)ResolutionUtils.convertDpToPixel((float)43.0f, (Context)BasicConfig.getInstance().getAppContext())))));
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)BroadcastAnimationView.TAG, (String)("[scaleRunnable],topMargin:::" + lp.topMargin), (Object[])new Object[0]);
                }
                lp.addRule(14);
                BroadcastAnimationView.this.mPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                BroadcastAnimationView.this.mPlayer.requestLayout();
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(BroadcastAnimationView.this.screenW, -2);
            if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                if (BroadcastAnimationView.this.level == 2 || BroadcastAnimationView.this.level == 3 || BroadcastAnimationView.this.level == 5 || BroadcastAnimationView.this.level == 100 || BroadcastAnimationView.this.level == 65282 || BroadcastAnimationView.this.level == 65281) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)BroadcastAnimationView.TAG, (String)("level range [scaleRunnable],topMargin:::" + layoutParams.topMargin), (Object[])new Object[0]);
                    }
                    layoutParams.topMargin = (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext()) - BroadcastAnimationView.this.banner.getMeasuredHeight() + (int)ResolutionUtils.convertDpToPixel((float)17.0f, (Context)BasicConfig.getInstance().getAppContext());
                } else {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)BroadcastAnimationView.TAG, (String)("level outsize [scaleRunnable],topMargin:::" + layoutParams.topMargin), (Object[])new Object[0]);
                    }
                    layoutParams.topMargin = (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext());
                }
            } else if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)BroadcastAnimationView.TAG, (String)"current is game teplate ", (Object[])new Object[0]);
            }
            layoutParams.addRule(14);
            BroadcastAnimationView.this.banner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    };
    private Y2APlayerListener y2APlayerListener = new Y2APlayerListener(){

        public void onLoaded(int errorCode) {
            MLog.info((Object)BroadcastAnimationView.TAG, (String)("onLoaded errorCode=" + errorCode), (Object[])new Object[0]);
            if (BroadcastAnimationView.this.mPlayer != null) {
                BroadcastAnimationView.this.mPlayer.play(1.0f, 1);
            }
        }

        public void onPlayed(int errorCode) {
            MLog.info((Object)BroadcastAnimationView.TAG, (String)("onPlayed errorCode=" + errorCode), (Object[])new Object[0]);
            BroadcastAnimationView.this.isStop = false;
            BroadcastAnimationView.this.post(BroadcastAnimationView.this.scaleRunnable);
        }

        public void onStopped() {
            MLog.info((Object)BroadcastAnimationView.TAG, (String)"wwd Player onStopped!", (Object[])new Object[0]);
            BroadcastAnimationView.this.isStop = true;
            if (BroadcastAnimationView.this.mPlayer != null) {
                BroadcastAnimationView.this.mPlayer.stop();
            }
        }

        public void onDestroyed() {
        }
    };

    public BroadcastAnimationView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public BroadcastAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        if (this.mContext == null) {
            return;
        }
        this.screenW = this.getScreenWidth();
        this.banner = new BroadcastLinearLayout(this.mContext);
        this.addView((View)this.banner);
        if (this.mPlayer == null) {
            this.mPlayer = new Y2APlayer(this.mContext);
            this.mPlayer.setListener(this.y2APlayerListener);
            this.addView((View)this.mPlayer);
        }
        if (this.svgaImageView == null) {
            this.svgaImageView = new SVGAImageView(this.mContext);
            this.svgaImageView.setBackgroundColor(0);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)200.0f, (Context)BasicConfig.getInstance().getAppContext()));
            layoutParams.addRule(14);
            layoutParams.addRule(10);
            this.svgaImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView((View)this.svgaImageView);
        }
    }

    public View getBanner() {
        return this.banner;
    }

    public BroadcastLinearLayout getRealBanner() {
        return this.banner;
    }

    public void setBannerData(long sid, SpannableString span, int type, int level, String bannerBkgUrl) {
        this.level = level;
        this.type = type;
        if (this.banner == null) {
            return;
        }
        if (span != null) {
            this.banner.setTxtInfo(span);
        }
        if (type == 100) {
            this.banner.setCommonSid(sid);
        } else {
            this.banner.setSid(sid);
        }
        if (type == 1) {
            this.banner.setHengFuBg(R.drawable.red_packet_gold_bg);
            this.banner.setSidBg(R.drawable.red_packet_sid_bg);
            this.banner.setTextType(0);
        } else if (type == 2) {
            this.banner.setHengFuBg(R.drawable.red_packet_diamond_bg);
            this.banner.setSidBg(R.drawable.red_packet_sid_bg);
            this.banner.setTextType(0);
        } else if (type == 3) {
            this.banner.setHengFuBg(R.drawable.hotball_gold_new_bg);
            this.banner.setSidBg(R.drawable.hotball_sid_new_bg);
            this.banner.setTextType(1);
        } else if (type == 4) {
            this.banner.setHengFuBg(R.drawable.hotball_diamond_bg);
            this.banner.setSidBg(R.drawable.hotball_sid_new_bg);
            this.banner.setTextType(1);
        } else if (type == 6) {
            this.banner.setHengFuBg(R.drawable.cherryblossoms_diamond_bg);
            this.banner.setSidBg(R.drawable.cb_broadcast_diamond_sidbg);
            this.banner.setTextType(1);
        } else if (type == 5) {
            this.banner.setHengFuBg(R.drawable.cherryblossoms_god_bg);
            this.banner.setSidBg(R.drawable.cb_broadcast_god_sidbg);
            this.banner.setTextType(1);
        } else if (type == 100) {
            if (StringUtils.isEmpty((String)bannerBkgUrl).booleanValue()) {
                this.banner.setHengFuBg(R.drawable.hotball_diamond_bg);
                this.banner.setSidBg(R.drawable.hotball_sid_new_bg);
                this.banner.setTextType(1);
            } else {
                this.banner.setHengFuUrlBkg(bannerBkgUrl);
                this.banner.setTextType(1);
            }
        }
    }

    public void play() {
        if (this.mPlayer == null || this.svgaFileNames.length < 4) {
            return;
        }
        if (this.type == 1) {
            this.playSvgaAnimation(this.svgaFileNames[0]);
            this.postDelayed(this.bannerRunnable, 500L);
        } else if (this.type == 2) {
            this.playSvgaAnimation(this.svgaFileNames[1]);
            this.postDelayed(this.bannerRunnable, 800L);
        } else if (this.type == 3) {
            this.playSvgaAnimation(this.svgaFileNames[2]);
            this.postDelayed(this.bannerRunnable, 500L);
        } else if (this.type == 4) {
            this.playSvgaAnimation(this.svgaFileNames[3]);
            this.postDelayed(this.bannerRunnable, 800L);
        } else if (this.type == 6 || this.type == 5) {
            int delayTime;
            String path;
            if (this.type == 6) {
                path = CommonPref.instance().getString("diamond");
                delayTime = 800;
            } else {
                path = CommonPref.instance().getString("gold");
                delayTime = 500;
            }
            String y2aFile = YYDownloadUtils.getInstance().getY2aFileName(path);
            this.playSvgaAnimationBySdCard(TurnTableAnimationResManager.getInstance().getResRootDir(), y2aFile);
            this.postDelayed(this.bannerRunnable, delayTime);
        }
    }

    public void playBannerAnimation() {
        this.post(this.bannerRunnable);
    }

    private void playSvgaAnimation(String fileName) {
        if (StringUtils.isEmpty((String)fileName).booleanValue()) {
            return;
        }
        this.y2aDisposable = Y2AFileDownloader.downloadY2AFile((String)fileName).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<File>(){

            public void accept(File file) throws Exception {
                if (BroadcastAnimationView.this.mPlayer != null) {
                    if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                        BroadcastAnimationView.this.mPlayer.load(file.getAbsolutePath());
                        BroadcastAnimationView.this.mPlayer.play(1.0f, 1);
                    } else {
                        BroadcastAnimationView.this.post(BroadcastAnimationView.this.scaleRunnable);
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    private void playSvgaAnimationBySdCard(String resRoot, String fileName) {
        if (StringUtils.isEmpty((String)fileName).booleanValue()) {
            return;
        }
        String savePath = resRoot + File.separator + fileName.replace(".y2a", "");
        String y2aFile = savePath + File.separator + fileName.replace(".y2a", ".a2m");
        this.doLogic(fileName, resRoot, savePath, y2aFile, 2);
    }

    public int getScreenWidth() {
        Point p = this.getScreenSize(this.mContext, null);
        return p.x < p.y ? p.x : p.y;
    }

    public Point getScreenSize(Context context, Point outSize) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        return ret;
    }

    public void playCommonY2aAnimation(String y2aFilePath) {
        if (this.mPlayer != null) {
            this.mPlayer.load(y2aFilePath);
            this.postDelayed(this.bannerRunnable, 500L);
        }
    }

    public void playCommonSvgaAnimation(String path) {
        this.post(this.scaleRunnable);
        Glide.with((Context)this.mContext).as(SVGAVideoEntity.class).load(path).into((Target)new SimpleTarget<SVGAVideoEntity>(){

            public void onResourceReady(@NonNull SVGAVideoEntity svgaVideoEntity, @Nullable Transition<? super SVGAVideoEntity> transition) {
                MLog.info((Object)BroadcastAnimationView.TAG, (String)"parseAndStartSvgaAnim complete", (Object[])new Object[0]);
                BroadcastAnimationView.this.startSvgaAnim(svgaVideoEntity, new SVGACallback(){

                    public void onPause() {
                        MLog.info((Object)"CommonFuncNoticeController", (String)"->playSvga onPause ", (Object[])new Object[0]);
                    }

                    public void onFinished() {
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                    }
                });
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                MLog.error((Object)BroadcastAnimationView.TAG, (String)"playSvga error =", (Object[])new Object[0]);
            }
        });
        this.postDelayed(this.bannerRunnable, 500L);
    }

    public void startSvgaAnim(SVGAVideoEntity svgaVideoEntity, SVGACallback callback2) {
        this.svgaImageView.stopAnimation();
        this.svgaImageView.setCallback(callback2);
        SVGADrawable svgaDrawable = new SVGADrawable(svgaVideoEntity);
        this.svgaImageView.setImageDrawable((Drawable)svgaDrawable);
        this.svgaImageView.setLoops(1);
        this.svgaImageView.startAnimation();
    }

    public void onDestroy() {
        this.removeCallbacks(this.bannerRunnable);
        this.removeCallbacks(this.scaleRunnable);
        this.removeCallbacks(this.visibleRunnable);
        YYTaskExecutor.removeTask((Runnable)this.unZipCheckSvgaResRunnable);
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.close();
            this.mPlayer.setListener(null);
            this.mPlayer = null;
        }
        if (this.banner != null) {
            this.banner.onDestroy();
            this.banner = null;
        }
        this.cacheCheckFiles.clear();
        this.handler.removeCallbacksAndMessages(null);
        if (this.y2aDisposable != null) {
            this.y2aDisposable.dispose();
        }
    }

    private boolean chenckAndUnpackZip(BufferedInputStream inputStream, String outputDir) {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(inputStream);
            byte[] buffer = new byte[1024];
            while ((ze = zis.getNextEntry()) != null) {
                String filename = ze.getName();
                if (ze.isDirectory()) {
                    File fmd = new File(outputDir + filename);
                    fmd.mkdirs();
                    continue;
                }
                File file = new File(outputDir + filename);
                int fileSize = 0;
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    fileSize = fis.available();
                    fis.close();
                }
                if ((long)fileSize != ze.getSize()) {
                    int count;
                    FileOutputStream fout = new FileOutputStream(outputDir + filename);
                    while ((count = zis.read(buffer)) != -1) {
                        fout.write(buffer, 0, count);
                    }
                    fout.close();
                }
                zis.closeEntry();
            }
            zis.close();
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            FileUtil.removeDir((String)outputDir);
            return false;
        }
        return true;
    }

    private void doLogic(String fileName, String svgaRootPath, String savePath, String y2aFile, int type) {
        if (this.cacheCheckFiles.get(fileName) == null || this.cacheCheckFiles.get(fileName) != null && !this.cacheCheckFiles.get(fileName).booleanValue()) {
            if (this.unZipCheckSvgaResRunnable == null) {
                this.unZipCheckSvgaResRunnable = new UnZipCheckSvgaResRunnable();
            }
            this.unZipCheckSvgaResRunnable.setType(fileName);
            this.unZipCheckSvgaResRunnable.setFileMessage(svgaRootPath, savePath, y2aFile, type);
            YYTaskExecutor.execute((Runnable)this.unZipCheckSvgaResRunnable);
        } else if (this.mPlayer != null) {
            if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                this.mPlayer.load(y2aFile);
                this.mPlayer.play(1.0f, 1);
            } else {
                this.post(this.scaleRunnable);
            }
        }
    }

    public class UnZipCheckSvgaResRunnable
    implements Runnable {
        private String mY2aFilePath;
        private String svgaFilePath;
        private String mY2aFile;
        private int doType;
        private String key;

        public void setType(String key) {
            this.key = key;
        }

        public void setFileMessage(String mY2aFilePath, String svgaFilePath, String mY2aFile, int type) {
            this.mY2aFilePath = mY2aFilePath;
            this.svgaFilePath = svgaFilePath;
            this.mY2aFile = mY2aFile;
            this.doType = type;
        }

        @Override
        public void run() {
            try {
                boolean hasRoot = true;
                File rootFile = new File(this.mY2aFilePath);
                if (!rootFile.exists()) {
                    hasRoot = rootFile.mkdir();
                }
                if (hasRoot) {
                    InputStream inputStream = null;
                    if (this.doType == 1) {
                        inputStream = BroadcastAnimationView.this.mContext.getAssets().open("svga" + File.separator + this.key);
                    } else if (this.doType == 2) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.mY2aFilePath).append(File.separator).append(this.key);
                        inputStream = new FileInputStream(sb.toString());
                    }
                    if (inputStream == null) {
                        MLog.info((Object)BroadcastAnimationView.TAG, (String)"inputStream is null!", (Object[])new Object[0]);
                        return;
                    }
                    BufferedInputStream ins = new BufferedInputStream(inputStream);
                    boolean hasDir = true;
                    File resFile = new File(this.svgaFilePath);
                    if (!resFile.exists()) {
                        hasDir = resFile.mkdir();
                    }
                    if (hasDir) {
                        BroadcastAnimationView.this.chenckAndUnpackZip(ins, resFile + File.separator);
                    }
                    ins.close();
                }
                BroadcastAnimationView.this.cacheCheckFiles.put(this.key, true);
            }
            catch (Exception e) {
                BroadcastAnimationView.this.cacheCheckFiles.put(this.key, false);
                MLog.error((Object)BroadcastAnimationView.TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            Message msg = new Message();
            msg.what = 1;
            msg.obj = this.mY2aFile;
            BroadcastAnimationView.this.handler.sendMessage(msg);
        }
    }
}

