/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IWeekStarClient_onDanGradeWeekStarNotify_EventArgs;
import com.duowan.mobile.entlive.events.IWeekStarClient_weekStarUIclose_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.events.ICavalierClient_onTaskFinish_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_closeActWindow_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_openLowLayoutActWindow_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.common.CommomDialogViewController$$EventBinder;
import com.yy.mobile.ui.common.CommonDialogView;
import com.yy.mobile.ui.common.DialogViewEntity;
import com.yy.mobile.ui.utils.CommonWebPopupComponent;
import com.yy.mobile.ui.weekstar.WeekStarSvgaPlay;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CommomDialogViewController
implements EventCompat {
    private static final String TAG = "CommomDialogViewController";
    public static final int URL_PARSER_TYPE = 1;
    public static final int URL_TYPE = 2;
    private String urlConfig = "http://earn.yystatic.com/earn/file/all/window/1.0.0/task_window.txt";
    private CommonDialogView commonDialogView;
    private RelativeLayout container;
    protected Context context;
    private int pWidth;
    private int pHeight;
    private int lWidth;
    private int lHeight;
    protected WeekStarSvgaPlay weekStarSvgaPlay;
    private boolean isShow = true;
    protected RelativeLayout weekStarRelativeLayout;
    private boolean chatInputSwitch = false;
    private boolean isLandscape = false;
    private HashMap<Integer, String> taskUrlMap = new HashMap();
    private LinkedList<Integer> taskIdLinkedList = new LinkedList();
    private RelativeLayout.LayoutParams closeBtnParams;
    private RecycleImageView closeBtnRiv;
    private int padding = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)BasicConfig.getInstance().getAppContext());
    private CommonWebPopupComponent commonWebPopupComponent;
    private String reg = "[^\\s]*=[^\\s]*";
    private Pattern pattern;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            int taskId = msg.what;
            if (CommomDialogViewController.this.taskUrlMap.containsKey(taskId)) {
                String url = (String)CommomDialogViewController.this.taskUrlMap.get(taskId);
                CommomDialogViewController.this.showYearTaskDialog(url);
            }
        }
    };
    private ResponseListener<String> successListener = new ResponseListener<String>(){

        public void onResponse(String response) {
            block6: {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)CommomDialogViewController.TAG, (String)("wwd successListener==>response=" + response), (Object[])new Object[0]);
                }
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    String strTaskUrl10 = jsonObject.optString("32768");
                    String strTaskUrl66 = jsonObject.optString("65536");
                    String strPadding = jsonObject.optString("padding");
                    if (!strPadding.equals("")) {
                        CommomDialogViewController.this.padding = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)strPadding) / 2), (Context)BasicConfig.getInstance().getAppContext());
                    }
                    if (!strTaskUrl10.equals("")) {
                        CommomDialogViewController.this.taskUrlMap.put(32768, strTaskUrl10);
                    }
                    if (!strTaskUrl66.equals("")) {
                        CommomDialogViewController.this.taskUrlMap.put(65536, strTaskUrl66);
                    }
                    int taskId = (Integer)CommomDialogViewController.this.taskIdLinkedList.pollFirst();
                    Message msg = new Message();
                    msg.what = taskId;
                    CommomDialogViewController.this.handler.sendMessage(msg);
                }
                catch (Exception e) {
                    if (!MLog.isLogLevelAboveDebug()) break block6;
                    MLog.debug((Object)CommomDialogViewController.TAG, (String)("wwd parser error e:" + e.toString()), (Object[])new Object[0]);
                }
            }
        }
    };
    private ResponseErrorListener errorListener = new ResponseErrorListener(){

        public void onErrorResponse(RequestError error) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)CommomDialogViewController.TAG, (String)("wwd errorListener===>error=" + error.toString()), (Object[])new Object[0]);
            }
        }
    };
    private LinkedList<DialogViewEntity> dveLinkedList = new LinkedList();
    protected boolean dialogIsShow = false;
    private EventBinder mCommomDialogViewControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mCommomDialogViewControllerSniperEventBinder == null) {
            this.mCommomDialogViewControllerSniperEventBinder = new CommomDialogViewController$$EventBinder();
        }
        this.mCommomDialogViewControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mCommomDialogViewControllerSniperEventBinder != null) {
            this.mCommomDialogViewControllerSniperEventBinder.unBindEvent();
        }
    }

    public CommomDialogViewController(Context context, RelativeLayout weekStarRelativeLayout) {
        this.context = context;
        ICoreManagerBase.addClient((Object)this);
        this.weekStarRelativeLayout = weekStarRelativeLayout;
        this.pattern = Pattern.compile(this.reg);
    }

    public void setlHeight(int lHeight) {
        this.lHeight = lHeight;
    }

    public void setlWidth(int lWidth) {
        this.lWidth = lWidth;
    }

    public void setpHeight(int pHeight) {
        this.pHeight = pHeight;
    }

    public void setpWidth(int pWidth) {
        this.pWidth = pWidth;
    }

    public void createDilaog(RelativeLayout container, String url, int type, boolean needCloseButton) {
        this.container = container;
        if (this.commonDialogView == null) {
            this.commonDialogView = new CommonDialogView(this.context);
            if (type == 2) {
                this.commonDialogView.parserUrlConfig(url).build();
            } else if (type == 1) {
                if (this.isLandscape) {
                    this.commonDialogView.setUrl(url).setWidth(this.lWidth).setHeight(this.lHeight).build();
                } else {
                    this.commonDialogView.setUrl(url).setWidth(this.pWidth).setHeight(this.pHeight).build();
                }
            }
            if (container.indexOfChild((View)this.commonDialogView) != -1) {
                container.removeView((View)this.commonDialogView);
            }
            if (needCloseButton) {
                if (this.closeBtnRiv == null) {
                    this.closeBtnRiv = new RecycleImageView(this.context);
                    this.closeBtnRiv.setBackgroundResource(R.drawable.year_pk_close_btn);
                    this.closeBtnRiv.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CommomDialogViewController.this.dismissDialog();
                            CommomDialogViewController.this.dialogIsShow = false;
                            CommomDialogViewController.this.nextDialogShow();
                        }
                    });
                }
                if (this.closeBtnParams == null) {
                    this.closeBtnParams = new RelativeLayout.LayoutParams(-2, -2);
                    this.closeBtnParams.addRule(11);
                    this.closeBtnParams.setMargins(0, this.padding, this.padding, 0);
                }
                if (this.commonDialogView.indexOfChild((View)this.closeBtnRiv) > -1) {
                    this.commonDialogView.removeView((View)this.closeBtnRiv);
                }
                this.commonDialogView.addView((View)this.closeBtnRiv, (ViewGroup.LayoutParams)this.closeBtnParams);
            }
            container.addView((View)this.commonDialogView);
        }
    }

    public void onResume() {
        this.isShow = true;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"chenjie002", (String)("[onResume],come on,isShow::" + this.isShow), (Object[])new Object[0]);
        }
    }

    public void onOrientationChanges(boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public void onPause() {
        this.isShow = false;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"chenjie002", (String)("[onPause],come on,isShow::" + this.isShow), (Object[])new Object[0]);
        }
    }

    public void dismissWeekStarSvga() {
        if (this.weekStarSvgaPlay != null) {
            this.weekStarSvgaPlay.onDestroy();
        }
    }

    public void dismissDialog() {
        if (this.commonDialogView != null) {
            this.commonDialogView.onDisponse();
            this.container.removeView((View)this.commonDialogView);
        }
        this.commonDialogView = null;
    }

    public void onDisponse() {
        ICoreManagerBase.removeClient((Object)this);
        if (this.weekStarSvgaPlay != null) {
            this.weekStarSvgaPlay.onDestroy();
        }
        this.successListener = null;
        this.errorListener = null;
        this.taskIdLinkedList.clear();
        this.taskUrlMap.clear();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onDanGradeWeekStarNotify(IWeekStarClient_onDanGradeWeekStarNotify_EventArgs busEventArgs) {
        long anchorid = busEventArgs.mAnchorid;
        long topcid = busEventArgs.mTopcid;
        long subcid = busEventArgs.mSubcid;
        String anchorNick = busEventArgs.mAnchorNick;
        int danGrade = busEventArgs.mDanGrade;
        String chestId = busEventArgs.mChestId;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"chenjie002", (String)("[onDanGradeWeekStarNotify],giftComponentController,come one,isShow::" + this.isShow), (Object[])new Object[0]);
        }
        if (!this.isShow) {
            return;
        }
        ChannelInfo channelInfo = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        if (channelInfo == null) {
            return;
        }
        if (channelInfo.topSid != topcid && channelInfo.subSid != subcid) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("WeekStarGrabChestModule:[onDanGradeWeekStarNotify],anchorid::" + anchorid), (Object[])new Object[0]);
        }
        if (anchorid == LoginUtil.getUid()) {
            return;
        }
        DialogViewEntity entity = new DialogViewEntity();
        entity.type = 1;
        entity.anchorid = anchorid;
        entity.danGrade = danGrade;
        entity.chestId = chestId;
        entity.anchorNick = anchorNick;
        this.dveLinkedList.addLast(entity);
        this.nextDialogShow();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void weekStarUIclose(IWeekStarClient_weekStarUIclose_EventArgs busEventArgs) {
        this.dialogIsShow = false;
        this.nextDialogShow();
    }

    protected void weekStarPlayEffect(int danGrade, String anchorNick, long anchorid, String chestId) {
        this.dialogIsShow = true;
        if (this.weekStarSvgaPlay == null && this.context instanceof FragmentActivity) {
            this.weekStarSvgaPlay = new WeekStarSvgaPlay((FragmentActivity)this.context, (ViewGroup)this.weekStarRelativeLayout);
        }
        if (this.weekStarSvgaPlay != null) {
            this.weekStarSvgaPlay.setData(danGrade, anchorNick, anchorid, chestId);
            this.weekStarSvgaPlay.play();
        }
    }

    private void onShowCommonDilaogView(String url, int type, boolean needCloseButton) {
        this.dialogIsShow = true;
        this.createDilaog(this.weekStarRelativeLayout, url, type, needCloseButton);
    }

    public void nextDialogShow() {
        if (!this.dialogIsShow && this.dveLinkedList.size() > 0 && !this.chatInputSwitch) {
            DialogViewEntity entity = this.dveLinkedList.pollFirst();
            if (entity.type == 1) {
                this.weekStarPlayEffect(entity.danGrade, entity.anchorNick, entity.anchorid, entity.chestId);
            } else {
                this.setpWidth(entity.pw);
                this.setpHeight(entity.ph);
                this.setlWidth(entity.lw);
                this.setlHeight(entity.lh);
                this.onShowCommonDilaogView(entity.url, entity.urlType, entity.needCloseButton);
            }
        }
    }

    @BusEvent(sync=true)
    public void onTaskFinish(ICavalierClient_onTaskFinish_EventArgs busEventArgs) {
        int hintType = busEventArgs.getHintType();
        int currentTaskId = busEventArgs.getCurrentTaskId();
        int nextTaskId = busEventArgs.getNextTaskId();
        String currentTaskName = busEventArgs.getCurrentTaskName();
        String taskTypeName = busEventArgs.getTaskTypeName();
        if (currentTaskId == 32768 || currentTaskId == 65536) {
            if (this.taskUrlMap.containsKey(currentTaskId)) {
                String url = this.taskUrlMap.get(currentTaskId);
                this.showYearTaskDialog(url);
            } else {
                this.taskIdLinkedList.addLast(currentTaskId);
                RequestManager.instance().submitStringQueryRequest(this.urlConfig, null, this.successListener, this.errorListener, false);
            }
        }
    }

    @BusEvent
    public void openLowLayoutActWindow(IWebViewClient_openLowLayoutActWindow_EventArgs busEventArgs) {
        block6: {
            String params = busEventArgs.getParams();
            if (!LoginUtil.isLogined()) {
                return;
            }
            if (((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                return;
            }
            MLog.info((Object)TAG, (String)("wwd openLowLayoutActWindow params=" + params), (Object[])new Object[0]);
            try {
                JSONObject jsonObject = new JSONObject(params);
                DialogViewEntity entity = new DialogViewEntity();
                String actUrl = jsonObject.optString("actUrl");
                String portrait = jsonObject.optString("portrait");
                String landscape = jsonObject.optString("landscape");
                if (!portrait.equals("")) {
                    JSONObject pSizeData = new JSONObject(portrait);
                    int pW = pSizeData.optInt("width");
                    int pH = pSizeData.optInt("height");
                    entity.pw = (int)ResolutionUtils.convertDpToPixel((float)(pW / 2), (Context)BasicConfig.getInstance().getAppContext());
                    entity.ph = (int)ResolutionUtils.convertDpToPixel((float)(pH / 2), (Context)BasicConfig.getInstance().getAppContext());
                }
                if (!landscape.equals("")) {
                    JSONObject lSizeData = new JSONObject(landscape);
                    int lW = lSizeData.optInt("width");
                    int lH = lSizeData.optInt("height");
                    entity.lw = (int)ResolutionUtils.convertDpToPixel((float)(lW / 2), (Context)BasicConfig.getInstance().getAppContext());
                    entity.lh = (int)ResolutionUtils.convertDpToPixel((float)(lH / 2), (Context)BasicConfig.getInstance().getAppContext());
                }
                entity.type = 2;
                entity.url = actUrl;
                entity.urlType = 1;
                entity.needCloseButton = true;
                this.dveLinkedList.add(entity);
                this.nextDialogShow();
            }
            catch (Exception e) {
                if (!MLog.isLogLevelAboveDebug()) break block6;
                MLog.debug((Object)TAG, (String)("wwd error:" + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    @BusEvent
    public void closeActWindow(IWebViewClient_closeActWindow_EventArgs busEventArgs) {
        String params = busEventArgs.getParams();
        if (TextUtils.isEmpty((CharSequence)params)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(params);
            int windowType = jsonObject.optInt("windowType");
            if (windowType != 0) {
                this.dismissDialog();
                this.dialogIsShow = false;
                this.nextDialogShow();
            }
        }
        catch (JSONException e) {
            MLog.error((Object)"CommomDialogViewCtrller", (String)"Empty Catch on closeActWindow", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void setChatInputSwitch(boolean chatInputSwitch) {
        this.chatInputSwitch = chatInputSwitch;
    }

    private void showYearTaskDialog(String url) {
        UrlEntity entity = this.parserUrlConfig(url);
        if (TextUtils.isEmpty((CharSequence)entity.url)) {
            return;
        }
        if (this.commonWebPopupComponent == null) {
            this.commonWebPopupComponent = new CommonWebPopupComponent();
        }
        entity.url = entity.url + "?pf=2";
        MLog.info((Object)TAG, (String)("wwd yearTaskDialog url=" + entity.url), (Object[])new Object[0]);
        this.commonWebPopupComponent.setUrl(entity.url).setWidth(entity.width).setHeight(entity.height).setBackground(true).setBackgroundTransparent(true).setCanceledOnTouchOutside(false).setGravity(17).setWebViewEventListener(null).show(((FragmentActivity)this.context).getSupportFragmentManager(), "YearTaskDialogTag");
    }

    private UrlEntity parserUrlConfig(String url) {
        UrlEntity entity = new UrlEntity();
        String[] infos = url.split("[?]");
        if (infos != null && infos.length > 0) {
            entity.url = infos[0];
            int index = 1;
            if (index < infos.length) {
                String[] extendsInfo;
                for (String extInfo : extendsInfo = infos[index].split("&")) {
                    Matcher matcher = this.pattern.matcher(extInfo);
                    if (!matcher.matches()) continue;
                    String[] keyValue = extInfo.split("=");
                    if (keyValue[0].equals("w")) {
                        entity.width = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)keyValue[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                        continue;
                    }
                    if (!keyValue[0].equals("h")) continue;
                    entity.height = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)keyValue[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                }
            }
        }
        return entity;
    }

    private static class UrlEntity {
        public String url;
        public int width;
        public int height;

        private UrlEntity() {
        }
    }
}

