/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channellinklist;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.image.RoundConerPressedImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ChannelLinkSubListAdapter
extends BaseExpandableListAdapter {
    private static final String TAG = "ChannelLinkSubListAdapter";
    private Context mContext;
    private WeakReference<ExpandableListView> mWeakReferenceListView;
    private List<ChannelInfo> mChannelInfoList = new ArrayList<ChannelInfo>();
    private TreeMap<Long, Integer> mOnlineCountMap = new TreeMap();
    private ViewGroup.MarginLayoutParams mChildMarginParams;

    public ChannelLinkSubListAdapter(Context context, ExpandableListView listView) {
        this.mContext = context;
        this.mWeakReferenceListView = new WeakReference<ExpandableListView>(listView);
        this.mChildMarginParams = new ViewGroup.MarginLayoutParams(-2, -2);
        this.mChildMarginParams.setMargins(this.mContext.getResources().getDimensionPixelSize(R.dimen.sub_channel_child_margin_left), 0, 0, 0);
    }

    public List<ChannelInfo> getData() {
        return this.mChannelInfoList;
    }

    public void setData(List<ChannelInfo> list2) {
        if (list2 != null) {
            this.mChannelInfoList = new ArrayList<ChannelInfo>(list2);
        }
    }

    public TreeMap<Long, Integer> getOnlineCountMap() {
        return this.mOnlineCountMap;
    }

    public void setOnlineCountMap(TreeMap<Long, Integer> map) {
        try {
            if (map != null) {
                boolean isUpdate = false;
                for (Long key : map.keySet()) {
                    if (!isUpdate && this.mOnlineCountMap.containsKey(key) && this.mOnlineCountMap.get(key).longValue() != map.get(key).longValue()) {
                        isUpdate = true;
                    }
                    this.mOnlineCountMap.put(key, map.get(key));
                }
                this.notifyDataSetChanged();
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    public int getGroupCount() {
        return this.mChannelInfoList.size();
    }

    public int getChildrenCount(int groupPosition) {
        return this.getGroup((int)groupPosition).subChannelList == null ? 0 : this.getGroup((int)groupPosition).subChannelList.size();
    }

    public ChannelInfo getGroup(int groupPosition) {
        if (this.mChannelInfoList != null && groupPosition < this.mChannelInfoList.size() && groupPosition >= 0) {
            return this.mChannelInfoList.get(groupPosition);
        }
        return null;
    }

    public ChannelInfo getChild(int groupPosition, int childPosition) {
        ChannelInfo info = this.getGroup(groupPosition);
        if (info != null && info.subChannelList != null && info.subChannelList.size() > childPosition && childPosition >= 0) {
            return (ChannelInfo)info.subChannelList.get(childPosition);
        }
        return null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(final int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        HeaderViewHolder holder;
        if (convertView == null) {
            holder = new HeaderViewHolder();
            convertView = this.createHeaderConvertView(holder);
        } else {
            holder = (HeaderViewHolder)convertView.getTag();
        }
        ChannelInfo item2 = this.getGroup(groupPosition);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("getGroupView, groupPosition = " + groupPosition + ", channelInfo = " + item2), (Object[])new Object[0]);
        }
        if (item2 != null) {
            if (this.getChildrenCount(groupPosition) > 0) {
                if (isExpanded) {
                    holder.toggleIv.setImageResource(R.drawable.icon_zhankai);
                } else {
                    holder.toggleIv.setImageResource(R.drawable.icon_weizhankai);
                }
                holder.toggleIv.setVisibility(0);
                holder.toggleIv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ExpandableListView listView = (ExpandableListView)ChannelLinkSubListAdapter.this.mWeakReferenceListView.get();
                        if (listView != null) {
                            if (listView.isGroupExpanded(groupPosition)) {
                                listView.collapseGroup(groupPosition);
                            } else {
                                listView.expandGroup(groupPosition);
                            }
                        }
                    }
                });
            } else {
                holder.toggleIv.setVisibility(4);
            }
            if (item2.hasPassWord.booleanValue() && (item2.topSid == 0L || item2.topSid != item2.subSid)) {
                holder.logoIv.setImageResource(R.drawable.icon_channel_sublist_lock_default);
            } else {
                ImageLoader.loadImage((String)item2.channelLogo, (RecycleImageView)holder.logoIv, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.channel_icon_default, (int)R.drawable.channel_icon_default);
            }
            if (this.isCurrentChannel(item2)) {
                holder.titleTv.setTextColor(this.mContext.getResources().getColor(R.color.bg_high_light));
                convertView.setBackgroundColor(this.mContext.getResources().getColor(R.color.bg_current_sub_channel_two));
                holder.currentChannelView.setVisibility(0);
                holder.currentChannelView.setImageResource(R.drawable.living_music_anim);
                if (holder.currentChannelView.getDrawable() != null && holder.currentChannelView.getDrawable() instanceof AnimationDrawable) {
                    ((AnimationDrawable)holder.currentChannelView.getDrawable()).setOneShot(false);
                    ((AnimationDrawable)holder.currentChannelView.getDrawable()).start();
                }
            } else {
                holder.titleTv.setTextColor(this.mContext.getResources().getColor(R.color.live_common_color_1));
                convertView.setBackgroundColor(this.mContext.getResources().getColor(R.color.bg_current_sub_channel_two));
                holder.currentChannelView.setVisibility(4);
            }
            holder.titleTv.setText((CharSequence)item2.channelName);
            holder.countTv.setText((CharSequence)String.valueOf(this.getGroupOnlineCount(item2, false)));
        }
        return convertView;
    }

    public View createHeaderConvertView(HeaderViewHolder holder) {
        View convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_sub_channel_list, null);
        holder.toggleIv = (RecycleImageView)convertView.findViewById(R.id.iv_toggle);
        holder.logoIv = (RoundConerPressedImageView)convertView.findViewById(R.id.iv_logo);
        holder.titleTv = (TextView)convertView.findViewById(R.id.tv_channel_title);
        holder.countTv = (TextView)convertView.findViewById(R.id.tv_online_count);
        holder.currentChannelView = (ImageView)convertView.findViewById(R.id.iv_current_channel);
        convertView.setTag((Object)holder);
        return convertView;
    }

    public View createChildConvertView(ViewHolder holder) {
        View convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_sub_channel_list, null);
        holder.toggleIv = (RecycleImageView)convertView.findViewById(R.id.iv_toggle);
        holder.logoIv = (RoundConerPressedImageView)convertView.findViewById(R.id.iv_logo);
        holder.titleTv = (TextView)convertView.findViewById(R.id.tv_channel_title);
        holder.countTv = (TextView)convertView.findViewById(R.id.tv_online_count);
        holder.currentChannelView = (ImageView)convertView.findViewById(R.id.iv_current_channel);
        holder.toggleIv.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.mChildMarginParams));
        holder.toggleIv.setVisibility(4);
        convertView.setTag((Object)holder);
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = this.createChildConvertView(holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        ChannelInfo item2 = this.getChild(groupPosition, childPosition);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("getChildView, groupPosition = " + groupPosition + ", childPosition = " + childPosition + ", channelInfo = " + item2), (Object[])new Object[0]);
        }
        if (item2 != null) {
            if (item2.hasPassWord.booleanValue()) {
                holder.logoIv.setImageResource(R.drawable.icon_channel_sublist_lock_default);
            } else {
                ImageLoader.loadImage((String)item2.channelLogo, (RecycleImageView)holder.logoIv, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.channel_icon_default, (int)R.drawable.channel_icon_default);
            }
            if (this.isCurrentChannel(item2)) {
                holder.titleTv.setTextColor(this.mContext.getResources().getColor(R.color.bg_high_light));
                convertView.setBackgroundColor(this.mContext.getResources().getColor(R.color.bg_current_sub_channel_two));
                holder.currentChannelView.setVisibility(0);
                holder.currentChannelView.setImageResource(R.drawable.living_music_anim);
                if (holder.currentChannelView.getDrawable() != null && holder.currentChannelView.getDrawable() instanceof AnimationDrawable) {
                    ((AnimationDrawable)holder.currentChannelView.getDrawable()).setOneShot(false);
                    ((AnimationDrawable)holder.currentChannelView.getDrawable()).start();
                }
            } else {
                holder.titleTv.setTextColor(this.mContext.getResources().getColor(R.color.live_common_color_1));
                convertView.setBackgroundColor(this.mContext.getResources().getColor(R.color.bg_current_sub_channel_two));
                holder.currentChannelView.setVisibility(4);
            }
            holder.titleTv.setText((CharSequence)item2.channelName);
            holder.countTv.setText((CharSequence)String.valueOf(this.getChildOnlineCount(item2, true)));
        }
        return convertView;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    private int getGroupOnlineCount(ChannelInfo info, boolean override) {
        int count = this.getChildOnlineCount(info, false);
        try {
            if (info.subChannelList != null && info.subChannelList.size() > 0) {
                for (ChannelInfo item2 : info.subChannelList) {
                    count += this.getChildOnlineCount(item2, true);
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("getGroupOnlineCount error! " + throwable), (Object[])new Object[0]);
        }
        if (override) {
            info.onlineCount = count;
        }
        return count;
    }

    private int getChildOnlineCount(ChannelInfo info, boolean override) {
        int count;
        int n = count = this.mOnlineCountMap.get(info.subSid) == null ? 0 : this.mOnlineCountMap.get(info.subSid);
        if (count == 0) {
            count = info.onlineCount;
        } else if (override) {
            info.onlineCount = count;
        }
        return count;
    }

    public boolean isCurrentChannel(ChannelInfo info) {
        if (info != null) {
            return info.topSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid && (info.subSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid || info.subSid == ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid);
        }
        return false;
    }

    public class ViewHolder {
        public RecycleImageView toggleIv;
        public RoundConerPressedImageView logoIv;
        public TextView titleTv;
        public TextView countTv;
        public ImageView currentChannelView;
    }

    public static class HeaderViewHolder {
        public ImageView toggleIv;
        public RoundConerPressedImageView logoIv;
        public TextView titleTv;
        public TextView countTv;
        public ImageView currentChannelView;
    }
}

