/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.R2LDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.DanmuViewController;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.DrawHandler;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.BitMapPool;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.DanmakuTimer;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.SystemClock;
import com.yy.mobile.ui.basicgunview.danmucanvas.view.DanmakuTouchHelper;
import com.yy.mobile.ui.basicgunview.danmucanvas.view.DanmakuView;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;

public class DanmuViewCanvas
extends DanmakuView
implements IDanmukuView {
    private static final String TAG = "DanmuViewCanvas";
    private DanmakuContext mDanmukuContent;
    private int gapLine = 3;
    private IDanmuClickListener listener;
    private int frameRate = 34;
    private DanmuViewController mDanmuViewController;
    private DanmakuTouchHelper mTouchHelper;
    private HashMap<Integer, Integer> levelMap = new HashMap();
    private int lineSpace;

    public DanmuViewCanvas(Context context) {
        super(context);
        this.init();
    }

    public DanmuViewCanvas(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DanmuViewCanvas(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setOpenView() {
        this.onBarrageSwitch(true);
    }

    public void setCloseView() {
        this.onBarrageSwitch(false);
        BitMapPool.getInstance().reset();
    }

    public boolean onDanmuSwitch() {
        return this.mDanmuViewController.isDanmuStart();
    }

    public int getLines() {
        return this.gapLine;
    }

    public void setLines(int lines) {
        this.gapLine = lines;
        this.levelMap.clear();
        for (int i = 0; i < this.gapLine; ++i) {
            this.levelMap.put(i, 1);
        }
        this.mDanmuViewController.setTrackLines(lines);
        this.mDanmuViewController.resetLineMap();
    }

    public void setLineSpace(int lineSpace) {
        if (this.mDanmukuContent != null) {
            this.lineSpace = lineSpace;
            this.init();
            this.mDanmukuContent.setLineHeight(ScreenUtil.getInstance().dip2px(36 + lineSpace));
        }
    }

    private void init() {
        this.mDanmukuContent = DanmakuContext.create();
        this.mDanmuViewController = new DanmuViewController();
        this.mDanmuViewController.setDanmuContentAndRightPading(this.mDanmukuContent, -ScreenUtil.getInstance().dip2px(30));
        this.mDanmukuContent.setLineHeight(ScreenUtil.getInstance().dip2px(36));
        for (int i = 0; i < this.gapLine; ++i) {
            this.levelMap.put(i, 1);
        }
    }

    public void showView(ViewGroup rootView, RelativeLayout.LayoutParams params) {
        if (this.getParent() != null) {
            rootView.removeAllViews();
        }
        rootView.addView((View)this, (ViewGroup.LayoutParams)params);
    }

    public void hideView(ViewGroup root) {
        if (this.getParent() != null) {
            root.removeAllViews();
        }
    }

    public void setDrawTime(int time) {
    }

    public void setSpeed(float speed) {
        float intervalTime2 = (float)this.frameRate / 1000.0f;
        float detalOffset = (float)ScreenUtil.getInstance().dip2px(speed) * intervalTime2;
        this.mDanmukuContent.setDetalOffset(detalOffset);
    }

    public void sendGunPower(GunNewPower danmuContent, int position) {
        if (danmuContent == null || position < 0 || position >= this.gapLine) {
            return;
        }
        if (this.mDanmuViewController.isDanmuStart() && danmuContent != null && this.mDanmuViewController.checkTrackIsAvaliableLine(position)) {
            this.mDanmuViewController.setTrackAvaliableStatus(position, false);
            BaseDanmaku danmakuItem = null;
            if (danmuContent.bitmap != null) {
                danmakuItem = this.createDanmu(danmuContent.bitmap, danmuContent.gunId, danmuContent.content, danmuContent.poolPos, danmuContent.width);
            }
            if (danmakuItem != null) {
                this.mDanmuViewController.setTrackStatus(position, danmakuItem);
                danmakuItem.setYPos(position);
                this.addDanmaku(danmakuItem);
            }
            SystemClock.sleep(20L);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            if (null != this.mTouchHelper) {
                this.mTouchHelper.onTouchEvent(event);
            }
            return super.onTouchEvent(event);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)("onTouchEvent error! " + e), (Object[])new Object[0]);
            return false;
        }
    }

    public void queryDanmuOpenStatus(IDanmuOpenStatus status) {
        this.mDanmuViewController.setDanmuOpenStatus(status);
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
    }

    public void setOnClickListener(IDanmuClickListener clickListener) {
        this.listener = clickListener;
    }

    public void setScreenWidth(float width) {
    }

    public void onPause() {
        if (this.isPrepared()) {
            this.pause();
        }
    }

    public void onDestory() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"WYNOTSHOW onDestory =", (Object[])new Object[0]);
        }
        this.release();
        this.listener = null;
        this.mDanmuViewController.uninit();
    }

    public void onResume() {
        if (this.isPrepared() && this.isPaused()) {
            this.resume();
        }
    }

    private void onBarrageSwitch(boolean on) {
        this.mDanmuViewController.onBarrageSwitch(on);
        if (on) {
            this.doPrepare();
            this.resume();
        } else {
            this.removeAllDanmakus(true);
            this.pause();
        }
    }

    public BaseDanmaku createDanmu(Bitmap bitmap, long id2, String content, int pos, int width) {
        if (bitmap == null) {
            return null;
        }
        R2LDanmaku danmaku = new R2LDanmaku();
        danmaku.gunId = id2;
        danmaku.content = content;
        danmaku.cache = bitmap;
        danmaku.padding = 5;
        danmaku.poolPos = pos;
        danmaku.paintWidth = width < 0 ? (float)bitmap.getWidth() : (float)width;
        return danmaku;
    }

    public void doPrepare() {
        this.mTouchHelper = DanmakuTouchHelper.instance(this);
        this.prepare(this.mDanmukuContent);
        this.showFPS(false);
        this.setCallback(new DrawHandler.Callback(){

            @Override
            public void updateTimer(DanmakuTimer timer) {
            }

            @Override
            public void drawingFinished() {
            }

            @Override
            public void danmakuShown(BaseDanmaku danmaku) {
            }

            @Override
            public void checkAvaiableLine() {
                DanmuViewCanvas.this.mDanmuViewController.checkAllTrackIsAvaliableLine();
            }

            @Override
            public void prepared() {
                DanmuViewCanvas.this.start();
            }
        });
    }

    @Override
    public IDanmuClickListener getIDanmakuClickListener() {
        return this.listener;
    }

    public synchronized HashMap<Integer, Integer> getLevelMap() {
        return this.levelMap;
    }

    public synchronized void setLevelMap(int index, int level) {
        this.levelMap.put(index, level);
    }

    public void setDanMuAlpha(int alpha) {
        if (alpha < 0) {
            alpha = 0;
        } else if (alpha > 100) {
            alpha = 100;
        }
        this.setAlpha((float)alpha * 1.0f / 100.0f);
    }
}

