/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.DrawHandler;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.DrawHelper;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDanmakuView;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDanmakuViewController;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.util.log.MLog;
import java.util.LinkedList;

public class DanmakuView
extends View
implements IDanmakuView,
IDanmakuViewController {
    public static final String TAG = "DanmakuView";
    private static final int MAX_RECORD_SIZE = 50;
    private static final int ONE_SECOND = 1000;
    protected int mDrawingThreadType = 0;
    private DrawHandler.Callback mCallback;
    private HandlerThread mHandlerThread;
    private DrawHandler handler;
    private boolean isSurfaceCreated;
    private IDanmakuView.OnDanmakuClickListener mOnDanmakuClickListener;
    private boolean mDanmakuVisible = true;
    private Object mDrawMonitor = new Object();
    private boolean mDrawFinished = false;
    private boolean mRequestRender = false;
    private long mUiThreadId;
    private LinkedList<Long> mDrawTimes;
    private boolean mClearFlag;
    private int mResumeTryCount = 0;
    private Runnable mResumeRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuView.this.handler == null) {
                return;
            }
            DanmakuView.this.mResumeTryCount++;
            if (DanmakuView.this.mResumeTryCount > 4 || DanmakuView.super.isShown()) {
                DanmakuView.this.handler.resume();
            } else {
                DanmakuView.this.handler.postDelayed(this, 100 * DanmakuView.this.mResumeTryCount);
            }
        }
    };

    public DanmakuView(Context context) {
        super(context);
        this.init();
    }

    public DanmakuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DanmakuView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mUiThreadId = Thread.currentThread().getId();
        this.setBackgroundColor(0);
        this.setDrawingCacheBackgroundColor(0);
        DrawHelper.useDrawColorToClearCanvas(true, false);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        return super.onCreateDrawableState(extraSpace);
    }

    @Override
    public void setCallback(DrawHandler.Callback callback2) {
        this.mCallback = callback2;
        if (this.handler != null) {
            this.handler.setCallback(callback2);
        }
    }

    @Override
    public void addDanmaku(BaseDanmaku item2) {
        if (this.handler != null) {
            this.handler.addDanmaku(item2);
        }
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item2, boolean remeasure) {
        if (this.handler != null) {
            this.handler.invalidateDanmaku(item2, remeasure);
        }
    }

    @Override
    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.handler != null) {
            this.handler.removeAllDanmakus(isClearDanmakusOnScreen);
        }
    }

    @Override
    public void removeAllLiveDanmakus() {
        if (this.handler != null) {
            this.handler.removeAllLiveDanmakus();
        }
    }

    @Override
    public IDanmakus getCurrentVisibleDanmakus() {
        if (this.handler != null) {
            return this.handler.getCurrentVisibleDanmakus();
        }
        return null;
    }

    @Override
    public void release() {
        this.stop();
        if (this.mDrawTimes != null) {
            this.mDrawTimes.clear();
        }
    }

    @Override
    public void stop() {
        this.stopDraw();
    }

    private void stopDraw() {
        DrawHandler handler2 = this.handler;
        this.handler = null;
        this.unlockCanvasAndPost();
        if (handler2 != null) {
            handler2.quit();
        }
        if (this.mHandlerThread != null) {
            HandlerThread handlerThread = this.mHandlerThread;
            MLog.info((Object)TAG, (String)"[stopDraw] mHandlerThread = null", (Object[])new Object[0]);
            this.mHandlerThread = null;
            try {
                handlerThread.join();
            }
            catch (InterruptedException e) {
                MLog.error((Object)TAG, (String)"Empty Catch on stopDraw", (Throwable)e, (Object[])new Object[0]);
            }
            handlerThread.quit();
        }
    }

    protected Looper getLooper(int type) {
        int priority;
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            MLog.info((Object)TAG, (String)"[getLooper] mHandlerThread = null", (Object[])new Object[0]);
            this.mHandlerThread = null;
        }
        switch (type) {
            case 1: {
                return Looper.getMainLooper();
            }
            case 2: {
                priority = -8;
                break;
            }
            case 3: {
                priority = 19;
                break;
            }
            default: {
                priority = 0;
            }
        }
        String threadName = "DFM Handler Thread #" + priority;
        this.mHandlerThread = new HandlerThread(threadName, priority);
        this.mHandlerThread.start();
        if (this.mHandlerThread != null) {
            return this.mHandlerThread.getLooper();
        }
        return null;
    }

    private void prepare() {
        if (null == this.handler) {
            Looper looper = this.getLooper(this.mDrawingThreadType);
            if (looper != null) {
                this.handler = new DrawHandler(looper, this, this.mDanmakuVisible);
            } else {
                MLog.error((Object)TAG, (String)("prepare unexpected error ,current thread:" + Thread.currentThread()), (Object[])new Object[0]);
                this.stopDraw();
            }
        }
    }

    @Override
    public void prepare(DanmakuContext config) {
        this.prepare();
        if (this.handler != null) {
            this.handler.setConfig(config);
            this.handler.setCallback(this.mCallback);
            this.handler.prepare();
        }
    }

    @Override
    public boolean isPrepared() {
        return this.handler != null && this.handler.isPrepared();
    }

    @Override
    public DanmakuContext getConfig() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getConfig();
    }

    @Override
    public void showFPS(boolean show) {
    }

    @Override
    public long drawDanmakus() {
        if (!this.isSurfaceCreated) {
            return 0L;
        }
        if (!this.isShown()) {
            return -1L;
        }
        long stime = SystemClock.uptimeMillis();
        this.lockCanvas();
        return SystemClock.uptimeMillis() - stime;
    }

    @SuppressLint(value={"NewApi"})
    private void postInvalidateCompat() {
        this.mRequestRender = true;
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCanvas() {
        if (!this.mDanmakuVisible) {
            return;
        }
        this.postInvalidateCompat();
        Object object = this.mDrawMonitor;
        synchronized (object) {
            while (!this.mDrawFinished && this.handler != null) {
                try {
                    this.mDrawMonitor.wait(300L);
                }
                catch (InterruptedException e) {
                    if (!this.mDanmakuVisible || this.handler == null || this.handler.isStop()) break;
                    Thread.currentThread().interrupt();
                }
            }
            this.mDrawFinished = false;
        }
    }

    private void lockCanvasAndClear() {
        this.mClearFlag = true;
        this.lockCanvas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockCanvasAndPost() {
        Object object = this.mDrawMonitor;
        synchronized (object) {
            this.mDrawFinished = true;
            this.mDrawMonitor.notifyAll();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mDanmakuVisible && !this.mRequestRender) {
            super.onDraw(canvas);
            return;
        }
        if (this.mClearFlag) {
            DrawHelper.clearCanvas(canvas);
            this.mClearFlag = false;
        } else if (this.handler != null) {
            this.handler.draw(canvas);
        }
        this.mRequestRender = false;
        this.unlockCanvasAndPost();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.handler != null) {
            this.handler.notifyDispSizeChanged(right - left, bottom - top);
        }
        this.isSurfaceCreated = true;
    }

    @Override
    public void toggle() {
        if (this.isSurfaceCreated) {
            if (this.handler == null) {
                this.start();
            } else if (this.handler.isStop()) {
                this.resume();
            } else {
                this.pause();
            }
        }
    }

    @Override
    public void pause() {
        if (this.handler != null) {
            this.handler.pause();
        }
    }

    @Override
    public void resume() {
        if (this.handler != null && this.handler.isPrepared()) {
            this.mResumeTryCount = 0;
            this.handler.postDelayed(this.mResumeRunnable, 100L);
        } else if (this.handler == null) {
            this.restart();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.handler != null) {
            return this.handler.isStop();
        }
        return false;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void start() {
        this.start(0L);
    }

    @Override
    public void start(long postion) {
        if (this.handler == null) {
            this.prepare();
        } else {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.handler != null) {
            this.handler.obtainMessage(1, postion).sendToTarget();
        }
    }

    @Override
    public void seekTo(Long ms) {
        if (this.handler != null) {
            this.handler.seekTo(ms);
        }
    }

    @Override
    public boolean isViewReady() {
        return this.isSurfaceCreated;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void show() {
        this.showAndResumeDrawTask(null);
    }

    @Override
    public void showAndResumeDrawTask(Long position) {
        this.mDanmakuVisible = true;
        this.mClearFlag = false;
        if (this.handler == null) {
            return;
        }
        this.handler.showDanmakus(position);
    }

    @Override
    public void hide() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return;
        }
        this.handler.hideDanmakus(false);
    }

    @Override
    public long hideAndPauseDrawTask() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return 0L;
        }
        return this.handler.hideDanmakus(true);
    }

    @Override
    public void clear() {
        if (!this.isViewReady()) {
            return;
        }
        if (!this.mDanmakuVisible || Thread.currentThread().getId() == this.mUiThreadId) {
            this.mClearFlag = true;
            this.postInvalidateCompat();
        } else {
            this.lockCanvasAndClear();
        }
    }

    @Override
    public boolean isShown() {
        return this.mDanmakuVisible && super.isShown();
    }

    @Override
    public void setDrawingThreadType(int type) {
        this.mDrawingThreadType = type;
    }

    @Override
    public long getCurrentTime() {
        if (this.handler != null) {
            return this.handler.getCurrentTime();
        }
        return 0L;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean isHardwareAccelerated() {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.isHardwareAccelerated();
        }
        return false;
    }

    @Override
    public void clearDanmakusOnScreen() {
        if (this.handler != null) {
            this.handler.clearDanmakusOnScreen();
        }
    }

    @Override
    public IDanmakuView.OnDanmakuClickListener getOnDanmakuClickListener() {
        return this.mOnDanmakuClickListener;
    }

    @Override
    public void setOnDanmakuClickListener(IDanmakuView.OnDanmakuClickListener listener2) {
        this.mOnDanmakuClickListener = listener2;
        this.setClickable(null != listener2);
    }

    @Override
    public IDanmuClickListener getIDanmakuClickListener() {
        return null;
    }
}

