/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.autoui;

import com.yy.mobile.ui.autoui.LayoutInfo;
import com.yy.mobile.util.log.MLog;
import io.reactivex.subjects.BehaviorSubject;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutoDataProcessor {
    private static String TAG = "AutoDataProcessor";
    private PriorityBlockingQueue<LayoutInfo> awaitQueue = new PriorityBlockingQueue();
    private final Thread mThread = new AutoDataProcessorThread("AutoDataProcessor");
    private BehaviorSubject<LayoutInfo> mOnConsumer = BehaviorSubject.create();
    private AtomicBoolean mSwitch = new AtomicBoolean(false);
    private AtomicBoolean isEntryWait = new AtomicBoolean(false);
    private final Object OBJ = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(LayoutInfo t) {
        this.awaitQueue.offer(t);
        if (this.isEntryWait.compareAndSet(true, false)) {
            Object object = this.OBJ;
            synchronized (object) {
                MLog.info((Object)TAG, (String)"AutoDataProcessorThread entry notify", (Object[])new Object[0]);
                this.OBJ.notify();
            }
        }
    }

    public BehaviorSubject<LayoutInfo> registerConsumerObserver() {
        return this.mOnConsumer;
    }

    public void start() {
        if (this.mSwitch.compareAndSet(false, true)) {
            this.mThread.start();
        }
    }

    public void stop() {
        if (this.mSwitch.compareAndSet(true, false)) {
            // empty if block
        }
        this.awaitQueue.clear();
    }

    public class AutoDataProcessorThread
    extends Thread {
        public AutoDataProcessorThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AutoDataProcessor.this.mSwitch.get()) {
                Object t;
                while (AutoDataProcessor.this.mSwitch.get() && AutoDataProcessor.this.awaitQueue.peek() != null) {
                    t = (LayoutInfo)AutoDataProcessor.this.awaitQueue.poll();
                    AutoDataProcessor.this.mOnConsumer.onNext(t);
                }
                try {
                    if (!AutoDataProcessor.this.mSwitch.get()) continue;
                    t = AutoDataProcessor.this.OBJ;
                    synchronized (t) {
                        if (AutoDataProcessor.this.isEntryWait.compareAndSet(false, true)) {
                            MLog.info((Object)TAG, (String)"AutoDataProcessorThread entry wait", (Object[])new Object[0]);
                            AutoDataProcessor.this.OBJ.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            MLog.info((Object)TAG, (String)"AutoDataProcessorThread entry complete", (Object[])new Object[0]);
        }
    }
}

