/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.nobleemotion;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.live.module.nobleemotion.NobleEmotionFragment;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.widget.CustomGridLayout;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.noble.emotion.ChatEmotion;
import java.util.ArrayList;
import java.util.List;

public class ChatEmotionViewPagerAdapter
extends PagerAdapter {
    Context context;
    NobleEmotionFragment.OnEmotionItemClickListener onEmotionItemClickListener;
    private int perPageCount = 15;
    private int pageCount = 1;
    private ArrayList<ChatEmotion> chatEmotions = new ArrayList();
    private View.OnClickListener nobleEmoDelClick = new View.OnClickListener(){

        public void onClick(View view) {
            ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).deleteInputMsg();
        }
    };

    public ChatEmotionViewPagerAdapter(Context ctx, NobleEmotionFragment.OnEmotionItemClickListener onEmotionItemClickListener) {
        this.context = ctx;
        this.onEmotionItemClickListener = onEmotionItemClickListener;
    }

    public void setChatEmotion(List<ChatEmotion> ct) {
        this.chatEmotions.clear();
        if (ct != null) {
            this.chatEmotions.addAll(ct);
        }
    }

    public int getCount() {
        if (this.chatEmotions.size() % this.perPageCount == 0) {
            return this.chatEmotions.size() / this.perPageCount;
        }
        return this.chatEmotions.size() / this.perPageCount + 1;
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        CustomGridLayout itemView = (CustomGridLayout)LayoutInflater.from((Context)this.context).inflate(R.layout.layout_noble_emotion_pager_item, null);
        container.addView((View)itemView);
        this.initItem(itemView, position);
        return itemView;
    }

    void initItem(CustomGridLayout myGridLayout, final int pos) {
        myGridLayout.setGridAdapter(new CustomGridLayout.GridAdatper(){

            public View getView(int index) {
                int start2 = pos * 6 + index;
                View item2 = LayoutInflater.from((Context)ChatEmotionViewPagerAdapter.this.context).inflate(R.layout.layout_noble_emotion_item, null);
                RecycleImageView recycleImageView = (RecycleImageView)item2.findViewById(R.id.iv_emotion);
                if (start2 < ChatEmotionViewPagerAdapter.this.chatEmotions.size()) {
                    item2.setTag(ChatEmotionViewPagerAdapter.this.chatEmotions.get(start2));
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)((Object)ChatEmotionViewPagerAdapter.this), (String)"getView start=%d,url=%s", (Object[])new Object[]{start2, ((ChatEmotion)ChatEmotionViewPagerAdapter.this.chatEmotions.get(start2)).getUrlPngMob()});
                    }
                    recycleImageView.setVisibility(0);
                    ImageLoader.loadImage((String)((ChatEmotion)ChatEmotionViewPagerAdapter.this.chatEmotions.get(start2)).getUrlPngMob(), (RecycleImageView)recycleImageView, (ImageConfig)ImageConfig.fullImageConfig(), (int)R.drawable.noble_flow_facecoder_boy);
                } else {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)((Object)ChatEmotionViewPagerAdapter.this), (String)"getView INVISIBLE", (Object[])new Object[0]);
                    }
                    if (this.getCount() - 1 == start2) {
                        recycleImageView.setVisibility(0);
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                        layoutParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)ChatEmotionViewPagerAdapter.this.context);
                        recycleImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        recycleImageView.setScaleType(ImageView.ScaleType.CENTER);
                        recycleImageView.setImageResource(R.drawable.icon_noble_emo_del);
                        recycleImageView.setOnClickListener(ChatEmotionViewPagerAdapter.this.nobleEmoDelClick);
                    } else {
                        recycleImageView.setVisibility(4);
                    }
                }
                return item2;
            }

            public int getCount() {
                return ChatEmotionViewPagerAdapter.this.perPageCount;
            }
        });
        myGridLayout.setOnItemClickListener(new CustomGridLayout.OnItemClickListener(){

            public void onItemClick(View v, int index) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)((Object)ChatEmotionViewPagerAdapter.this), (String)"onItemClick index=%d", (Object[])new Object[]{index});
                }
                if (v.findViewById(R.id.iv_emotion).getVisibility() == 0 && ChatEmotionViewPagerAdapter.this.onEmotionItemClickListener != null && null != v.getTag()) {
                    ChatEmotionViewPagerAdapter.this.onEmotionItemClickListener.onEmotionItemClickListener((ChatEmotion)v.getTag(), index);
                }
            }
        });
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }
}

