/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.noble;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.live.module.noble.EntIdentityIconSet;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;

public class NobleUpdateView
extends RelativeLayout {
    public boolean isRunning = false;
    private Activity mActivity;
    private View animationLayout;
    private ImageView light;
    private ImageView nobleIcon;
    private TextView nameTxt;
    private ImageView gongxi;
    private ImageView nobleWord;
    private AnimatorSet animatorSet1;
    private AnimatorSet animatorSet2;
    private AnimatorSet animatorSet3;
    private AnimatorSet animatorSet4;
    private AnimatorSet animatorSet5;
    private int lv = 0;
    private boolean isKing = false;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private Runnable ending = new Runnable(){

        @Override
        public void run() {
            NobleUpdateView.this.isRunning = false;
            NobleUpdateView.this.handler.removeCallbacks((Runnable)this);
            NobleUpdateView.this.removeAll();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"hsj", (String)"isRunning=false", (Object[])new Object[0]);
            }
        }
    };

    public NobleUpdateView(Activity activity, String name, int level) {
        super((Context)activity);
        this.lv = level;
        this.init(activity, name, level);
    }

    private void init(Activity activity, String name, int level) {
        this.mActivity = activity;
        if (level == 1 || level == 2) {
            this.isKing = true;
        }
        if (this.isKing) {
            LayoutInflater.from((Context)this.mActivity).inflate(R.layout.noble_layout_king, (ViewGroup)this, true);
        } else {
            LayoutInflater.from((Context)this.mActivity).inflate(R.layout.noble_layout_other, (ViewGroup)this, true);
        }
        this.setFocusable(false);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"hsj", (String)"NobleAnimationView init", (Object[])new Object[0]);
        }
        this.animationLayout = this.findViewById(R.id.animation_layout);
        this.light = (ImageView)this.findViewById(R.id.light);
        this.nobleIcon = (ImageView)this.findViewById(R.id.noble_icon);
        this.nameTxt = (TextView)this.findViewById(R.id.name_txt);
        this.gongxi = (ImageView)this.findViewById(R.id.gongxi);
        this.nobleWord = (ImageView)this.findViewById(R.id.noble_word);
        if (name != null) {
            this.nameTxt.setText((CharSequence)name);
        }
        this.nobleIcon.setImageResource(EntIdentityIconSet.getIconResId(level, 120));
        switch (level) {
            case 1: {
                this.nobleWord.setImageResource(R.drawable.test_guowang);
                break;
            }
            case 2: {
                this.nobleWord.setImageResource(R.drawable.test_gongjue);
                break;
            }
            case 3: {
                this.nobleWord.setImageResource(R.drawable.test_houjue);
                break;
            }
            case 4: {
                this.nobleWord.setImageResource(R.drawable.test_bojue);
                break;
            }
            case 5: {
                this.nobleWord.setImageResource(R.drawable.test_zijue);
                break;
            }
            case 6: {
                this.nobleWord.setImageResource(R.drawable.test_nanjue);
                break;
            }
            case 7: {
                this.nobleWord.setImageResource(R.drawable.test_xunjue);
                break;
            }
            default: {
                this.nobleWord.setImageResource(R.drawable.test_xunjue);
            }
        }
        this.isRunning = true;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"hsj", (String)"isRunning=true", (Object[])new Object[0]);
        }
        this.playIconAnimation();
    }

    private void playIconAnimation() {
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.nobleIcon, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(300L);
        DecelerateInterpolator lin = new DecelerateInterpolator();
        ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)this.nobleIcon, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        scaleXAnimator.setInterpolator((TimeInterpolator)lin);
        scaleXAnimator.setStartDelay(0L);
        scaleXAnimator.setDuration(300L);
        ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)this.nobleIcon, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        scaleYAnimator.setInterpolator((TimeInterpolator)lin);
        scaleYAnimator.setStartDelay(0L);
        scaleYAnimator.setDuration(300L);
        this.animatorSet1 = new AnimatorSet();
        this.animatorSet1.playTogether(new Animator[]{alphaAnimator, scaleXAnimator, scaleYAnimator});
        this.animatorSet1.start();
        this.animatorSet1.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                NobleUpdateView.this.playNameBgAnimation();
                NobleUpdateView.this.playGongXiAnimation();
                NobleUpdateView.this.playWordAnimation();
            }
        });
    }

    private void playNameBgAnimation() {
        ObjectAnimator yAnimator;
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.nameTxt, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(300L);
        AccelerateInterpolator lin = new AccelerateInterpolator();
        if (this.isKing) {
            yAnimator = ObjectAnimator.ofFloat((Object)this.nameTxt, (String)"translationY", (float[])new float[]{-20.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        } else {
            yAnimator = ObjectAnimator.ofFloat((Object)this.nameTxt, (String)"translationX", (float[])new float[]{-50.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        }
        this.animatorSet2 = new AnimatorSet();
        this.animatorSet2.playTogether(new Animator[]{alphaAnimator, yAnimator});
        this.animatorSet2.start();
    }

    private void playGongXiAnimation() {
        ObjectAnimator yAnimator;
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.gongxi, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(300L);
        AccelerateInterpolator lin = new AccelerateInterpolator();
        if (this.isKing) {
            yAnimator = ObjectAnimator.ofFloat((Object)this.gongxi, (String)"translationY", (float[])new float[]{-20.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        } else {
            yAnimator = ObjectAnimator.ofFloat((Object)this.gongxi, (String)"translationX", (float[])new float[]{-50.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        }
        this.animatorSet3 = new AnimatorSet();
        this.animatorSet3.playTogether(new Animator[]{alphaAnimator, yAnimator});
        this.animatorSet3.setStartDelay(100L);
        this.animatorSet3.start();
    }

    private void playWordAnimation() {
        ObjectAnimator yAnimator;
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.nobleWord, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(300L);
        AccelerateInterpolator lin = new AccelerateInterpolator();
        if (this.isKing) {
            yAnimator = ObjectAnimator.ofFloat((Object)this.nobleWord, (String)"translationY", (float[])new float[]{-20.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        } else {
            yAnimator = ObjectAnimator.ofFloat((Object)this.nobleWord, (String)"translationX", (float[])new float[]{-50.0f, 0.0f});
            yAnimator.setInterpolator((TimeInterpolator)lin);
            yAnimator.setStartDelay(0L);
            yAnimator.setDuration(300L);
        }
        this.animatorSet4 = new AnimatorSet();
        this.animatorSet4.playTogether(new Animator[]{alphaAnimator, yAnimator});
        this.animatorSet4.setStartDelay(200L);
        this.animatorSet4.start();
        this.animatorSet4.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (NobleUpdateView.this.isKing) {
                    NobleUpdateView.this.playLightAnimation();
                }
                NobleUpdateView.this.handler.removeCallbacks(NobleUpdateView.this.ending);
                if (NobleUpdateView.this.lv == 6 || NobleUpdateView.this.lv == 5) {
                    NobleUpdateView.this.handler.postDelayed(NobleUpdateView.this.ending, 4000L);
                } else if (NobleUpdateView.this.lv == 4 || NobleUpdateView.this.lv == 3) {
                    NobleUpdateView.this.handler.postDelayed(NobleUpdateView.this.ending, 7000L);
                } else if (NobleUpdateView.this.lv == 2) {
                    NobleUpdateView.this.handler.postDelayed(NobleUpdateView.this.ending, 9000L);
                } else if (NobleUpdateView.this.lv == 1) {
                    NobleUpdateView.this.handler.postDelayed(NobleUpdateView.this.ending, 14000L);
                } else {
                    NobleUpdateView.this.handler.postDelayed(NobleUpdateView.this.ending, 3000L);
                }
            }
        });
    }

    private void playLightAnimation() {
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.light, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(500L);
        ObjectAnimator rotateAnimator = ObjectAnimator.ofFloat((Object)this.light, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        rotateAnimator.setRepeatCount(-1);
        rotateAnimator.setDuration(5000L);
        LinearInterpolator lin = new LinearInterpolator();
        rotateAnimator.setInterpolator((TimeInterpolator)lin);
        this.animatorSet5 = new AnimatorSet();
        this.animatorSet5.playTogether(new Animator[]{alphaAnimator, rotateAnimator});
        this.animatorSet5.start();
    }

    private void removeAll() {
        ViewParent rootView = this.getParent();
        if (rootView instanceof ViewGroup) {
            this.removeAllViews();
            ((ViewGroup)rootView).removeView((View)this);
        }
    }

    public void destroy() {
        this.handler.removeCallbacks(this.ending);
        if (this.animatorSet1 != null) {
            this.animatorSet1.end();
        }
        if (this.animatorSet2 != null) {
            this.animatorSet2.end();
        }
        if (this.animatorSet3 != null) {
            this.animatorSet3.end();
        }
        if (this.animatorSet4 != null) {
            this.animatorSet4.end();
        }
        if (this.animatorSet5 != null) {
            this.animatorSet5.end();
        }
        this.removeAll();
    }
}

