/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.yy.live.module.giftdanmu.DanMuPosition;
import com.yy.live.module.giftdanmu.DanmuTextManager;
import com.yy.live.module.giftdanmu.LiveDanMuUtil;
import com.yy.live.module.giftdanmu.model.DanMuMedalParseManage;
import com.yy.live.module.pk.ChannelPkMvpChannelMsg;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.ui.basicfunction.danmu.DanmuOpenStatusType;
import com.yy.mobile.ui.basicfunction.danmu.filter.DanMuCommentFilter;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BitmapGunPowder;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.DanmuData;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.ui.gift.message.ArGiftUpgradeMessage;
import com.yy.mobile.ui.publicchat.model.medal.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.ui.publicchat.top.PublicChatBroadcastMessage;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.ui.swivelChair.TurnChairMessage;
import com.yy.mobile.ui.turntable.TurnTableUtils;
import com.yy.mobile.ui.turntable.info.TurnTableTurMessage;
import com.yy.mobile.ui.utils.SafeDrawableUtils;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.cavalier.TaskMessage;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.flower.FlowerChinneMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.invincibledanmu.IInvincibleDanmuCore;
import com.yymobile.core.invincibledanmu.InvincibleDanmuInfo;
import com.yymobile.core.medal.MedalCenter;
import com.yymobile.core.messagequeue.BCItem;
import com.yymobile.core.noble.NobleChannelMessage;
import com.yymobile.core.noble.NobleHonorChangeWithoutGiftMessage;
import com.yymobile.core.noble.NobleLevelUpgradeChannelMessage;
import com.yymobile.core.noble.NobleTalkChannelMessage;
import com.yymobile.core.truelove.TrueLoveMessage;
import com.yymobile.liveapi.plugincenter.PluginPublicMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DanMuUtil {
    private static final String TAG = "DanMuUtil";
    private static final String GIFT_PLACE_HOLDER = "[gift]";
    private static final String BCTYPE_PLACE_HOLDER = "[bc]";
    private static final String IN_CHANNEL_STR = "\u5728\u9891\u9053";
    private static final int maxNickLength = 12;
    private static final int imgSize = (int)ResolutionUtils.convertDpToPixel((float)27.0f, (Context)BasicConfig.getInstance().getAppContext());
    private List<RichTextManager.Feature> features;
    private HashSet<String> emotionMap;
    private BlockingQueue<DanmuData> que;
    private Thread task;
    private AtomicBoolean door = new AtomicBoolean(true);
    private LinkedList<BitmapGunPowder> priorityDanmu;
    private LinkedList<BitmapGunPowder> normalDanmu;
    private LinkedList<BitmapGunPowder> myDanmu;
    private AtomicInteger danmuCount = new AtomicInteger();
    private boolean mSurfaceView = false;
    private WeakReference<IDanmukuView> mDanmuView = null;
    private TextView mDanmuTextView;
    private int mDanmuTextSize = 14;
    private boolean openStatus = false;
    private static volatile DanMuMedalParseManage mParseManage;
    private boolean mDanmuEnabled;
    private int nickLength = 7;
    private boolean ignoreOrientation = false;
    private DanMuPosition mCurrentPosition = DanMuPosition.BOTTOM;

    public int getDanmuTextSize() {
        return this.mDanmuTextSize;
    }

    public void setDanmuTextSize(int danmuTextSize) {
        this.mDanmuTextSize = danmuTextSize;
    }

    protected DanMuUtil() {
        this.features = new ArrayList<RichTextManager.Feature>();
        this.emotionMap = new HashSet(500);
        this.features.add(RichTextManager.Feature.CHANNELAIRTICKET);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.features.add(RichTextManager.Feature.NOBLEGIFEMOTION);
        this.emotionMap.addAll(Arrays.asList(EmoticonFilter.getInstance().getAllSmileCodes()));
        this.que = new LinkedBlockingQueue<DanmuData>();
        this.priorityDanmu = new LinkedList();
        this.normalDanmu = new LinkedList();
        this.myDanmu = new LinkedList();
        this.mDanmuEnabled = this.isDanmuEnabledFromPreference();
        MLog.info((Object)TAG, (String)("init DanmuEnabled:" + this.mDanmuEnabled), (Object[])new Object[0]);
    }

    public static boolean getDanmuEnabledOnSlideHide() {
        return true;
    }

    public static boolean getDanmuEnabledOnSlideShow() {
        return false;
    }

    public boolean isSurfaceView() {
        return this.mSurfaceView;
    }

    public void setSurfaceView(boolean isSurfaceView) {
        this.mSurfaceView = isSurfaceView;
    }

    public IDanmukuView getDanmuView() {
        if (this.mDanmuView != null && this.mDanmuView.get() != null) {
            return (IDanmukuView)this.mDanmuView.get();
        }
        return null;
    }

    public void setDanmuView(IDanmukuView danmuView) {
        this.mDanmuView = new WeakReference<IDanmukuView>(danmuView);
    }

    private Spannable onAppendNobleLevelUpgradeChannelMessage(Context context, NobleLevelUpgradeChannelMessage msg) {
        int resNobleIcon = EntIdentityIconSet.getIconResId((int)msg.nobleLevel, (int)46);
        return msg.getSpannableString(context, resNobleIcon);
    }

    private Spannable onAppendFlowerChinneMessage(Context context, FlowerChinneMessage msg) {
        StringBuilder sb = new StringBuilder();
        if (!FP.empty((CharSequence)msg.nickname)) {
            if (msg.nickname.length() > this.nickLength) {
                msg.nickname = msg.nickname.substring(0, this.nickLength);
            }
            sb.append(msg.nickname);
            sb.append(" \u9001 ");
        }
        int res = R.drawable.icon_xiao_hua;
        if (msg.isTrueLoveLv) {
            res = R.drawable.icon_xiao_hua_rose;
        }
        sb.append("REPLACE_IMGE_FLAG");
        SpannableString sp = new SpannableString((CharSequence)sb.toString());
        sp = this.setSpanColor((ChannelMessage)msg, (Spannable)sp, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#6DEAFF"));
        Pattern p = Pattern.compile("REPLACE_IMGE_FLAG");
        Matcher m = p.matcher(sb);
        while (m.find()) {
            if (msg.nickname.contains("REPLACE_IMGE_FLAG")) continue;
            int mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)context);
            BitmapDrawable bd = ImageUtil.getBitmapDrawableFromResource((int)mGiftMessageImageSize, (int)mGiftMessageImageSize, (int)res);
            bd.setBounds(0, 0, mGiftMessageImageSize, mGiftMessageImageSize);
            CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bd, 2.0f);
            sp.setSpan((Object)imageSpan, m.start(), m.end(), 33);
        }
        return sp;
    }

    public SpannableString getSpannableString(Context context, int loadingImgResId, int defaultXZ, int width, int height, GiftChannelMessage message) {
        if (FP.empty((CharSequence)message.text)) {
            return null;
        }
        SpannableString sp = new SpannableString((CharSequence)message.text);
        int type = message.giftTypeId;
        String giftIconUrl = GiftConfigParser.getInstance().getGiftIconPath(type);
        if (giftIconUrl != null) {
            try {
                ImageConfig imageConfig = new ImageConfig(width, height);
                BitmapDrawable giftDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)imageConfig);
                if (giftDrawable == null && (giftDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig())) == null) {
                    ImageLoader.preloadBitmap((String)giftIconUrl, (ImageConfig)imageConfig, (int)loadingImgResId);
                    giftDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(context, loadingImgResId);
                }
                giftDrawable.setBounds(0, 0, width, height);
                String replace = "{" + type + "}";
                int startIdx = sp.toString().indexOf(replace);
                int endIdx = startIdx + replace.length();
                if (startIdx > -1 && sp.length() >= endIdx) {
                    sp.setSpan((Object)new CustomImageSpan((Drawable)giftDrawable, 2.0f), startIdx, endIdx, 33);
                }
                this.loadMedal(context, sp, defaultXZ, width, height, message.medalUrl);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
        return sp;
    }

    public void loadMedal(Context context, SpannableString sp, int defalutImgResId, int width, int height, String medalUrl) {
        if (FP.empty((CharSequence)medalUrl)) {
            return;
        }
        ImageLoader.preloadBitmap((String)medalUrl, (ImageConfig)ImageConfig.fullImageConfig(), (int)defalutImgResId);
        BitmapDrawable medalDrawable = ImageLoader.getBitmapFromCache((String)medalUrl, (ImageConfig)ImageConfig.fullImageConfig());
        if (medalDrawable == null) {
            medalDrawable = ImageUtil.getBitmapDrawableFromResource((int)width, (int)height, (int)defalutImgResId);
        }
        int newWidth = (int)ResolutionUtils.convertDpToPixel((float)50.5f, (Context)context);
        int newHeight = (int)ResolutionUtils.convertDpToPixel((float)21.5f, (Context)context);
        medalDrawable.setBounds(0, 0, newWidth, newHeight);
        sp.setSpan((Object)new CustomImageSpan((Drawable)medalDrawable, 2.0f), 0, 1, 33);
    }

    public void initGift(GiftChannelMessage message, Context context) {
        int mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)context) + 1;
        SpannableString spannable = this.getSpannableString(context, R.drawable.lr_ic_default_gift, R.drawable.xunzhang_default_bitmap, mGiftMessageImageSize, mGiftMessageImageSize, message);
        if (message.type == GiftChannelMessage.GiftType.ComboGift) {
            int x = message.text.lastIndexOf("X");
            int zu = message.text.lastIndexOf("\u7ec4");
            spannable.setSpan((Object)new AbsoluteSizeSpan(19, true), x + 1, zu, 33);
        }
        spannable = this.addMentel((ChannelMessage)message, (Spannable)spannable, context);
        spannable = this.setSpanColor((ChannelMessage)message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
        this.addGunPowder((Spannable)spannable, 2, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, true, false);
    }

    public Drawable getFixedSizedNobleImage(int reSource, int w, int h, Context context) {
        BitmapDrawable baseImage = ImageLoader.getBitmapDrawableFromResource((int)reSource, (ImageConfig)ImageConfig.fullImageConfig());
        BitmapDrawable reSize = null;
        int tw = (int)ResolutionUtils.convertDpToPixel((float)w, (Context)context);
        int th = (int)ResolutionUtils.convertDpToPixel((float)h, (Context)context);
        if (baseImage != null) {
            reSize = ImageLoader.getBitmapFromCache((String)(reSource + "" + tw + th));
            if (reSize == null) {
                Bitmap bitmap = baseImage.getBitmap();
                if (bitmap == null) {
                    return null;
                }
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)tw, (int)th, (boolean)true);
                reSize = new BitmapDrawable(context.getResources(), bitmap);
                ImageLoader.addBitmapToCache((String)(reSource + "" + tw + th), (BitmapDrawable)reSize);
            }
            reSize.setBounds(0, 0, reSize.getIntrinsicWidth(), reSize.getIntrinsicHeight());
        }
        return reSize != null ? reSize : baseImage;
    }

    private void initDanmuTextView(Context context) {
        if (this.mDanmuTextView == null) {
            try {
                LayoutInflater inflater = (LayoutInflater)BasicConfig.getInstance().getAppContext().getSystemService("layout_inflater");
                View view = inflater.inflate(R.layout.danmu_message_item, null);
                this.mDanmuTextView = (TextView)view.findViewById(R.id.tv_danmu_content);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
        this.mDanmuTextView.setTextSize(2, (float)this.getDanmuTextSize());
    }

    public void clear() {
        this.mDanmuTextView = null;
        mParseManage = null;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)" clearPublicChatMedal ", (Object[])new Object[0]);
        }
    }

    public void setIgnoreOrientation(boolean ignoreOrientation) {
        this.ignoreOrientation = ignoreOrientation;
    }

    public void appendDanmu(final ChannelMessage message, final Context context) {
        if (!this.checkValid(context)) {
            return;
        }
        MLog.debug((Object)TAG, (String)"channelMessage: %s", (Object[])new Object[]{message});
        if (DanMuCommentFilter.INSTANCE.interceptAnchorLiveFilter(message)) {
            Spannable spannable = DanMuCommentFilter.INSTANCE.getSpannable(context, message, this.features);
            if (spannable != null) {
                this.addGunPowder(spannable, 100, Color.parseColor((String)"#ffffff"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
            }
        } else if (message instanceof GiftChannelMessage) {
            if (LiveDanMuUtil.isInUnNeedSubcribeList(LiveDanMuUtil.unSubscribeRunningWaterGiftType) && ((GiftChannelMessage)message).type != GiftChannelMessage.GiftType.ComboGift) {
                return;
            }
            if (message.isReplay && message.nickname != null) {
                String nickName = message.nickname;
                if (nickName.length() > this.nickLength) {
                    nickName = nickName.substring(0, this.nickLength);
                }
                if (!StringUtils.isNullOrEmpty((String)nickName) && !message.text.contains(nickName)) {
                    message.text = nickName + " " + message.text;
                }
            }
            int mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)23.0f, (Context)context) + 1;
            int type = ((GiftChannelMessage)message).giftTypeId;
            final String giftIconUrl = GiftConfigParser.getInstance().getGiftIconPath(type);
            final ImageConfig config = new ImageConfig(mGiftMessageImageSize, mGiftMessageImageSize);
            BitmapDrawable giftDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)config);
            if (giftIconUrl != null && giftDrawable == null) {
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)giftIconUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        BitmapDrawable bitmapDrawable = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                        ImageLoader.addBitmapToCache((String)giftIconUrl, (BitmapDrawable)bitmapDrawable, (ImageConfig)config);
                        DanMuUtil.this.initGift((GiftChannelMessage)message, context);
                    }
                });
            } else {
                this.initGift((GiftChannelMessage)message, context);
            }
        } else if (message instanceof NobleChannelMessage) {
            String tmp = message.nickname + "\uff1a" + message.text;
            Spannable spannable = DanmuTextManager.getSpannableString(context, tmp, this.features);
            spannable = this.addMentel(message, spannable, context);
            spannable = this.setSpanColor(message, spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder(spannable, 2, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
            }
        } else if (message instanceof NobleTalkChannelMessage) {
            String tmp = message.nickname + "\uff1a" + message.text;
            Spannable spannable = DanmuTextManager.getSpannableString(context, tmp, this.features);
            spannable = this.addMentel(message, spannable, context);
            spannable = this.setSpanColorAndBackground(message, spannable, context.getResources().getColor(R.color.treehole_name), context.getResources().getColor(R.color.common_color_11_live));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder(spannable, 2, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false, ContextCompat.getDrawable((Context)context, (int)R.drawable.live_noble_talk_channel_message_text_bg));
            }
        } else if (message instanceof PublicChatBroadcastMessage) {
            BCItem bcItem = (BCItem)((PublicChatBroadcastMessage)message).mChatBCWrapper.getInnerEntity();
            if (bcItem == null) {
                return;
            }
            SpannableStringBuilder spannable = this.getBroadCastDanMuSpannable(context, bcItem);
            Drawable drawable2 = bcItem.bcType == 0 ? ContextCompat.getDrawable((Context)context, (int)R.drawable.live_danmu_broadcast_plane_gift_bg) : (bcItem.bcType == 1 ? ContextCompat.getDrawable((Context)context, (int)R.drawable.live_danmu_broadcast_hotball_gift_bg) : ContextCompat.getDrawable((Context)context, (int)R.drawable.live_danmu_broadcast_orange_bg));
            this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#ffffff"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false, drawable2);
        } else if (message instanceof FlowerChinneMessage) {
            Spannable spannable = this.onAppendFlowerChinneMessage(context, (FlowerChinneMessage)message);
            spannable = this.addMentel(message, spannable, context);
            spannable = this.setSpanColor(message, spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#6DEAFF"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder(spannable, 2, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, "", message.pureText, message.isReplay, true, false);
            }
        } else if (message instanceof NobleLevelUpgradeChannelMessage) {
            Spannable spannable = this.onAppendNobleLevelUpgradeChannelMessage(context, (NobleLevelUpgradeChannelMessage)message);
            spannable = this.setSpanColor(message, spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder(spannable, 3, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
            }
        } else if (message instanceof NobleHonorChangeWithoutGiftMessage) {
            Drawable nobleDrawable;
            NobleHonorChangeWithoutGiftMessage nobleHonorChangeWithoutGiftMessage = (NobleHonorChangeWithoutGiftMessage)message;
            String source = nobleHonorChangeWithoutGiftMessage.source.equals("PC") ? "PC" : "\u624b\u673a\u7aef";
            switch (nobleHonorChangeWithoutGiftMessage.messageType) {
                case 1: {
                    nobleHonorChangeWithoutGiftMessage.text = "\u4eca\u5929\u9996\u6b21" + source + "\u767b\u5f55\uff0c\u6da8\u8363\u8000\u503c" + nobleHonorChangeWithoutGiftMessage.increaseHonor;
                    break;
                }
                case 2: {
                    nobleHonorChangeWithoutGiftMessage.text = "\u4eca\u5929\u9996\u6b21" + source + "\u9001\u793c\uff0c\u6da8\u8363\u8000\u503c" + nobleHonorChangeWithoutGiftMessage.increaseHonor;
                    break;
                }
                case 5: {
                    nobleHonorChangeWithoutGiftMessage.text = "\u7d2f\u8ba1\u767b\u5f55" + nobleHonorChangeWithoutGiftMessage.logionDaySum + "\u5929\uff0c\u4eca\u5929\u9996\u6b21" + source + "\u767b\u5f55\uff0c\u6da8\u8363\u8000\u503c" + nobleHonorChangeWithoutGiftMessage.increaseHonor;
                    break;
                }
                case 6: {
                    if (nobleHonorChangeWithoutGiftMessage.bigpayMonth <= 0 && nobleHonorChangeWithoutGiftMessage.allMoney > 0) {
                        nobleHonorChangeWithoutGiftMessage.text = "\u6d88\u8d39\u989d" + nobleHonorChangeWithoutGiftMessage.allMoney + "\uff0c\u4eca\u5929\u9996\u6b21" + source + "\u9001\u793c\uff0c\u6da8\u8363\u8000\u503c" + nobleHonorChangeWithoutGiftMessage.increaseHonor;
                        break;
                    }
                    if (nobleHonorChangeWithoutGiftMessage.bigpayMonth <= 0) break;
                    nobleHonorChangeWithoutGiftMessage.text = "\u4eca\u5929\u9996\u6b21" + source + "\u9001\u793c\uff0c\u6da8\u8363\u8000\u503c" + nobleHonorChangeWithoutGiftMessage.increaseHonor;
                    break;
                }
            }
            nobleHonorChangeWithoutGiftMessage.text = "noble" + nobleHonorChangeWithoutGiftMessage.nickname + " " + nobleHonorChangeWithoutGiftMessage.text;
            Spannable spannable = RichTextManager.getInstance().getSpannableString(context, (CharSequence)nobleHonorChangeWithoutGiftMessage.text, this.features);
            int start2 = nobleHonorChangeWithoutGiftMessage.text.indexOf("\u8363\u8000\u503c");
            if (start2 >= 0) {
                nobleDrawable = context.getResources().getDrawable(R.drawable.ic_nobel_honor);
                nobleDrawable.setBounds(0, 0, nobleDrawable.getIntrinsicWidth(), nobleDrawable.getIntrinsicHeight());
                spannable.setSpan((Object)new CustomImageSpan(nobleDrawable, 2.0f), start2, start2 + 3, 33);
            }
            if ((nobleDrawable = this.getFixedSizedNobleImage(EntIdentityIconSet.getIconResId((int)nobleHonorChangeWithoutGiftMessage.nobleLevel), 18, 18, context)) != null) {
                nobleDrawable.setBounds(0, 0, nobleDrawable.getIntrinsicWidth(), nobleDrawable.getIntrinsicHeight());
            }
            spannable.setSpan((Object)new CustomImageSpan(nobleDrawable, 2, 0.0f, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context)), 0, "noble".length(), 33);
            spannable = this.setSpanColor(message, spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.que.add(new DanmuData(spannable, message.pureText, 3, message.uid, message.isReplay));
            }
        } else if (message instanceof TurnTableTurMessage) {
            Map map = ((TurnTableTurMessage)message).map;
            String name = (String)map.get("name");
            String num = (String)map.get("red_num");
            String ss = (String)map.get("desc");
            String channel = (String)map.get("ch_id");
            String left = (String)map.get("left");
            if (ss == null || ss.length() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder(ss);
            sb.insert(0, "image");
            int i1 = sb.lastIndexOf("[num]");
            int i2 = sb.lastIndexOf("[name]");
            int i3 = sb.lastIndexOf("[short_chId]");
            int i4 = sb.lastIndexOf("left");
            if (i1 > 0) {
                sb.replace(i1, i1 + "[num]".length(), num);
            }
            if (i2 > 0) {
                if (name.length() >= 12) {
                    name = name.substring(0, 12) + "...";
                }
                i2 = sb.lastIndexOf("[name]");
                sb.replace(i2, i2 + "[name]".length(), name);
            }
            if (i3 > 0) {
                i3 = sb.lastIndexOf("[short_chId]");
                sb.replace(i3, i3 + "[short_chId]".length(), channel);
            }
            if (i4 > 0) {
                i4 = sb.lastIndexOf("left");
                sb.replace(i4, i4 + "left".length(), left);
            }
            Spannable sp = DanmuTextManager.getSpannableString(context, sb, this.features);
            Drawable drawable3 = context.getResources().getDrawable(R.drawable.turntable_toutiao);
            drawable3.setBounds(0, 0, drawable3.getIntrinsicWidth(), drawable3.getIntrinsicHeight());
            CustomImageSpan imageSpan = new CustomImageSpan(drawable3, 2, 0.0f, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context));
            sp.setSpan((Object)imageSpan, 0, "image".length(), 33);
            sp = this.setSpanColor(message, sp, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder(sp, 0, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, sb.toString(), message.pureText, message.isReplay, false, false);
            }
        } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE)) {
            message.text = message.nickname + " " + message.text;
            SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
            spannable = this.addMentel(message, (Spannable)spannable, context);
            spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#6DEAFF"));
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, spannable.toString(), message.pureText, message.isReplay, false, false);
            }
        } else if (message instanceof TurnChairMessage) {
            SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
            spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#7bf0d6")), 0, message.text.length(), 33);
            if (!MedalCenter.getInstance().isActMedal()) {
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, spannable.toString(), message.pureText, message.isReplay, false, false);
            }
        } else if (message instanceof ChannelPkMvpChannelMsg) {
            String text = message.nickname + "\u6210\u529f\u62a2\u593a\u5750\u5e2d";
            SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text);
            spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#ffffff"));
            this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, "", message.pureText, message.isReplay, true, false);
        } else {
            if (message instanceof TaskMessage || message instanceof PluginPublicMessage || message instanceof ArGiftUpgradeMessage || message instanceof TrueLoveMessage) {
                return;
            }
            message.pureText = message.text;
            if (message.spannable != null) {
                DanmuData data = new DanmuData((Spannable)message.spannable, message.pureText, 0, -1L, message.isReplay);
                data.backGround = -1;
                this.que.add(data);
                this.checkTask(context);
                return;
            }
            boolean isAir = false;
            if (message.nickname != null && message.nickname.length() > this.nickLength) {
                message.nickname = message.nickname.substring(0, this.nickLength);
            }
            if (message.nickname != null) {
                message.text = message.nickname + " " + message.text;
            }
            SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)"a");
            spannable.append((CharSequence)message.nickname).append((CharSequence)" ").append((CharSequence)message.text);
            if (!TextUtils.isEmpty((CharSequence)message.text) && message.text != null) {
                if (YGroupTicketFilter.isYGroupTicketMessage((CharSequence)message.text)) {
                    return;
                }
                if (ChannelTicketFilter.isChannelTicketMessage((CharSequence)message.text)) {
                    spannable = DanmuTextManager.getSpannableString(context, message.text, this.features);
                    isAir = true;
                } else {
                    if (message.text.length() > 30) {
                        int i;
                        String tmp = message.text;
                        int count = 0;
                        for (i = 0; i < tmp.length() - 5; ++i) {
                            if (count >= 20) {
                                tmp = tmp.substring(0, i);
                                break;
                            }
                            if (tmp.charAt(i) == '/') {
                                String s = tmp.substring(i, i + 4);
                                if (this.emotionMap.contains(s)) {
                                    i += 3;
                                    ++count;
                                    continue;
                                }
                                s = tmp.substring(i, i + 5);
                                if (!this.emotionMap.contains(s)) continue;
                                i += 4;
                                ++count;
                                continue;
                            }
                            ++count;
                        }
                        if (count < 20) {
                            tmp = tmp.substring(0, i);
                        }
                        message.text = tmp + "...";
                    }
                    spannable = DanmuTextManager.getSpannableString(context, message.text, this.features);
                }
            }
            if (isAir) {
                spannable = this.addMentel(message, (Spannable)spannable, context);
                spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#6DEAFF"));
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, message.text, message.pureText, message.isReplay, false, isAir);
            } else {
                spannable = this.addMentel(message, (Spannable)spannable, context);
                if (!MedalCenter.getInstance().isActMedal()) {
                    if (LoginUtil.getUid() != message.uid) {
                        if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.TURE_LOVE_TYPE)) {
                            spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#7bf0d6"));
                            this.addGunPowder((Spannable)spannable, 3, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
                        } else {
                            spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#ffffff"));
                            this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#ffffff"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false, ContextCompat.getDrawable((Context)context, (int)R.drawable.public_chat_gift_message_bg));
                        }
                    } else {
                        spannable = this.setSpanColor(message, (Spannable)spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#6DEAFF"));
                        this.addGunPowder((Spannable)spannable, 100, Color.parseColor((String)"#ffffff"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false, ContextCompat.getDrawable((Context)context, (int)R.drawable.public_chat_gift_message_bg));
                    }
                }
            }
        }
        this.checkTask(context);
    }

    public void appendSpannableDanMu(ChannelMessage message, Context context) {
        SpannableStringBuilder spannable;
        if (!this.checkValid(context)) {
            return;
        }
        if (message.spannable == null) {
            if (message.text == null) {
                return;
            }
            spannable = new SpannableStringBuilder((CharSequence)message.text);
        } else {
            spannable = message.spannable;
        }
        try {
            if (DanMuCommentFilter.INSTANCE.interceptAnchorLiveFilter(message)) {
                spannable = DanMuCommentFilter.INSTANCE.getSpannable(context, message, this.features);
                if (spannable != null) {
                    this.addGunPowder((Spannable)spannable, 100, Color.parseColor((String)"#ffffff"), 0, message.uid, -1, DanMuCommentFilter.INSTANCE.isNormalPeople(message) + "", message.pureText, message.isReplay, false, false);
                }
            } else if (message instanceof GiftChannelMessage) {
                this.addGunPowder((Spannable)spannable, 2, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, true, false);
            } else if (message instanceof NobleChannelMessage) {
                this.addGunPowder((Spannable)spannable, 2, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
            } else if (message instanceof FlowerChinneMessage) {
                this.addGunPowder((Spannable)spannable, 2, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, "", message.pureText, message.isReplay, true, false);
            } else if (message instanceof NobleLevelUpgradeChannelMessage) {
                this.addGunPowder((Spannable)spannable, 3, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, "", message.pureText, message.isReplay, false, false);
            } else if (message instanceof NobleHonorChangeWithoutGiftMessage) {
                this.addDanMuData((Spannable)spannable, new DanmuData((Spannable)spannable, message.pureText, 3, message.uid, message.isReplay));
            } else if (message instanceof TurnTableTurMessage) {
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, spannable.toString(), message.pureText, message.isReplay, false, false);
            } else if (message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SHARE_MESSAGE_TYPE) || message.channelMessageType.equals((Object)ChannelMessage.ChannelMsgType.SUBSCRIBE_MESSAGE_TYPE)) {
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#6DEAFF"), 0, message.uid, -1, spannable.toString(), message.pureText, message.isReplay, false, false);
            } else if (message instanceof TurnChairMessage) {
                this.addGunPowder((Spannable)spannable, 0, Color.parseColor((String)"#7bf0d6"), 0, message.uid, -1, spannable.toString(), message.pureText, message.isReplay, false, false);
            } else {
                DanmuData data = new DanmuData((Spannable)message.spannable, message.pureText, 0, -1L, message.isReplay);
                data.backGround = -1;
                this.addDanMuData((Spannable)spannable, data);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"appendSpannableDanMu: ", (Throwable)throwable, (Object[])new Object[0]);
        }
        this.checkTask(context);
    }

    private void addDanMuData(Spannable spannable, DanmuData danmuData) {
        this.addGunPowder(spannable, danmuData.priority, danmuData.textColor, danmuData.lineNum, danmuData.senderUid, danmuData.backGround, danmuData.contend, danmuData.pureText, danmuData.isReplay, danmuData.isGiftMessage, danmuData.isAir);
    }

    private boolean checkValid(Context context) {
        DanmuTextManager.init();
        this.initDanmuTextView(context);
        return this.isDanmuEnabled() && this.isOpen();
    }

    public synchronized void checkTask(Context context) {
        if (this.task == null) {
            this.init(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Spannable addMentel(ChannelMessage message, Spannable spannable, Context context) {
        if (mParseManage != null) return mParseManage.parseDanMuSpannable(context, message, spannable);
        Class<DanMuMedalParseManage> clazz = DanMuMedalParseManage.class;
        synchronized (DanMuMedalParseManage.class) {
            if (mParseManage != null) return mParseManage.parseDanMuSpannable(context, message, spannable);
            mParseManage = new DanMuMedalParseManage();
            mParseManage.initDanMuModelType();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return mParseManage.parseDanMuSpannable(context, message, spannable);
        }
    }

    public Spannable setSpanColor(ChannelMessage message, Spannable spannable, int nicknameColor, int textColor) {
        int idx;
        if (spannable == null) {
            return null;
        }
        spannable.setSpan((Object)new ForegroundColorSpan(textColor), 0, spannable.length(), 33);
        if (!TextUtils.isEmpty((CharSequence)message.nickname) && (idx = spannable.toString().indexOf(message.nickname)) >= 0 && idx < spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(nicknameColor), idx, idx + message.nickname.length(), 33);
        }
        return spannable;
    }

    private SpannableStringBuilder getBroadCastDanMuSpannable(Context context, BCItem item2) {
        if (item2.bcType == 0) {
            return this.getCombGiftSpannable(item2, context);
        }
        if (item2.bcType == 1) {
            return this.getHotBallSpannable(item2, context);
        }
        if (item2.bcType == 4 || item2.bcType == 5) {
            return this.getRedPacketSpannable(item2, context);
        }
        return null;
    }

    private SpannableStringBuilder getHotBallSpannable(BCItem item2, Context context) {
        Drawable bcTypeDrawable;
        String fromNick;
        SpannableStringBuilder spannable = new SpannableStringBuilder();
        String string2 = fromNick = TextUtils.isEmpty((CharSequence)item2.fromNick) ? "" : item2.fromNick;
        if (TextUtils.isEmpty((CharSequence)fromNick)) {
            String string3 = fromNick = TextUtils.isEmpty((CharSequence)((CharSequence)item2.extendInfo.get("name"))) ? "" : (String)item2.extendInfo.get("name");
        }
        if (fromNick.length() > 12) {
            fromNick = fromNick.substring(0, 12) + "...";
        }
        spannable.append((CharSequence)BCTYPE_PLACE_HOLDER).append((CharSequence)fromNick).append((CharSequence)IN_CHANNEL_STR).append((CharSequence)String.valueOf(item2.sid));
        if (!FP.empty((Map)item2.extendInfo) && TurnTableUtils.checkIsCherryBlossomsBroadcast((String)((String)item2.extendInfo.get("item_id_native")))) {
            spannable.append((CharSequence)" \u9001\u51fa\u6d6a\u6f2b\u5962\u534e\u7684\u6d6a\u6f2b\u6a31\u82b1\uff01");
        } else {
            spannable.append((CharSequence)" \u9001\u51fa\u6d6a\u6f2b\u5962\u534e\u7684\u70ed\u6c14\u7403\u4e4b\u7ea6\uff01");
        }
        int idxStart = 0;
        int idxEnd = spannable.toString().length();
        spannable.setSpan((Object)new AbsoluteSizeSpan(13, true), idxStart, idxEnd, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), idxStart, idxEnd, 34);
        int giftType = Integer.parseInt((String)item2.extendInfo.get("gift_id"));
        String giftIconUrl = GiftConfigParser.getInstance().getGiftIconPath(giftType);
        if (!StringUtil.isNullOrEmpty((CharSequence)giftIconUrl)) {
            bcTypeDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig());
            if (null == bcTypeDrawable) {
                ImageLoader.preloadBitmap((String)giftIconUrl, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.lr_ic_default_gift);
            }
        } else {
            bcTypeDrawable = SafeDrawableUtils.getDrawable(R.drawable.lr_ic_default_gift);
        }
        int idxBcIcon = spannable.toString().indexOf(BCTYPE_PLACE_HOLDER);
        if (bcTypeDrawable != null) {
            bcTypeDrawable.setBounds(0, 0, imgSize, imgSize);
            spannable.setSpan((Object)new CustomImageSpan(bcTypeDrawable, 2, 0.0f, 8.0f), idxBcIcon, idxBcIcon + BCTYPE_PLACE_HOLDER.length(), 33);
        } else {
            spannable.replace(idxBcIcon, idxBcIcon + BCTYPE_PLACE_HOLDER.length(), (CharSequence)"");
        }
        int idxChannel = spannable.toString().indexOf(IN_CHANNEL_STR);
        int enIdxChannel = idxChannel + IN_CHANNEL_STR.length();
        spannable.setSpan((Object)new AbsoluteSizeSpan(13, true), idxChannel, enIdxChannel, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffe00b")), idxChannel, enIdxChannel, 34);
        return spannable;
    }

    protected SpannableStringBuilder getCombGiftSpannable(BCItem item2, Context context) {
        String toNick;
        String fromNick;
        SpannableStringBuilder spannable = new SpannableStringBuilder();
        String string2 = fromNick = TextUtils.isEmpty((CharSequence)item2.fromNick) ? "" : item2.fromNick;
        if (fromNick.length() > 12) {
            fromNick = fromNick.substring(0, 12) + "...";
        }
        String string3 = toNick = TextUtils.isEmpty((CharSequence)item2.toNick) ? "" : item2.toNick;
        if (toNick.length() > 12) {
            toNick = toNick.substring(0, 12) + "...";
        }
        spannable.append((CharSequence)BCTYPE_PLACE_HOLDER);
        spannable.append((CharSequence)fromNick);
        spannable.append((CharSequence)"  \u9001\u7ed9  ");
        spannable.append((CharSequence)toNick);
        spannable.append((CharSequence)GIFT_PLACE_HOLDER);
        String giftInfo = item2.num + "x" + item2.comboNum + "\u7ec4";
        spannable.append((CharSequence)giftInfo);
        Drawable bcTypeDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_danmu_plane);
        int idxFromNick = spannable.toString().indexOf(fromNick);
        int enIdxFromNick = idxFromNick + fromNick.length();
        spannable.setSpan((Object)new AbsoluteSizeSpan(13, true), idxFromNick, enIdxFromNick, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), idxFromNick, enIdxFromNick, 34);
        int idxSend = enIdxFromNick;
        int enIdxSend = idxSend + 4;
        spannable.setSpan((Object)new AbsoluteSizeSpan(11, true), idxSend, enIdxSend, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffe00b")), idxSend, enIdxSend, 34);
        int idxToNick = spannable.toString().indexOf(toNick);
        int enIdxToNick = idxToNick + toNick.length();
        spannable.setSpan((Object)new AbsoluteSizeSpan(13, true), idxToNick, enIdxToNick, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), idxToNick, enIdxToNick, 34);
        int idxGiftInfo = spannable.toString().indexOf(giftInfo);
        int enIdxGiftInfo = idxGiftInfo + giftInfo.length();
        spannable.setSpan((Object)new AbsoluteSizeSpan(13, true), idxGiftInfo, enIdxGiftInfo, 17);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffffff")), idxGiftInfo, enIdxGiftInfo, 34);
        final String giftIconUrl = GiftConfigParser.getInstance().getGiftIconPath(item2.type);
        int mGiftMessageImageSize = (int)ResolutionUtils.convertDpToPixel((float)23.0f, (Context)context) + 1;
        final ImageConfig config = new ImageConfig(mGiftMessageImageSize, mGiftMessageImageSize);
        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapFromCache((String)giftIconUrl, (ImageConfig)config);
        if (bitmapDrawable == null) {
            ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)giftIconUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                }

                public void onResourceReady(Bitmap bitmap) {
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                    ImageLoader.addBitmapToCache((String)giftIconUrl, (BitmapDrawable)bitmapDrawable, (ImageConfig)config);
                }
            });
            bitmapDrawable = context.getResources().getDrawable(R.drawable.lr_ic_default_gift);
        }
        int idxGiftIcon = spannable.toString().indexOf(GIFT_PLACE_HOLDER);
        bitmapDrawable.setBounds(0, 0, mGiftMessageImageSize, mGiftMessageImageSize);
        spannable.setSpan((Object)new CustomImageSpan((Drawable)bitmapDrawable, 2, 0.0f, 0.0f), idxGiftIcon, idxGiftIcon + GIFT_PLACE_HOLDER.length(), 33);
        int idxBcIcon = spannable.toString().indexOf(BCTYPE_PLACE_HOLDER);
        if (bcTypeDrawable != null) {
            bcTypeDrawable.setBounds(0, 0, imgSize, imgSize);
            spannable.setSpan((Object)new CustomImageSpan(bcTypeDrawable, 2, 0.0f, 8.0f), idxBcIcon, idxBcIcon + BCTYPE_PLACE_HOLDER.length(), 33);
        } else {
            spannable.replace(idxBcIcon, idxBcIcon + BCTYPE_PLACE_HOLDER.length(), (CharSequence)"");
        }
        return spannable;
    }

    private SpannableStringBuilder getRedPacketSpannable(BCItem item2, Context context) {
        String toNick;
        String nick = item2.fromNick != null ? item2.fromNick : "";
        String string2 = toNick = item2.toNick != null ? item2.toNick : "";
        if (nick.length() >= 7) {
            nick = nick.substring(0, 7) + "...";
        }
        if (toNick.length() >= 7) {
            toNick = toNick.substring(0, 7) + "...";
        }
        String src = nick + "\u5728" + toNick + "\u76f4\u64ad\u95f4\u4efb\u6027\u72c2\u6492\u5de8\u989dred_packet_flag \u5566\uff01";
        SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)src);
        Pattern p1 = Pattern.compile("red_packet_flag");
        Matcher m1 = p1.matcher(src);
        int width = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)context);
        int height = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)context);
        while (m1.find()) {
            BitmapDrawable bd = ImageUtil.getBitmapDrawableFromResource((int)width, (int)height, (int)R.drawable.red_packet_bg);
            bd.setBounds(0, 0, width, height);
            CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bd, 2.0f);
            sp.setSpan((Object)imageSpan, m1.start(), m1.end(), 33);
        }
        return sp;
    }

    public Spannable setSpanColorAndBackground(ChannelMessage message, Spannable spannable, @ColorInt int nickNameColor, @ColorInt int textColor) {
        int idx;
        if (spannable == null) {
            return null;
        }
        ForegroundColorSpan nameSpan = new ForegroundColorSpan(nickNameColor);
        ForegroundColorSpan textSpan = new ForegroundColorSpan(textColor);
        spannable.setSpan((Object)textSpan, 0, spannable.length(), 33);
        if (!TextUtils.isEmpty((CharSequence)message.nickname) && (idx = spannable.toString().indexOf(message.nickname)) >= 0 && idx < spannable.length()) {
            spannable.setSpan((Object)nameSpan, idx, idx + message.nickname.length(), 33);
        }
        return spannable;
    }

    private void addGunPowder(Spannable span, int priority, int color2, int lineNum, long senderUid, int backGround, String contend, String pureText, boolean isReplay, boolean isGift, boolean isAir) {
        if (this.que.size() > 200) {
            this.stopDanmu();
            this.open(true);
        }
        DanmuData data = new DanmuData(span, pureText, priority, color2, lineNum, senderUid);
        data.priority = priority;
        data.contend = contend;
        data.backGround = backGround;
        data.isReplay = isReplay;
        data.isGiftMessage = isGift;
        data.isAir = isAir;
        data.pureText = pureText;
        this.que.add(data);
    }

    private void addGunPowder(Spannable span, int priority, int color2, int lineNum, long senderUid, int backGround, String contend, String pureText, boolean isReplay, boolean isGift, boolean isAir, Drawable bgDrawable) {
        if (this.que.size() > 200) {
            this.stopDanmu();
            this.open(true);
        }
        DanmuData data = new DanmuData(span, pureText, priority, color2, lineNum, senderUid);
        data.priority = priority;
        data.contend = contend;
        data.backGround = backGround;
        data.isReplay = isReplay;
        data.isGiftMessage = isGift;
        data.isAir = isAir;
        data.pureText = pureText;
        data.bgDrawable = bgDrawable;
        this.que.add(data);
    }

    private void init(Context context) {
        this.task = new Thread(){

            @Override
            public void run() {
                try {
                    while (DanMuUtil.this.door.get()) {
                        DanmuData tmp = (DanmuData)DanMuUtil.this.que.take();
                        if (tmp != null) {
                            BitmapGunPowder tmpPowder = new BitmapGunPowder(tmp.priority, tmp.backGround, tmp.contend, BasicConfig.getInstance().getAppContext(), DanMuUtil.this.mDanmuTextView);
                            tmpPowder.span = tmp.span;
                            tmpPowder.textColor = tmp.textColor;
                            tmpPowder.mTextSize = tmp.textSize;
                            tmpPowder.senderUid = tmp.senderUid;
                            tmpPowder.isReplay = tmp.isReplay;
                            tmpPowder.isGiftMessage = tmp.isGiftMessage;
                            tmpPowder.isAir = tmp.isAir;
                            tmpPowder.pureText = tmp.pureText;
                            tmpPowder.bgDrawable = tmp.bgDrawable;
                            if (DanMuUtil.this.danmuCount.get() >= 80) {
                                DanMuUtil.this.priorityDanmu.clear();
                                DanMuUtil.this.normalDanmu.clear();
                                DanMuUtil.this.myDanmu.clear();
                                DanMuUtil.this.danmuCount.set(0);
                            }
                            DanMuUtil.this.danmuCount.incrementAndGet();
                            DanMuUtil.this.addDanmu(tmpPowder);
                        }
                        Thread.sleep(300L);
                    }
                }
                catch (InterruptedException e) {
                    MLog.info((Object)"wangke", (String)"DanMu thread end normal", (Object[])new Object[0]);
                }
                catch (Throwable t) {
                    MLog.info((Object)"wangke", (String)("DanMu thread end error" + t.toString()), (Object[])new Object[0]);
                }
            }
        };
        this.door.set(true);
        this.task.start();
    }

    private void addDanmu(BitmapGunPowder bitmapGunPowder) {
        if (bitmapGunPowder.isme && bitmapGunPowder.p > 10) {
            this.myDanmu.add(bitmapGunPowder);
        } else if (bitmapGunPowder.p > 0) {
            this.priorityDanmu.add(bitmapGunPowder);
        } else {
            this.normalDanmu.add(bitmapGunPowder);
        }
    }

    public IDanmuOpenStatus getDanmuOpenStatus(@DanmuOpenStatusType int type) {
        switch (type) {
            case 0: {
                return new IDanmuOpenStatus(){

                    public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                        if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                            return;
                        }
                        DanMuUtil.this.pushDanmuFromButtomToTop(hashMap);
                    }
                };
            }
            case 2: {
                return new IDanmuOpenStatus(){

                    public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                        if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                            return;
                        }
                        DanMuUtil.this.pushDanmuForGameTemplate(hashMap);
                    }
                };
            }
        }
        return new IDanmuOpenStatus(){

            public void getGunPower(HashMap<Integer, Boolean> hashMap) {
                if (!DanMuUtil.this.isDanmuEnabled() || !DanMuUtil.this.isOpen() && hashMap == null) {
                    return;
                }
                if (ICoreManagerBase.getCore(IInvincibleDanmuCore.class) != null && ((IInvincibleDanmuCore)ICoreManagerBase.getCore(IInvincibleDanmuCore.class)).isOpenLandscapeInvincibleDanmu()) {
                    DanMuUtil.this.pushInvincibleDanmu(hashMap);
                } else {
                    DanMuUtil.this.pushDanmu(hashMap);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmu(HashMap<Integer, Boolean> map) {
        AtomicInteger atomicInteger = this.danmuCount;
        synchronized (atomicInteger) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue()) continue;
                    BitmapGunPowder tmp = null;
                    tmp = i == map.size() - 1 ? (this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll())) : this.normalDanmu.poll();
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmuFromButtomToTop(HashMap<Integer, Boolean> map) {
        AtomicInteger atomicInteger = this.danmuCount;
        synchronized (atomicInteger) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue()) continue;
                    BitmapGunPowder tmp = null;
                    tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDanmuForGameTemplate(HashMap<Integer, Boolean> map) {
        AtomicInteger atomicInteger = this.danmuCount;
        synchronized (atomicInteger) {
            if (this.door.get()) {
                for (int i = map.size() - 1; i >= 0; --i) {
                    if (!map.get(i).booleanValue() || !this.isValidPosition(i)) continue;
                    BitmapGunPowder tmp = null;
                    tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                    if (tmp == null) continue;
                    tmp.convert(this.isSurfaceView());
                    if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                        ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                    }
                    this.danmuCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInvincibleDanmu(HashMap<Integer, Boolean> map) {
        if (this.door.get()) {
            for (int i = map.size() - 1; i >= 0; --i) {
                if (!map.get(i).booleanValue()) continue;
                if (i == map.size() - 1 && i != 0) {
                    AtomicInteger atomicInteger = this.danmuCount;
                    synchronized (atomicInteger) {
                        BitmapGunPowder tmp = null;
                        tmp = this.myDanmu.size() != 0 ? this.myDanmu.poll() : (this.priorityDanmu.size() != 0 ? this.priorityDanmu.poll() : this.normalDanmu.poll());
                        if (tmp != null) {
                            tmp.convert(this.isSurfaceView());
                            if (tmp.bitmap != null && this.mDanmuView != null && this.mDanmuView.get() != null) {
                                ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)tmp, i);
                            }
                            this.danmuCount.decrementAndGet();
                        }
                        continue;
                    }
                }
                InvincibleDanmuInfo info = ((IInvincibleDanmuCore)ICoreManagerBase.getCore(IInvincibleDanmuCore.class)).pollInvincibleDanmu();
                if (info == null) continue;
                info.createPowertoShell(null);
                if (info.bitmap == null || this.mDanmuView == null || this.mDanmuView.get() == null) continue;
                ((IDanmukuView)this.mDanmuView.get()).sendGunPower((GunNewPower)info, i);
            }
        }
    }

    public void setCurrentPosition(DanMuPosition mCurrentPosition) {
        this.mCurrentPosition = mCurrentPosition;
    }

    protected boolean isValidPosition(int i) {
        switch (this.mCurrentPosition) {
            case TOP: {
                if (i < 0 || i > 2) break;
                return true;
            }
            case BOTTOM: {
                if (i < 5 || i > 7) break;
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    protected void updateShaderMatrix(BitmapShader bitmapShader, int bitmapWidth, int bitmapHeight, Rect drawableRect) {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        Matrix mShaderMatrix = new Matrix();
        mShaderMatrix.set(null);
        if (bitmapWidth * drawableRect.height() > drawableRect.width() * bitmapHeight) {
            scale = (float)drawableRect.height() / (float)bitmapHeight;
            dx = ((float)drawableRect.width() - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = (float)drawableRect.width() / (float)bitmapWidth;
            dy = ((float)drawableRect.height() - (float)bitmapHeight * scale) * 0.5f;
        }
        mShaderMatrix.setScale(scale, scale);
        mShaderMatrix.postTranslate((float)((int)(dx + 0.5f) + 2), (float)((int)(dy + 0.5f) + 2));
        bitmapShader.setLocalMatrix(mShaderMatrix);
    }

    public void stopDanmu() {
        this.danmuCount = new AtomicInteger();
        this.door.set(false);
        if (this.task != null) {
            this.task.interrupt();
        }
        this.task = null;
        this.que.clear();
        this.priorityDanmu.clear();
        this.normalDanmu.clear();
        this.myDanmu.clear();
        this.openStatus = false;
        MLog.info((Object)TAG, (String)"stopDanMu", (Object[])new Object[0]);
    }

    public void open(boolean open) {
        this.openStatus = open;
        MLog.info((Object)TAG, (String)("isOpen=" + open), (Object[])new Object[0]);
    }

    public boolean isOpen() {
        return this.openStatus;
    }

    public boolean isDanmuEnabled() {
        return this.mDanmuEnabled;
    }

    public void setDanmuEnabled(boolean enabled) {
        IDanmukuView danmukuView = this.getDanmuView();
        if (danmukuView != null) {
            danmukuView.setVisibility(enabled ? 0 : 4);
        }
        CommonPref.instance().putBoolean(this.getDanmu_enabledString(), enabled);
        this.mDanmuEnabled = enabled;
        MLog.info((Object)TAG, (String)("setDanmuEnabled DanmuEnabled:" + this.mDanmuEnabled), (Object[])new Object[0]);
    }

    private boolean isDanmuEnabledFromPreference() {
        return CommonPref.instance().getBoolean(this.getDanmu_enabledString(), true);
    }

    protected String getDanmu_enabledString() {
        return "shareed_pref_name_danmu_enabled";
    }

    public void setDanmuEnabledWithoutStoreState(boolean enable) {
        IDanmukuView danmukuView = this.getDanmuView();
        if (danmukuView != null) {
            danmukuView.setVisibility(enable ? 0 : 4);
        }
        this.mDanmuEnabled = enable;
        MLog.info((Object)TAG, (String)("setDanmuEnabledWithoutStoreState DanmuEnabled:" + this.mDanmuEnabled), (Object[])new Object[0]);
    }
}

