/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.ylink;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleRegistry;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.duowan.mobile.basemedia.watchlive.template.ComponentRoot;
import com.gyf.immersionbar.ImmersionBar;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.SpdtSkin;
import com.yy.android.sniper.annotation.mvp.DelegateBind;
import com.yy.immersion.AndroidBug5497Workaround;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoProtocol;
import com.yy.mobile.ui.BackHandlerHelper;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.activity.MultiWindowViewModel;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.VideoLayoutConstants;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.ylink.LiveTemplatePresenter;
import com.yy.mobile.ui.ylink.SpdtAndroidBug5497;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IDataReportCore;
import mobile.yy.com.toucheventbus.TouchEventBus;

@DelegateBind(presenter=LiveTemplatePresenter.class)
@SpdtSkin
public class LiveTemplateActivity
extends BasePluginEntLiveActivity<LiveTemplatePresenter, LiveTemplateActivity> {
    public static final String TAG = "LiveTemplateActivity";
    public static final String TEMPLATEMANAGER_TYPE = "TemplateManager_type";
    private FrameLayout frameLayout;
    private MultiWindowViewModel multiWindowViewModel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.setVideoMarginTopDp();
        super.onCreate(savedInstanceState);
        if (!this.sdkInitStatus.get()) {
            return;
        }
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        this.setContentView(R.layout.activity_basic_channel_template);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.content_layout);
        this.multiWindowViewModel = MultiWindowViewModel.get((FragmentActivity)this);
        this.multiWindowViewModel.addActivityLayoutChangeLisenter((View)this.frameLayout);
        this.resumeChannelVoice();
        ICoreManagerBase.addClient((Object)((Object)this));
        if (((SpdtAndroidBug5497)Spdt.of(SpdtAndroidBug5497.class)).enable()) {
            AndroidBug5497Workaround.assistActivity((Activity)this);
        }
        GlobalActivityManager.INSTANCE.addActivityToReport(((Object)((Object)this)).getClass().getName());
    }

    protected void onSaveInstanceState(Bundle outState) {
        try {
            ((LiveTemplatePresenter)this.mPresenter).saveInfoToBundle(outState);
            super.onSaveInstanceState(outState);
            outState.putParcelable("android:support:fragments", null);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @Override
    protected void onDestroy() {
        MLog.info((Object)TAG, (String)"zy onDestroy", (Object[])new Object[0]);
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        ICoreManagerBase.removeClient((Object)((Object)this));
        super.onDestroy();
    }

    @Override
    protected void onStart() {
        super.onStart();
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_START);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.resumeChannelVoice();
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
    }

    @Override
    protected void onPause() {
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
        super.onPause();
    }

    protected void onStop() {
        ((LifecycleRegistry)this.getLifecycle()).handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        super.onStop();
    }

    private void resumeChannelVoice() {
        MediaVideoProtocol.Factory.get().vodMuteLiveAudio(false);
        if (ICoreManagerBase.getMediaCore() != null) {
            ICoreManagerBase.getMediaCore().switchVoice(true);
        } else {
            MLog.error((Object)TAG, (String)"ICoreManagerBase.getMediaCore() = null", (Object[])new Object[0]);
        }
    }

    private void setVideoMarginTopDp() {
        int marginTop = 138 + DensityUtil.px2dip((Context)this, (float)ImmersionBar.getStatusBarHeight((Activity)this));
        VideoLayoutConstants.INSTANCE.setVideoMarginTopDp(marginTop);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (Fragment fragment : this.getSupportFragmentManager().getFragments()) {
            if (fragment == null) continue;
            fragment.onActivityResult(requestCode, resultCode, data);
        }
        if (this.mPresenter != null) {
            ((LiveTemplatePresenter)this.mPresenter).onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.sdkInitStatus.get()) {
            ((LiveTemplatePresenter)this.mPresenter).onNewIntent(intent);
            this.setIntent(intent);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean ret = TouchEventBus.dispatchTouchEvent((MotionEvent)ev, (Activity)this);
        if (!ret) {
            ret = super.dispatchTouchEvent(ev);
        }
        return ret;
    }

    @Override
    public void onBackPressed() {
        MLog.info((Object)TAG, (String)"onBackPressed", (Object[])new Object[0]);
        IDataReportCore iDataReportCore = (IDataReportCore)Spdt.ofOrNull(IDataReportCore.class);
        if (iDataReportCore != null) {
            iDataReportCore.reportOnClickBackKeyExitedChannel();
        }
        if (!BackHandlerHelper.handleBackPress((FragmentActivity)this)) {
            boolean handleBackPressed = this.onHandleBackPressed();
            MLog.info((Object)TAG, (String)("onBackPressed  handleBackPress " + handleBackPressed), (Object[])new Object[0]);
            if (!handleBackPressed) {
                super.onBackPressed();
            }
        }
    }

    public void finish() {
        if (this.mPresenter == null || !((LiveTemplatePresenter)this.mPresenter).interceptFinish()) {
            super.finish();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mPresenter != null) {
            ((LiveTemplatePresenter)this.mPresenter).onConfigurationChanged(newConfig);
        }
        int currentNightMode = newConfig.uiMode & 0x30;
        switch (currentNightMode) {
            case 16: {
                MLog.info((Object)TAG, (String)"onConfigurationChanged  currentNightMode is UI_MODE_NIGHT_NO ", (Object[])new Object[0]);
                break;
            }
            case 32: {
                MLog.info((Object)TAG, (String)"onConfigurationChanged  currentNightMode is UI_MODE_NIGHT_YES ", (Object[])new Object[0]);
            }
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (this.mPresenter != null) {
            ((LiveTemplatePresenter)this.mPresenter).onWindowFocusChanged(hasFocus);
        }
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
        super.onMultiWindowModeChanged(isInMultiWindowMode);
        if (this.multiWindowViewModel != null) {
            this.multiWindowViewModel.updateMultiWindowModeChanged(isInMultiWindowMode);
        }
    }

    public ComponentRoot getRoot() {
        return ((LiveTemplatePresenter)this.mPresenter).getRoot();
    }

    public boolean needBackToMainWhenKickedOff() {
        return false;
    }

    protected boolean handleStatusBar() {
        return true;
    }
}

