/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.main.events.IWebViewClient_onCloseTaskWebDialog_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.utils.CommonWebPopupComponent$$EventBinder;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;

public class CommonWebPopupComponent
extends PopupComponent
implements EventCompat {
    private IWebViewEventListener webViewEventListener;
    private String url;
    private int width;
    private int height;
    private int gravity;
    private float backgroundAlpha;
    private boolean backgroundGray = false;
    private boolean isEnableCloseOutside = true;
    private boolean isTransparent = false;
    private int windowAnimationId = 0;
    private boolean closeBtn = false;
    private EventBinder mCommonWebPopupComponentSniperEventBinder;

    public CommonWebPopupComponent setUrl(String url) {
        this.url = url;
        return this;
    }

    public CommonWebPopupComponent setWidth(int width) {
        this.width = width;
        return this;
    }

    public CommonWebPopupComponent setHeight(int height) {
        this.height = height;
        return this;
    }

    public CommonWebPopupComponent setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public CommonWebPopupComponent setWebViewEventListener(IWebViewEventListener webViewEventListener) {
        this.webViewEventListener = webViewEventListener;
        return this;
    }

    public CommonWebPopupComponent setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
        return this;
    }

    public CommonWebPopupComponent setBackgroundTransparent(boolean isTransparent) {
        this.isTransparent = isTransparent;
        return this;
    }

    public CommonWebPopupComponent setCloseButtonIsShow(boolean isShow) {
        this.closeBtn = isShow;
        return this;
    }

    public CommonWebPopupComponent setBackground(boolean isGray) {
        this.backgroundGray = isGray;
        return this;
    }

    public CommonWebPopupComponent setCanceledOnTouchOutside(boolean enabled) {
        this.isEnableCloseOutside = enabled;
        return this;
    }

    public CommonWebPopupComponent setWindowAnimationId(int resId) {
        this.windowAnimationId = resId;
        return this;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        if (this.windowAnimationId != 0) {
            dialog.getWindow().setWindowAnimations(this.windowAnimationId);
        } else {
            dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        }
        dialog.getWindow().setBackgroundDrawableResource(17170445);
        dialog.getWindow().setGravity(this.gravity != 0 ? this.gravity : 81);
        dialog.setCanceledOnTouchOutside(this.isEnableCloseOutside);
        if (this.width == 0) {
            this.width = -1;
        }
        if (this.height == 0) {
            this.height = -2;
        }
        dialog.getWindow().setLayout(this.width, this.height);
        if (this.backgroundGray) {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = 0.5f;
            dialog.getWindow().setAttributes(lp);
            dialog.getWindow().addFlags(2);
        }
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        BaseLinkFragment mWVFragment;
        View layout2 = inflater.inflate(R.layout.common_web_popup_component, container, false);
        RelativeLayout web = (RelativeLayout)layout2.findViewById(R.id.webview_layout);
        if (this.isTransparent) {
            web.setBackgroundColor(this.getResources().getColor(17170445));
        }
        if (this.closeBtn) {
            layout2.findViewById(R.id.cls_btn).setVisibility(0);
            layout2.findViewById(R.id.cls_btn).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CommonWebPopupComponent.this.dismissAllowingStateLoss();
                }
            });
        }
        if ((mWVFragment = this.getOrCreatWebViewFragment(this.url)) != null) {
            FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
            if (mWVFragment.isDetached()) {
                ft.attach((Fragment)mWVFragment);
                ft.commitAllowingStateLoss();
            } else if (!mWVFragment.isAdded()) {
                ft.add(R.id.webview_layout, (Fragment)mWVFragment);
                ft.commitAllowingStateLoss();
            }
        }
        return layout2;
    }

    public BaseLinkFragment getOrCreatWebViewFragment(String url) {
        if (this.webViewEventListener == null) {
            this.webViewEventListener = new WebViewEventListener();
        }
        if (CoreApiManager.getInstance() == null || CoreApiManager.getInstance().getApi(WebViewFragmentApi.class) == null) {
            return null;
        }
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, this.webViewEventListener, false);
        return wvFragment;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    @BusEvent
    public void onCloseTaskWebDialog(IWebViewClient_onCloseTaskWebDialog_EventArgs busEventArgs) {
        this.dismissAllowingStateLoss();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mCommonWebPopupComponentSniperEventBinder == null) {
            this.mCommonWebPopupComponentSniperEventBinder = new CommonWebPopupComponent$$EventBinder();
        }
        this.mCommonWebPopupComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mCommonWebPopupComponentSniperEventBinder != null) {
            this.mCommonWebPopupComponentSniperEventBinder.unBindEvent();
        }
    }
}

