/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.replay;

import android.view.View;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.liveapi.user.personalinfocard.PersonalInfoCardBuilder;
import com.yy.mobile.liveapi.user.personalinfocard.PersonalInfoCardParams;
import com.yy.mobile.plugin.main.events.IArtistClient_onUserFansNumRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthVClient_onGetAuthVList_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_notifyReplayViewCount_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onQueryFansNum_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicfunction.livenotice.util.MaxExtend;
import com.yy.mobile.ui.mobilelive.replay.ReplayProgramInfoPresenter$$EventBinder;
import com.yy.mobile.ui.programinfo.mvp.IProgramInfoPresenter;
import com.yy.mobile.ui.programinfo.mvp.IProgramInfoView;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.authv.IAuthVCore;
import com.yymobile.core.domain.DomainManager;
import com.yymobile.core.mobilelive.IMobileLiveReplayCore;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.UserInfo;
import java.util.HashMap;
import java.util.Map;

public class ReplayProgramInfoPresenter
implements EventCompat,
IProgramInfoPresenter {
    private static final String TAG = "ReplayProgramInfoPresenter";
    private IProgramInfoView<Component> mProgramInfoView;
    private Component mFragment;
    private View mRootView;
    private long mUid = 0L;
    private String mAnchorImgUri = "";
    private EntUserInfo mEntUserInfo;
    private boolean isFromLeaveReplay = false;
    private EventBinder mReplayProgramInfoPresenterSniperEventBinder;

    public void onEventBind() {
        if (this.mReplayProgramInfoPresenterSniperEventBinder == null) {
            this.mReplayProgramInfoPresenterSniperEventBinder = new ReplayProgramInfoPresenter$$EventBinder();
        }
        this.mReplayProgramInfoPresenterSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReplayProgramInfoPresenterSniperEventBinder != null) {
            this.mReplayProgramInfoPresenterSniperEventBinder.unBindEvent();
        }
    }

    public ReplayProgramInfoPresenter(IProgramInfoView mProgramInfoView) {
        this.mProgramInfoView = mProgramInfoView;
        this.mFragment = (Component)mProgramInfoView.getIViewHost();
        this.mRootView = mProgramInfoView.getRootView();
        ICoreManagerBase.addClient((Object)this);
    }

    public void onCreate() {
        this.mUid = this.mProgramInfoView.getCurrentUid();
        if (this.mUid != 0L) {
            ((IAuthVCore)ICoreManagerBase.getCore(IAuthVCore.class)).querySingerAuthVInfo(this.mUid, null);
        }
        if (!this.isFromLeaveReplay) {
            this.mProgramInfoView.onUpdateOnlineCount("...\u4eba\u89c2\u770b");
            long num = ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).getReplayViewCount();
            MLog.info((Object)TAG, (String)("[onCreate] num=" + num), (Object[])new Object[0]);
            if (num >= 0L) {
                this.notifyReplayViewCount(num);
            }
        } else {
            this.mProgramInfoView.onUpdateOnlineCount("\u7c89\u4e1d:0");
        }
    }

    public void onStart() {
    }

    public void onResume() {
        this.mUid = this.mProgramInfoView.getCurrentUid();
        if (this.mUid != 0L) {
            ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mUid);
        }
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)this);
        this.isFromLeaveReplay = false;
        this.mProgramInfoView = null;
        this.mFragment = null;
        this.mRootView = null;
        this.mUid = 0L;
        this.mAnchorImgUri = "";
        this.mEntUserInfo = null;
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)("[onRequestDetailUserInfo] info=" + info + " isLocalData=" + isLocalData + " error = " + error), (Object[])new Object[0]);
        if (error == null && info != null && userId > 0L && userId == this.mUid) {
            if (!StringUtils.isNullOrEmpty((String)info.iconUrl_100_100)) {
                this.mAnchorImgUri = info.iconUrl_100_100;
            } else if (!StringUtils.isNullOrEmpty((String)info.iconUrl_144_144)) {
                this.mAnchorImgUri = info.iconUrl_144_144;
            } else if (!StringUtils.isNullOrEmpty((String)info.iconUrl_640_640)) {
                this.mAnchorImgUri = info.iconUrl_640_640;
            }
            this.mAnchorImgUri = DomainManager.replaceDownhdLogoYyComDomain((String)this.mAnchorImgUri);
        }
    }

    @BusEvent(sync=true)
    public void notifyReplayViewCount(IMobileLiveReplayClient_notifyReplayViewCount_EventArgs busEventArgs) {
        long num = busEventArgs.getNum();
        this.notifyReplayViewCount(num);
    }

    public void notifyReplayViewCount(long num) {
        MLog.info((Object)TAG, (String)("[notifyReplayViewCount] num=" + num), (Object[])new Object[0]);
        if (num < 0L) {
            return;
        }
        if (num < 10000L) {
            this.mProgramInfoView.onUpdateOnlineCount(num + "\u4eba\u89c2\u770b");
        } else {
            double dnum = (double)num / 10000.0;
            String nums = "0";
            try {
                nums = MaxExtend.round((String)(dnum + ""), (int)1, (int)4);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("[notifyReplayViewCount] e=" + e), (Object[])new Object[0]);
            }
            this.mProgramInfoView.onUpdateOnlineCount(nums + "\u4e07\u4eba\u89c2\u770b");
        }
    }

    @BusEvent(sync=true)
    public void onGetAuthVList(IAuthVClient_onGetAuthVList_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        HashMap authVInfo = busEventArgs.getAuthVInfo();
        Map extendInfo = busEventArgs.getExtendInfo();
        if (resultCode == 0 && authVInfo != null && authVInfo.size() > 0 && authVInfo.containsKey(this.mUid)) {
            if (((Uint32)authVInfo.get(this.mUid)).intValue() == 1) {
                this.mProgramInfoView.onLoadAuthV(R.drawable.common_portrait_auth_v_1);
            } else if (((Uint32)authVInfo.get(this.mUid)).intValue() == 2) {
                this.mProgramInfoView.onLoadAuthV(R.drawable.common_portrait_auth_v_10);
            }
        }
    }

    public void profileAnchor(long uid) {
        if (this.isFromLeaveReplay) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0002");
        }
    }

    @BusEvent(sync=true)
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        MLog.info((Object)TAG, (String)("onRequestProfile info=" + info + ", mUid=" + this.mUid + ", IsFromLeaveReplay=" + this.isFromLeaveReplay), (Object[])new Object[0]);
        if (info != null && info.uid == this.mUid && this.mUid != 0L) {
            this.mEntUserInfo = info;
            if (this.isFromLeaveReplay) {
                this.requestFollowInfo(info.userType == 1);
            }
        }
    }

    private void requestFollowInfo(boolean isAnchor) {
        MLog.info((Object)TAG, (String)("requestFollowInfo isAnchor:" + isAnchor + ", mUid:" + this.mUid), (Object[])new Object[0]);
        if (isAnchor) {
            ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).queryFansNum(this.mUid);
        } else {
            ((IArtistCore)ICoreManagerBase.getCore(IArtistCore.class)).queryUserFansNum(this.mUid);
        }
    }

    @BusEvent(sync=true)
    public void onQueryFansNum(IProfileClient_onQueryFansNum_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorUid();
        int count = busEventArgs.getCount();
        MLog.info((Object)TAG, (String)("onQueryFansNum result=" + result + ", anchorId=" + anchorId + ",count=" + count), (Object[])new Object[0]);
        if (result == 0 && anchorId == this.mUid && count >= 0 && this.isFromLeaveReplay) {
            this.mProgramInfoView.onUpdateOnlineCount("\u7c89\u4e1d:" + count);
        }
    }

    @BusEvent(sync=true)
    public void onUserFansNumRsp(IArtistClient_onUserFansNumRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        int count = busEventArgs.getCount();
        MLog.info((Object)TAG, (String)("onUserFansNumRsp result=" + result + ",uid=" + uid + ",count=" + count), (Object[])new Object[0]);
        if (result == 0 && uid == this.mUid && count >= 0 && this.isFromLeaveReplay) {
            this.mProgramInfoView.onUpdateOnlineCount("\u7c89\u4e1d:" + count);
        }
    }

    public void clickAnchorInfo(long uid) {
        if (this.mFragment.getFragmentManager() == null) {
            return;
        }
        AbsChannelControllerCore iMicAudienceNobleControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
        if (iMicAudienceNobleControllerCore == null || !iMicAudienceNobleControllerCore.isInterceptShowPersonalCard(uid, true, 0, this.mFragment.getFragmentManager(), true)) {
            new PersonalInfoCardBuilder(uid).setIsSignAnchor(this.mEntUserInfo != null && this.mEntUserInfo.userType == 1).setIsReplay(!this.isFromLeaveReplay).addViewVisibility(PersonalInfoCardParams.OrignBtn.PrivateChat, false).setUserIcon(this.mAnchorImgUri).setShowTrasureLove(false).withFragmentManager(this.mFragment.getFragmentManager()).show();
        }
        if (this.isFromLeaveReplay) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50402", "0001");
        }
    }

    public void setIsFromLeaveReplay(boolean isFromLeaveReplay) {
        this.isFromLeaveReplay = isFromLeaveReplay;
    }
}

