/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.duowan.mobile.entlive.events.IChatEmotionClient_onGetSpeechList_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.chatemotion.data.ChatFastSpeech;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.chatemotion.ChatHotWordsView$$EventBinder;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.ui.widget.labelView.LabelView;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatHotWordsView
implements EventCompat {
    private static final int NORMAL_TYPE = 0;
    private static final int CHANNEL_WORDS_TYPE = 1;
    private static final int UID_TYPE = 2;
    private Context mContext;
    private View mHotWordsView;
    private LabelView mLabelView;
    private View mHotWordsLoading;
    private View mHotWordsLabelviewContainer;
    private IHotWordsMessageListener mHotWordsMessageListener;
    private int mSkipCount;
    private EventBinder mChatHotWordsViewSniperEventBinder;

    public void onEventBind() {
        if (this.mChatHotWordsViewSniperEventBinder == null) {
            this.mChatHotWordsViewSniperEventBinder = new ChatHotWordsView$$EventBinder();
        }
        this.mChatHotWordsViewSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mChatHotWordsViewSniperEventBinder != null) {
            this.mChatHotWordsViewSniperEventBinder.unBindEvent();
        }
    }

    public ChatHotWordsView(Context context, ViewGroup parent, IHotWordsMessageListener listener2, EditText editText) {
        this.mContext = context;
        this.mHotWordsMessageListener = listener2;
        this.mHotWordsView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_hot_words, parent);
        this.mHotWordsLoading = this.mHotWordsView.findViewById(R.id.hot_words_label_loading);
        this.mHotWordsLabelviewContainer = this.mHotWordsView.findViewById(R.id.labelview_chat_hot_words_container);
        this.initView(editText);
        this.onEventBind();
    }

    public void initView(EditText editText) {
        this.mLabelView = (LabelView)this.mHotWordsView.findViewById(R.id.labelview_chat_hot_words);
        this.mLabelView.setOnLabelClickListener(new LabelView.OnLabelClickListener(){

            public void onLabelClick(Label label, int position) {
                if (ChatHotWordsView.this.mHotWordsMessageListener != null) {
                    ChatHotWordsView.this.mHotWordsMessageListener.sendMessageFromHotWords(label.text);
                }
                Property property = new Property();
                property.putString("key1", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid));
                property.putString("key3", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0002", (Serializable)property);
                property.clear();
                property.putString("key1", String.valueOf(label.classId));
                property.putString("key2", String.valueOf(position + ChatHotWordsView.this.getSkipCount() + 1));
                property.putString("key3", URLEncoder.encode(label.text));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51037", "0001", (Serializable)property);
            }
        });
        this.mLabelView.clearAllLabels();
        if (null != this.mContext && this.mContext.getResources().getConfiguration().orientation == 1) {
            this.mLabelView.setLimitRows(4);
        } else {
            this.mLabelView.setLimitRows(3);
        }
    }

    public void setLineMargin(float lineMargin) {
        if (this.mLabelView != null) {
            this.mLabelView.setLineMargin(lineMargin);
        }
    }

    public void setLabelMargin(float labelMargin) {
        if (this.mLabelView != null) {
            this.mLabelView.setLabelMargin(labelMargin);
        }
    }

    public void addLabelView(List<String> stringList, int classId) {
        this.mLabelView.clearAllLabels();
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (int i = 0; i < stringList.size(); ++i) {
            Label label = new Label(stringList.get(i));
            label.classId = classId;
            labelList.add(label);
        }
        this.mLabelView.addAll(labelList);
    }

    public int getVisibility() {
        return this.mHotWordsView.getVisibility();
    }

    public void setVisibility(int visibility) {
        this.mHotWordsView.setVisibility(visibility);
    }

    public void destroyView() {
        this.mContext = null;
        this.mHotWordsMessageListener = null;
        this.onEventUnBind();
    }

    public int getSkipCount() {
        return this.mSkipCount;
    }

    public void setSkipCount(int count) {
        this.mSkipCount = count;
        MLog.debug((Object)"ChatHotWordsView", (String)"set skip count %d", (Object[])new Object[]{count});
    }

    public void showHotWordsListView(ChatFastSpeech speech) {
        List<String> list2 = speech.words;
        int size = list2.size();
        if (!FP.empty((Collection)list2) && size > 0) {
            if (this.mSkipCount > 0 && size >= this.mSkipCount) {
                list2 = list2.subList(this.mSkipCount, size);
            }
            this.mHotWordsLoading.setVisibility(8);
            this.mHotWordsLabelviewContainer.setVisibility(0);
            this.addLabelView(list2, speech.classId);
            MLog.debug((Object)"ChatHotWordsView", (String)"show hotwords list %d", (Object[])new Object[]{list2.size()});
        } else {
            MLog.debug((Object)"ChatHotWordsView", (String)"show loading", (Object[])new Object[0]);
            this.mHotWordsLoading.setVisibility(0);
            this.mHotWordsLabelviewContainer.setVisibility(8);
        }
    }

    @BusEvent
    public void onGetSpeechList(IChatEmotionClient_onGetSpeechList_EventArgs busEventArgs) {
        List speechList = busEventArgs.getSpeechList();
        if (this.mHotWordsView != null && !FP.empty((Collection)speechList)) {
            this.showHotWordsListView((ChatFastSpeech)speechList.get(0));
        }
    }

    public static interface IHotWordsMessageListener {
        public void sendMessageFromHotWords(String var1);
    }
}

