/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.utils;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.Field;

public class DeviceUtils {
    public static final String ABI_X86 = "x86";
    public static final String ABI_MIPS = "mips";
    private static final int EM_ARM = 40;
    private static final int EM_386 = 3;
    private static final int EM_MIPS = 8;
    private static final int EM_AARCH64 = 183;
    private static ARCH sArch = ARCH.Unknown;

    public static String get_CPU_ABI() {
        return Build.CPU_ABI;
    }

    public static String get_CPU_ABI2() {
        try {
            Field field = Build.class.getDeclaredField("CPU_ABI2");
            if (field == null) {
                return null;
            }
            Object fieldValue = field.get(null);
            if (!(fieldValue instanceof String)) {
                return null;
            }
            return (String)fieldValue;
        }
        catch (Exception e) {
            Log.e((String)"DeviceUtils", (String)"Empty Catch on get_CPU_ABI2", (Throwable)e);
            return null;
        }
    }

    public static boolean supportABI(String requestAbi) {
        String abi = DeviceUtils.get_CPU_ABI();
        if (!TextUtils.isEmpty((CharSequence)abi) && abi.equalsIgnoreCase(requestAbi)) {
            return true;
        }
        String abi2 = DeviceUtils.get_CPU_ABI2();
        return !TextUtils.isEmpty((CharSequence)abi2) && abi.equalsIgnoreCase(requestAbi);
    }

    public static boolean supportX86() {
        return DeviceUtils.supportABI(ABI_X86);
    }

    public static boolean supportMips() {
        return DeviceUtils.supportABI(ABI_MIPS);
    }

    public static boolean isMiBox2Device() {
        String manufacturer = Build.MANUFACTURER;
        String productName = Build.PRODUCT;
        return manufacturer.equalsIgnoreCase("Xiaomi") && productName.equalsIgnoreCase("dredd");
    }

    public static boolean isMagicBoxDevice() {
        String manufacturer = Build.MANUFACTURER;
        String productName = Build.PRODUCT;
        return manufacturer.equalsIgnoreCase("MagicBox") && productName.equalsIgnoreCase("MagicBox");
    }

    public static boolean isProblemBoxDevice() {
        return DeviceUtils.isMiBox2Device() || DeviceUtils.isMagicBoxDevice();
    }

    public static enum ARCH {
        Unknown,
        ARM,
        X86,
        MIPS,
        ARM64;

    }
}

