/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import com.yy.mobile.api.HPLog;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/yy/mobile/utils/ScreenUtil;", "", "()V", "mStatusBarHeight", "", "getScreenHeight", "context", "Landroid/content/Context;", "getScreenSize", "Landroid/graphics/Point;", "outSize", "getScreenWidth", "getStatusBarHeight", "getStatusBarHeightInner", "activity", "Landroid/app/Activity;", "toast", "", "text", "", "pluginunionhomepage_release"})
public final class ScreenUtil {
    private static int mStatusBarHeight;
    public static final ScreenUtil INSTANCE;

    public final int getStatusBarHeight(@Nullable Context context) {
        try {
            if (mStatusBarHeight == 0) {
                int result = 0;
                int resourceId = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android");
                if (resourceId > 0) {
                    result = Resources.getSystem().getDimensionPixelSize(resourceId);
                }
                mStatusBarHeight = result;
                return mStatusBarHeight;
            }
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)"ScreenUtil", "\u6302\u4e86 getStatusBarHeight" + e, new Object[0]);
            Context context2 = context;
            if (!(context2 instanceof Activity)) {
                context2 = null;
            }
            mStatusBarHeight = this.getStatusBarHeightInner((Activity)context2);
        }
        return mStatusBarHeight;
    }

    private final int getStatusBarHeightInner(Activity activity) {
        int n;
        if (activity == null) {
            return 0;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            n = activity.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            Rect rect = new Rect();
            Window window = activity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            n = rect.top;
        }
        return n;
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getScreenSize((Context)context, null).x;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getScreenSize((Context)context, null).y;
    }

    public final void toast(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Toast.makeText((Context)context, (CharSequence)text, (int)0).show();
    }

    private final Point getScreenSize(Context context, Point outSize) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Point point = outSize;
        if (point == null) {
            point = new Point();
        }
        Point ret = point;
        Display defaultDisplay = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            Display display = defaultDisplay;
            Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"defaultDisplay");
            ret.x = display.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        return ret;
    }

    private ScreenUtil() {
    }

    static {
        ScreenUtil screenUtil;
        INSTANCE = screenUtil = new ScreenUtil();
    }
}

