/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.hpbanner;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Gallery;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.data.base.HomepageData;
import com.yy.mobile.data.meipai.MPBannerData;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.ui.widget.hpbanner.AdAdapter;
import com.yy.mobile.utils.FP;
import com.yy.mobile.utils.ScreenUtil;

public class HPTopBannerAdapter<T extends HomepageData>
extends AdAdapter<T> {
    private int type;
    private int width;
    private int height;

    public HPTopBannerAdapter(Context context) {
        super(context);
        this.fillSize();
    }

    private void fillSize() {
        this.width = ScreenUtil.INSTANCE.getScreenWidth(this.mContext);
        this.height = this.width * 250 / 750;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = new FrameLayout(this.mContext);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new Gallery.LayoutParams(this.width, -1));
            ImageView imageView = new ImageView(this.mContext);
            ((FrameLayout)convertView).addView((View)imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            viewHolder = new ViewHolder();
            viewHolder.imageview = imageView;
            viewHolder.imageview.setScaleType(ImageView.ScaleType.CENTER_CROP);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        Object info = this.getItem(position);
        if (info != null) {
            String url = "";
            if (info instanceof MPBannerData && !FP.INSTANCE.empty(((MPBannerData)info).getImage())) {
                url = ((MPBannerData)info).getImage();
            }
            this.loadCorpImageWithNineBg(viewHolder.imageview, url, R.drawable.hp_mn_mobile_live_topic_default_bg);
        }
        return convertView;
    }

    public void setFromType(int fromType) {
        this.type = fromType;
    }

    @Override
    public int getCount() {
        if (this.mData.size() <= 1) {
            return this.mData.size();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public T getItem(int position) {
        if (this.mData.size() == 0) {
            return null;
        }
        return (T)((HomepageData)this.mData.get(position % this.mData.size()));
    }

    @SuppressLint(value={"CheckResult"})
    private void loadCorpImageWithNineBg(ImageView imageView, String url, int placeholderNinePngId) {
        if (imageView == null) {
            return;
        }
        Context context = imageView.getContext();
        if (imageView.getContext() instanceof Activity) {
            boolean isDestroy;
            Activity activity = (Activity)context;
            boolean bl = isDestroy = Build.VERSION.SDK_INT >= 17 && activity.isDestroyed();
            if (isDestroy || activity.isFinishing()) {
                HPLog.INSTANCE.error((Object)"HPTopBannerAdapter", "context is error", new Object[0]);
                return;
            }
        }
        Glide.with((View)imageView).load(url).apply(RequestOptions.placeholderOf((int)R.drawable.hp_living_default_bg)).into(imageView);
    }

    class ViewHolder {
        ImageView imageview;

        ViewHolder() {
        }
    }
}

