/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.viewholder;

import android.support.annotation.NonNull;
import com.yy.mobile.data.mainbean.LineDataMultiType;
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolderMapping;
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter;
import com.yy.mobile.plugin.homeapi.ui.multiline.MultiLineFactory;
import com.yy.mobile.ui.viewholder.factory.ViewBinderMappingEx;
import java.util.Collections;
import java.util.List;
import me.drakeet.multitype.Linker;
import me.drakeet.multitype.MultiTypeAdapter;
import me.drakeet.multitype.MultiTypePool;
import me.drakeet.multitype.TypePool;

public class HomeContentAdapter
extends MultiTypeAdapter {
    private static final String TAG = "HomeContentAdapter";
    private IMultiLinePresenter mPresenter;
    private String mPageId;

    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter2, String pageId) {
        this(presenter2, pageId, Collections.emptyList());
    }

    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter2, String pageId, @NonNull List<?> items) {
        this(presenter2, pageId, items, (TypePool)new MultiTypePool());
    }

    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter2, String pageId, @NonNull List<?> items, int initialCapacity) {
        this(presenter2, pageId, items, (TypePool)new MultiTypePool(initialCapacity));
    }

    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter2, String pageId, @NonNull List<?> items, @NonNull TypePool pool) {
        super(items, pool);
        this.mPresenter = presenter2;
        this.mPageId = pageId;
        this.registerHolder();
    }

    public void setItems(@NonNull List<?> items) {
        super.setItems(items);
    }

    private void registerHolder() {
        final MultiLineFactory multiLineFactory = MultiLineFactory.getInstance((BaseViewHolderMapping)new ViewBinderMappingEx(this.mPresenter));
        this.register(LineDataMultiType.class).to(multiLineFactory.getBinders()).withLinker((Linker)new Linker<LineDataMultiType>(){

            public int index(int position, @NonNull LineDataMultiType lineData) {
                int pos = multiLineFactory.getPosition(lineData.getType());
                if (pos < 0) {
                    return multiLineFactory.getPosition(-1);
                }
                return pos;
            }
        });
    }

    public void addItems(@NonNull List items) {
        this.getItems().addAll(items);
    }
}

