/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.utils;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.utils.DensityUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006J0\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/yy/mobile/utils/TextViewUtil;", "", "()V", "getTextRect", "Landroid/graphics/Rect;", "str", "", "size", "", "getTextWidth", "", "setLiveTagFromTagStyle", "", "mContext", "Landroid/content/Context;", "liveTag", "Landroid/widget/TextView;", "tagStyle", "tag", "setLiveTagTextInternal", "backgroundId", "pluginunionhomepage_release"})
public final class TextViewUtil {
    public static final TextViewUtil INSTANCE;

    public final float getTextWidth(@NotNull String str, int size) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Paint paint = new Paint();
        paint.setTextSize((float)size);
        return paint.measureText(str);
    }

    @NotNull
    public final Rect getTextRect(@NotNull String str, int size) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Paint paint = new Paint();
        Rect rect = new Rect();
        paint.setTextSize((float)size);
        paint.getTextBounds(str, 0, str.length(), rect);
        return rect;
    }

    public final void setLiveTagFromTagStyle(@NotNull Context mContext, @Nullable TextView liveTag, int tagStyle, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (liveTag != null) {
            if (TextUtils.isEmpty((CharSequence)tag)) {
                liveTag.setVisibility(8);
                return;
            }
            switch (tagStyle) {
                case 0: {
                    liveTag.setVisibility(8);
                    break;
                }
                default: {
                    this.setLiveTagTextInternal(mContext, liveTag, tagStyle, tag, R.drawable.hp_home_btn_tag);
                    liveTag.setTextColor(mContext.getResources().getColor(R.color.hp_color_white));
                    liveTag.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                }
            }
        }
    }

    private final void setLiveTagTextInternal(Context mContext, TextView liveTag, int tagStyle, String tag, int backgroundId) {
        liveTag.setVisibility(0);
        liveTag.setText((CharSequence)tag);
        liveTag.setBackgroundResource(backgroundId);
        liveTag.setTypeface(Typeface.DEFAULT, 0);
        liveTag.setTextSize(12.0f);
        int compoundDrawablePadding = DensityUtil.dp2px(2.0f);
        if (tagStyle == 4) {
            compoundDrawablePadding = DensityUtil.dp2px(4.0f);
        }
        liveTag.setCompoundDrawablePadding(compoundDrawablePadding);
        int leftPx = (int)mContext.getResources().getDimension(R.dimen.hp_home_living_tag_left);
        int rightPx = (int)mContext.getResources().getDimension(R.dimen.hp_home_living_tag_right);
        liveTag.setPadding(leftPx, 0, rightPx, 0);
        ViewGroup.LayoutParams layoutParams = liveTag.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        }
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)layoutParams;
        lp.setMargins(0, DensityUtil.dp2px(5.0f), 0, 0);
    }

    private TextViewUtil() {
    }

    static {
        TextViewUtil textViewUtil;
        INSTANCE = textViewUtil = new TextViewUtil();
    }
}

