/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.yy.mobile.api.HPLog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/yy/mobile/utils/NetworkUtils;", "", "()V", "TAG", "", "getActiveNetwork", "Landroid/net/NetworkInfo;", "c", "Landroid/content/Context;", "isNetworkAvailable", "", "pluginunionhomepage_release"})
public final class NetworkUtils {
    private static final String TAG = "NetworkUtils";
    public static final NetworkUtils INSTANCE;

    public final boolean isNetworkAvailable(@Nullable Context c) {
        try {
            boolean bl;
            if (c == null) {
                HPLog.INSTANCE.error((Object)TAG, "isNetworkAvailable context is NULL", new Object[0]);
                return false;
            }
            NetworkInfo ni = this.getActiveNetwork(c);
            if (ni != null && ni.isAvailable() && ni.isConnected()) {
                bl = true;
            } else {
                String info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "" : "not") + " available, " + (ni.isConnected() ? "" : "not") + " connected, " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
                HPLog.INSTANCE.error((Object)TAG, "isNetworkAvailable: network info = " + info, new Object[0]);
                bl = false;
            }
            return bl;
        }
        catch (Throwable throwable) {
            HPLog.INSTANCE.error(TAG, throwable);
            return false;
        }
    }

    private final NetworkInfo getActiveNetwork(Context c) {
        try {
            Object object = c.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager cm = (ConnectivityManager)object;
            return cm.getActiveNetworkInfo();
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)TAG, "getActiveNetwork: error = " + e, new Object[0]);
            return null;
        }
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
    }
}

