/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.titlebar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.utils.ScreenUtil;

public class TitleBar
extends RelativeLayout {
    private int mLeftLayout;
    protected View mLeftView;
    private int mRightLayout;
    protected View mRightView;
    private int mCenterLayout;
    protected View mCenterView;
    protected View mCenterViewOnclick;
    private int mBottomLayout;
    protected View mBottomView;
    protected int mBg;
    private Context mContext;
    private LayoutInflater mInflater;
    private String TAG = "TitleBar";
    private boolean considerStatusBar = true;
    private boolean isInsetAdded;
    private View vInset;
    private RelativeLayout.LayoutParams layoutParams;
    private static final int V_INSET_ID = "v_title_inset".hashCode();

    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        try {
            this.init(context, attrs, defStyle);
        }
        catch (Throwable throwable) {
            HPLog.INSTANCE.error((Object)this.TAG, "zy TitleBar error == " + throwable, new Object[0]);
        }
        this.initView();
    }

    @TargetApi(value=19)
    private void initView() {
        this.vInset = new View(this.getContext());
        this.vInset.setId(V_INSET_ID);
        this.layoutParams = new RelativeLayout.LayoutParams(-1, ScreenUtil.INSTANCE.getStatusBarHeight(this.getContext()));
    }

    @TargetApi(value=19)
    private void fitStatusBar() {
        if (!this.isInsetAdded && this.considerStatusBar && this.needHandleStatusBar()) {
            this.isInsetAdded = true;
            this.removeView(this.vInset);
            View contentView = this.findViewById(R.id.v_title_content);
            this.addView(this.vInset, (ViewGroup.LayoutParams)this.layoutParams);
            RelativeLayout.LayoutParams lp1 = (RelativeLayout.LayoutParams)contentView.getLayoutParams();
            lp1.height = this.getLayoutParams().height;
            lp1.addRule(3, V_INSET_ID);
            this.getLayoutParams().height += this.layoutParams.height;
        }
    }

    private boolean needHandleStatusBar() {
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.fitStatusBar();
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mCenterViewOnclick = this.mInflater.inflate(R.layout.hp_layout_title_bar_base, (ViewGroup)this, true).findViewById(R.id.title_center_onclick);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.title_bar_style, defStyle, 0);
        this.mBg = ta.getResourceId(R.styleable.title_bar_style_bg, -1);
        int left = ta.getResourceId(R.styleable.title_bar_style_left, -1);
        int right = ta.getResourceId(R.styleable.title_bar_style_right, -1);
        int center = ta.getResourceId(R.styleable.title_bar_style_center, -1);
        int bottom = ta.getResourceId(R.styleable.title_bar_style_bottom, -1);
        this.considerStatusBar = ta.getBoolean(R.styleable.title_bar_style_consider_status_bar, false);
        this.setLeftLayout(left);
        this.setRightLayout(right);
        this.setCenterLayout(center);
        this.setBottomLayout(bottom);
        if (this.mBg > 0) {
            this.setBackgroundResource(this.mBg);
        }
        ta.recycle();
    }

    public void setConsiderStatusBar(boolean considerStatusBar) {
        this.considerStatusBar = considerStatusBar;
        this.requestLayout();
    }

    public int getBottomLayout() {
        return this.mBottomLayout;
    }

    public void setBottomLayout(int bottomLayout) {
        this.mBottomLayout = bottomLayout;
        if (this.mBottomLayout > 0) {
            this.setBottomView(this.mInflater.inflate(this.mBottomLayout, null, false));
        }
    }

    public void setBottomView(View bottomView) {
        if (bottomView == null) {
            return;
        }
        if (this.mBottomView != null) {
            this.removeView(this.mBottomView);
        }
        this.mBottomView = bottomView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, 1);
        ((ViewGroup)this.findViewById(R.id.title_bottom_line)).addView(this.mBottomView, (ViewGroup.LayoutParams)params);
    }

    public int getLeftLayout() {
        return this.mLeftLayout;
    }

    public void setLeftLayout(int leftLayout) {
        this.mLeftLayout = leftLayout;
        if (this.mLeftLayout > 0) {
            this.setLeftView(this.mInflater.inflate(this.mLeftLayout, null));
        }
    }

    public View getLeftView() {
        return this.mLeftView;
    }

    public void setLeftView(View leftView) {
        if (leftView == null) {
            return;
        }
        if (this.mLeftView != null) {
            this.removeView(this.mLeftView);
        }
        this.mLeftView = leftView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        ((ViewGroup)this.findViewById(R.id.title_left)).addView(this.mLeftView, (ViewGroup.LayoutParams)params);
    }

    public int getRightLayout() {
        return this.mRightLayout;
    }

    public void setRightLayout(int rightLayout) {
        this.mRightLayout = rightLayout;
        if (this.mRightLayout > 0) {
            this.setRightView(this.mInflater.inflate(this.mRightLayout, null));
        }
    }

    public View getRightView() {
        return this.mRightView;
    }

    public void setRightView(View rightView) {
        if (rightView == null) {
            return;
        }
        if (this.mRightView != null) {
            this.removeView(this.mRightView);
        }
        this.mRightView = rightView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        ((ViewGroup)this.findViewById(R.id.title_right)).addView(this.mRightView, (ViewGroup.LayoutParams)params);
    }

    public int getCenterLayout() {
        return this.mCenterLayout;
    }

    public void setCenterLayout(int centerLayout) {
        this.mCenterLayout = centerLayout;
        if (this.mCenterLayout > 0) {
            this.setCenterView(this.mInflater.inflate(this.mCenterLayout, null));
        }
    }

    public View getCenterView() {
        return this.mCenterView;
    }

    public void setCenterView(View centerView) {
        if (centerView == null) {
            return;
        }
        if (this.mCenterView != null) {
            this.removeView(this.mCenterView);
        }
        this.mCenterView = centerView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        ((ViewGroup)this.findViewById(R.id.title_center)).addView(this.mCenterView, (ViewGroup.LayoutParams)params);
    }

    public void setCenterOnClickListener(final View.OnClickListener listener) {
        if (this.mCenterViewOnclick != null) {
            this.mCenterViewOnclick.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                }
            });
        }
    }
}

