/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.titlebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import java.util.ArrayList;

public class AdvancedRadioGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private ArrayList<RadioButton> radioButtons;

    public AdvancedRadioGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public AdvancedRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
        this.radioButtons = new ArrayList();
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof RadioButton) {
            RadioButton button = (RadioButton)child;
            this.radioButtons.add(button);
            if (button.isChecked()) {
                this.mProtectFromCheckedChange = true;
                if (this.mCheckedId != -1) {
                    this.setCheckedStateForView(this.mCheckedId, false);
                }
                this.mProtectFromCheckedChange = false;
                this.setCheckedId(button.getId());
            }
        } else if (child instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)child;
            this.setCheckedView(vg);
        }
        super.addView(child, index, params);
    }

    private void setCheckedView(ViewGroup vg) {
        int len = vg.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (vg.getChildAt(i) instanceof RadioButton) {
                RadioButton button = (RadioButton)vg.getChildAt(i);
                this.radioButtons.add(button);
                if (!button.isChecked()) continue;
                this.mProtectFromCheckedChange = true;
                if (this.mCheckedId != -1) {
                    this.setCheckedStateForView(this.mCheckedId, false);
                }
                this.mProtectFromCheckedChange = false;
                this.setCheckedId(button.getId());
                continue;
            }
            if (!(vg.getChildAt(i) instanceof ViewGroup)) continue;
            ViewGroup childVg = (ViewGroup)vg.getChildAt(i);
            this.setCheckedView(childVg);
        }
    }

    private void setCheckedId(ViewGroup vg) {
        int len = vg.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (vg.getChildAt(i) instanceof RadioButton) {
                RadioButton button = (RadioButton)vg.getChildAt(i);
                int id2 = button.getId();
                if (id2 == -1) {
                    id2 = button.hashCode();
                    button.setId(id2);
                }
                button.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
                continue;
            }
            if (!(vg.getChildAt(i) instanceof ViewGroup)) continue;
            ViewGroup childVg = (ViewGroup)vg.getChildAt(i);
            this.setCheckedId(childVg);
        }
    }

    public RadioButton findRadioButton(ViewGroup group) {
        RadioButton resBtn = null;
        int len = group.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (group.getChildAt(i) instanceof RadioButton) {
                resBtn = (RadioButton)group.getChildAt(i);
                continue;
            }
            if (!(group.getChildAt(i) instanceof ViewGroup)) continue;
            resBtn = this.findRadioButton((ViewGroup)group.getChildAt(i));
            this.findRadioButton((ViewGroup)group.getChildAt(i));
            break;
        }
        return resBtn;
    }

    public int getRadioButtonCount() {
        return this.radioButtons.size();
    }

    public RadioButton getRadioButton(int index) {
        return this.radioButtons.get(index);
    }

    public void check(int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(int id2) {
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == AdvancedRadioGroup.this && child instanceof RadioButton) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = child.hashCode();
                    child.setId(id2);
                }
                ((RadioButton)child).setOnCheckedChangeListener(AdvancedRadioGroup.this.mChildOnCheckedChangeListener);
            } else if (parent == AdvancedRadioGroup.this && child instanceof ViewGroup) {
                AdvancedRadioGroup.this.setCheckedId((ViewGroup)child);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == AdvancedRadioGroup.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeListener(null);
            } else if (parent == AdvancedRadioGroup.this && child instanceof ViewGroup) {
                AdvancedRadioGroup.this.findRadioButton((ViewGroup)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (AdvancedRadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            AdvancedRadioGroup.this.mProtectFromCheckedChange = true;
            if (AdvancedRadioGroup.this.mCheckedId != -1) {
                AdvancedRadioGroup.this.setCheckedStateForView(AdvancedRadioGroup.this.mCheckedId, false);
            }
            AdvancedRadioGroup.this.mProtectFromCheckedChange = false;
            int id2 = buttonView.getId();
            AdvancedRadioGroup.this.setCheckedId(id2);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(AdvancedRadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

