/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.hppager;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.ui.widget.hppager.IPagerPosition;
import com.yy.mobile.ui.widget.hppager.PagerSelectedAdapter;
import com.yy.mobile.utils.FP;
import java.lang.ref.WeakReference;
import java.util.List;

public class SelectedViewPager
extends ViewPager {
    private static final String TAG = "SelectedViewPager";
    private PageChangeListenerWrapper mWrapper;

    public SelectedViewPager(Context context) {
        super(context);
    }

    public SelectedViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setOnClickListener(null);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mWrapper = new PageChangeListenerWrapper(this, listener);
        super.setOnPageChangeListener(this.mWrapper.getWrapperPageListener());
        if (this.getAdapter() instanceof PagerSelectedAdapter) {
            ((PagerSelectedAdapter)this.getAdapter()).setSelectedInitialize(true);
        } else {
            this.mWrapper.getWrapperPageListener().onPageSelected(this.getCurrentItem());
            this.mWrapper.getWrapperPageListener().onPageScrollStateChanged(0);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (Exception ex) {
            HPLog.INSTANCE.warn(TAG, "xuwakao, onTouchEvent SelectedViewPager viewpager error happens, ev = " + ev, new Object[0]);
            return false;
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mWrapper != null) {
            this.mWrapper.getWrapperPageListener().onPageSelected(0);
            this.mWrapper.getWrapperPageListener().onPageScrollStateChanged(0);
        } else if (this.getAdapter() != null && this.getAdapter() instanceof PagerSelectedAdapter) {
            ((PagerSelectedAdapter)this.getAdapter()).setSelectedInitialize(true);
        }
    }

    public void setFirstOnPageSelected() {
        if (this.mWrapper != null) {
            this.mWrapper.getWrapperPageListener().onPageSelected(0);
        }
    }

    private static class PageChangeListenerWrapper {
        private final ViewPager.OnPageChangeListener mPageListener;
        private final WeakReference<SelectedViewPager> mPager;
        private ViewPager.OnPageChangeListener mWrapperPageListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (PageChangeListenerWrapper.this.mPageListener != null) {
                    PageChangeListenerWrapper.this.mPageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageSelected(int position) {
                SelectedViewPager pager;
                if (PageChangeListenerWrapper.this.mPageListener != null) {
                    PageChangeListenerWrapper.this.mPageListener.onPageSelected(position);
                }
                if ((pager = (SelectedViewPager)((Object)PageChangeListenerWrapper.this.mPager.get())) != null && pager.getAdapter() != null && pager.getAdapter() instanceof PagerSelectedAdapter) {
                    Fragment fragment;
                    PagerSelectedAdapter adapter = (PagerSelectedAdapter)pager.getAdapter();
                    List<Fragment> fragmentList = adapter.excludePosFragment(position);
                    if (!FP.INSTANCE.empty(fragmentList)) {
                        for (Fragment item : fragmentList) {
                            if (item == null || !(item instanceof IPagerPosition)) continue;
                            ((IPagerPosition)item).onUnSelected(adapter.indexOfFragment(item));
                        }
                    }
                    if ((fragment = adapter.getPosFragment(position)) != null && fragment instanceof IPagerPosition) {
                        ((IPagerPosition)fragment).onSelected(position);
                    }
                } else {
                    HPLog.INSTANCE.warn(SelectedViewPager.TAG, "xuwakao, pager = " + (Object)((Object)pager), new Object[0]);
                }
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0) {
                    SelectedViewPager pager = (SelectedViewPager)((Object)PageChangeListenerWrapper.this.mPager.get());
                    if (pager != null && pager.getAdapter() != null && pager.getAdapter() instanceof PagerSelectedAdapter) {
                        int position;
                        PagerSelectedAdapter adapter = (PagerSelectedAdapter)pager.getAdapter();
                        Fragment fragment = adapter.getPosFragment(position = pager.getCurrentItem());
                        if (fragment != null && fragment instanceof IPagerPosition) {
                            ((IPagerPosition)fragment).onPageScrollComplete(position);
                        }
                    } else {
                        HPLog.INSTANCE.warn(SelectedViewPager.TAG, "xuwakao, pager = " + (Object)((Object)pager), new Object[0]);
                    }
                }
                if (PageChangeListenerWrapper.this.mPageListener != null) {
                    PageChangeListenerWrapper.this.mPageListener.onPageScrollStateChanged(state);
                }
            }
        };

        PageChangeListenerWrapper(SelectedViewPager viewPager, ViewPager.OnPageChangeListener listener) {
            this.mPager = new WeakReference<SelectedViewPager>(viewPager);
            this.mPageListener = listener;
        }

        public ViewPager.OnPageChangeListener getWrapperPageListener() {
            return this.mWrapperPageListener;
        }
    }
}

