/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.hppager;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.ui.widget.hppager.IPagerPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class PagerSelectedAdapter
extends PagerAdapter {
    private static final String TAG = "PagerSelectedAdapter";
    private static final boolean DEBUG = false;
    private final FragmentManager mFragmentManager;
    private FragmentTransaction mCurTransaction = null;
    private ArrayList<Fragment.SavedState> mSavedState = new ArrayList();
    private ArrayList<Fragment> mFragments = new ArrayList();
    private Fragment mCurrentPrimaryItem = null;
    private boolean mSelectedInitialize;

    public PagerSelectedAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
    }

    public Fragment getPosFragment(int position) {
        if (position < this.mFragments.size()) {
            return this.mFragments.get(position);
        }
        return null;
    }

    public List<Fragment> excludePosFragment(int position) {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        Fragment fragment = this.getPosFragment(position);
        if (fragment != null) {
            fragments.addAll(this.mFragments);
            fragments.remove(fragment);
            return fragments;
        }
        return null;
    }

    public int indexOfFragment(Fragment fragment) {
        if (fragment == null) {
            return -1;
        }
        if (this.mFragments.contains(fragment)) {
            return this.mFragments.indexOf(fragment);
        }
        return -1;
    }

    public abstract Fragment getItem(int var1);

    public void startUpdate(ViewGroup container) {
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment.SavedState fss;
        Fragment f;
        if (this.mFragments.size() > position && (f = this.mFragments.get(position)) != null) {
            return f;
        }
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        Fragment fragment = this.getItem(position);
        if (this.mSavedState.size() > position && (fss = this.mSavedState.get(position)) != null) {
            fragment.setInitialSavedState(fss);
        }
        while (this.mFragments.size() <= position) {
            this.mFragments.add(null);
        }
        if (fragment instanceof IPagerPosition) {
            ((IPagerPosition)fragment).setPosition(position);
        }
        fragment.setMenuVisibility(false);
        fragment.setUserVisibleHint(false);
        if (fragment instanceof Fragment) {
            this.mFragments.set(position, fragment);
        }
        this.mCurTransaction.add(container.getId(), fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        while (this.mSavedState.size() <= position) {
            this.mSavedState.add(null);
        }
        this.mSavedState.set(position, this.mFragmentManager.saveFragmentInstanceState(fragment));
        this.mFragments.set(position, null);
        this.mCurTransaction.remove(fragment);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.mCurrentPrimaryItem) {
            if (this.mCurrentPrimaryItem != null) {
                this.mCurrentPrimaryItem.setMenuVisibility(false);
                this.mCurrentPrimaryItem.setUserVisibleHint(false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                fragment.setUserVisibleHint(true);
            }
            this.mCurrentPrimaryItem = fragment;
        }
    }

    public void finishUpdate(ViewGroup container) {
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
            if (this.mCurrentPrimaryItem != null && this.mCurrentPrimaryItem instanceof IPagerPosition && this.mSelectedInitialize) {
                ((IPagerPosition)this.mCurrentPrimaryItem).onSelected(this.mFragments.indexOf(this.mCurrentPrimaryItem));
                ((IPagerPosition)this.mCurrentPrimaryItem).onPageScrollComplete(0);
                this.mSelectedInitialize = false;
            }
        }
    }

    public void setSelectedInitialize(boolean selectedInitialize) {
        this.mSelectedInitialize = selectedInitialize;
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    public Parcelable saveState() {
        Bundle state = null;
        if (this.mSavedState.size() > 0) {
            state = new Bundle();
            Fragment.SavedState[] fss = new Fragment.SavedState[this.mSavedState.size()];
            this.mSavedState.toArray(fss);
            state.putParcelableArray("states", (Parcelable[])fss);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment f = this.mFragments.get(i);
            if (f == null) continue;
            if (state == null) {
                state = new Bundle();
            }
            String key = "f" + i;
            this.mFragmentManager.putFragment(state, key, f);
        }
        return state;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state != null) {
            Bundle bundle = (Bundle)state;
            Parcelable[] fss = bundle.getParcelableArray("states");
            this.mSavedState.clear();
            this.mFragments.clear();
            if (fss != null) {
                for (int i = 0; i < fss.length; ++i) {
                    this.mSavedState.add((Fragment.SavedState)fss[i]);
                }
            }
            if (this.mFragmentManager.getFragments().size() == 0) {
                HPLog.INSTANCE.info(TAG, "restoreState: mFragmentManager.getFragments().size() == 0", new Object[0]);
                return;
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("f")) continue;
                int index = Integer.parseInt(key.substring(1));
                Fragment f = this.mFragmentManager.getFragment(bundle, key);
                if (f instanceof IPagerPosition && f instanceof Fragment) {
                    while (this.mFragments.size() <= index) {
                        this.mFragments.add(null);
                    }
                    f.setMenuVisibility(false);
                    this.mFragments.set(index, f);
                    continue;
                }
                Log.w((String)TAG, (String)("Bad fragment at key " + key));
            }
        }
    }
}

