/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.hpbanner;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.data.meipai.MPBannerData;
import com.yy.mobile.data.nav.LiveNavInfo;
import com.yy.mobile.data.nav.SubLiveNavItem;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.ui.widget.hpbanner.HPTopBannerGallery;
import com.yy.mobile.utils.FP;
import java.util.ArrayList;
import java.util.List;

public class TopBanner
extends RelativeLayout {
    private static final int THREE_SECOND_DURATION = 5000;
    private static final String TAG = "TopBanner";
    HPTopBannerGallery mGallery;
    private OnItemSelectedListener mOnItemSelectedListener;
    TextView txtDesc;
    RadioGroup mRadios;
    int type;
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubNavInfo;
    private String from;
    private int bannerId;
    public boolean inWindow = false;
    private List<MPBannerData> mData = new ArrayList<MPBannerData>();
    private AdapterView.OnItemSelectedListener mListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
            if (TopBanner.this.mOnItemSelectedListener != null) {
                TopBanner.this.mOnItemSelectedListener.onItemSelected(parent, view, position);
            }
            if (!FP.INSTANCE.empty(TopBanner.this.mGallery.getData())) {
                MPBannerData info = (MPBannerData)TopBanner.this.mData.get(position % TopBanner.this.mData.size());
                TopBanner.this.mRadios.check(TopBanner.this.mRadios.getChildAt(position % TopBanner.this.mGallery.getData().size()).getId());
                int pos = position % TopBanner.this.mData.size() + 1;
                if (TopBanner.this.type == 1006) {
                    TopBanner.this.txtDesc.setText((CharSequence)"");
                }
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    };

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    public TopBanner(Context context) {
        super(context);
        this.init();
    }

    public TopBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TopBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.hp_item_living_banner, (ViewGroup)this, true);
        this.mGallery = (HPTopBannerGallery)this.findViewById(R.id.banner_gallery);
        this.mRadios = (RadioGroup)this.findViewById(R.id.living_banner_radiogroup);
        this.txtDesc = (TextView)this.findViewById(R.id.banner_enter_live_btn_left);
        this.mGallery.setFlipInterval(5000);
        this.mGallery.setOnItemSelectedListener(this.mListener);
    }

    public void setData(List<MPBannerData> data, int fromType) {
        if (this.mData.equals(data) || data == null) {
            return;
        }
        this.mData.clear();
        this.mData.addAll(data);
        if (this.mRadios != null) {
            if (this.mData.size() <= 1) {
                this.mRadios.setVisibility(8);
            } else {
                this.mRadios.setVisibility(0);
            }
        }
        this.mGallery.setData(data, fromType);
        this.type = fromType;
        this.addRadios(data);
        this.mRadios.check(this.mRadios.getChildAt(0).getId());
    }

    private void addRadios(List<MPBannerData> data) {
        this.mRadios.removeAllViews();
        for (int i = 0; i < data.size(); ++i) {
            RadioButton radioButton = new RadioButton(this.getContext());
            radioButton.setId(4660 + i);
            radioButton.setButtonDrawable(this.getContext().getResources().getDrawable(R.drawable.hp_top_banner_selector));
            this.mRadios.addView((View)radioButton, (ViewGroup.LayoutParams)this.generateDefaultParam());
        }
        this.mRadios.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                for (int i = 0; i < TopBanner.this.mData.size(); ++i) {
                    RadioButton radioButton = (RadioButton)group.getChildAt(i);
                }
            }
        });
    }

    private RadioGroup.LayoutParams generateDefaultParam() {
        int buttonW = (int)this.getResources().getDimension(R.dimen.hp_home_top_banner_dot);
        int w = buttonW + 12;
        int h = buttonW;
        return new RadioGroup.LayoutParams(w, h);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mGallery.setOnItemClickListener(listener);
    }

    public void startAutoScroll() {
        if (this.mData.size() > 1) {
            this.mGallery.startAutoScroll();
        }
    }

    public void endAutoScroll() {
        this.mGallery.endAutoScroll();
    }

    public void setBannerId(int id2) {
        this.bannerId = id2;
    }

    public void setNav(LiveNavInfo navInfo, SubLiveNavItem subNavInfo, String from) {
        this.mNavInfo = navInfo;
        this.mSubNavInfo = subNavInfo;
        this.from = from;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3);
    }
}

