/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.hpbanner;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Gallery;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.utils.DispatchHandler;
import java.lang.ref.WeakReference;

public class AdGallery
extends Gallery
implements View.OnTouchListener {
    private static final String TAG = "AdGallery";
    private static final int DEFAULT_INTERVAL = 10000;
    private static final int FLIP_MSG = 1;
    private final Handler mHandler = new GalleryHandler(this);
    private int mFlipInterval = 10000;
    private boolean mAutoStart = false;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mVisible = false;
    private boolean mUserPresent = true;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action2 = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action2)) {
                AdGallery.this.mUserPresent = false;
                AdGallery.this.updateRunning();
            } else if ("android.intent.action.USER_PRESENT".equals(action2)) {
                AdGallery.this.mUserPresent = true;
                AdGallery.this.updateRunning(false);
            }
        }
    };
    private boolean mHasRegisterReceiver = false;

    public AdGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public AdGallery(Context context) {
        super(context);
        this.init();
    }

    public AdGallery(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void init() {
        this.setOnTouchListener(this);
        this.setSoundEffectsEnabled(true);
        this.setFocusableInTouchMode(true);
        this.setSpacing(-1);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        int kEvent = this.isScrollingLeft(e1, e2) ? 21 : 22;
        this.onKeyDown(kEvent, null);
        return true;
    }

    private boolean isScrollingLeft(MotionEvent e1, MotionEvent e2) {
        return e2.getX() > e1.getX() + 50.0f;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return super.onScroll(e1, e2, distanceX, distanceY);
    }

    public void startAutoScroll() {
        this.startFlipping();
    }

    public void endAutoScroll() {
        this.stopFlipping();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (1 == event.getAction() || 3 == event.getAction()) {
            this.startFlipping();
        } else {
            this.stopFlipping();
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerReceiver();
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiver(this.mReceiver, filter, null, this.mHandler);
        this.mHasRegisterReceiver = true;
        HPLog.INSTANCE.info(TAG, "[onAttachedToWindow] mHasRegisterReceiver = " + this.mHasRegisterReceiver, new Object[0]);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.unregisterReceiver();
        this.updateRunning();
    }

    private void unregisterReceiver() {
        HPLog.INSTANCE.info(TAG, "[onAttachedToWindow] mHasRegisterReceiver = " + this.mHasRegisterReceiver, new Object[0]);
        if (this.mHasRegisterReceiver) {
            HPLog.INSTANCE.info(TAG, "[onAttachedToWindow] unregisterReceiver", new Object[0]);
            try {
                this.getContext().unregisterReceiver(this.mReceiver);
            }
            catch (Exception e) {
                HPLog.INSTANCE.error((Object)TAG, "unregisterReceiver exception ", e, new Object[0]);
            }
            this.mHasRegisterReceiver = false;
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning(false);
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }

    private void updateRunning() {
        this.updateRunning(true);
    }

    private void updateRunning(boolean flipNow) {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted && this.mUserPresent;
        if (running != this.mRunning) {
            if (running) {
                this.setSelection(this.getSelectedItemPosition(), flipNow);
                Message msg = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(msg, (long)this.mFlipInterval);
            } else {
                this.mHandler.removeMessages(1);
            }
            this.mRunning = running;
        }
        HPLog.INSTANCE.debug(TAG, "updateRunning() mVisible=" + this.mVisible + ", mStarted=" + this.mStarted + ", mUserPresent=" + this.mUserPresent + ", mRunning=" + this.mRunning, new Object[0]);
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart = autoStart;
    }

    public void setFlipInterval(int flipInterval) {
        this.mFlipInterval = flipInterval;
    }

    private static class GalleryHandler
    extends DispatchHandler {
        WeakReference<AdGallery> mGallery;

        GalleryHandler(AdGallery gallery) {
            this.mGallery = new WeakReference<AdGallery>(gallery);
        }

        public void handleMessage(Message msg) {
            AdGallery gallery = (AdGallery)((Object)this.mGallery.get());
            if (gallery == null) {
                return;
            }
            if (msg.what == 1 && gallery.mRunning) {
                if (gallery.getSelectedItemPosition() >= gallery.getCount() - 1) {
                    gallery.setSelection(0, true);
                    gallery.onKeyDown(21, null);
                } else {
                    gallery.onKeyDown(22, null);
                }
                msg = this.obtainMessage(1);
                this.sendMessageDelayed(msg, gallery.mFlipInterval);
            }
        }
    }
}

