/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;

public class RippleView
extends RelativeLayout {
    private static final String TAG = "RippleView";
    int mWidth;
    int mHeight;
    double mRadiusMax;
    float mRadius = 0.0f;
    Paint mPaint;
    int left;
    int right;
    int top;
    int bottom;
    int cx;
    int cy;
    int mBackgoundColor = 0xFFFFFF;

    public RippleView(Context context) {
        super(context);
        this.init(context, null);
    }

    public RippleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RippleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setWillNotDraw(false);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RippleView);
        this.mBackgoundColor = ta.getColor(R.styleable.RippleView_rvBackgroundColor, this.mBackgoundColor);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mBackgoundColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mRadius = 0.0f;
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.mRadiusMax = Math.sqrt(Math.pow(this.mWidth / 2, 2.0) + Math.pow(this.mHeight / 2, 2.0));
        HPLog.INSTANCE.debug(TAG, "[onMeasure] mWidth = " + this.mWidth + ", mHeight = " + this.mHeight + ", mRadiusMax = " + this.mRadiusMax, new Object[0]);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.left = l;
        this.right = r;
        this.top = t;
        this.bottom = b;
        this.cx = (l + r) / 2;
        this.cy = (t + b) / 2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle((float)this.cx, (float)this.cy, this.mRadius, this.mPaint);
        if ((double)this.mRadius < this.mRadiusMax) {
            this.mRadius += 30.0f;
            this.postInvalidateDelayed(15L);
        } else {
            this.mRadius = 0.0f;
        }
        HPLog.INSTANCE.debug(TAG, "[onDraw] cx = " + this.cx + ", cy = " + this.cy + ", mRadius = " + this.mRadius + ", mPaint +" + this.mPaint, new Object[0]);
    }
}

