/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.yy.mobile.plugin.pluginunionhomepage.R;

@SuppressLint(value={"AppCompatCustomView"})
public class PointImageView
extends ImageView {
    private boolean showPoint = false;
    private Paint mPaint;
    private int radius = 0;
    private int pointCenterX;
    private int pointCenterY;

    public PointImageView(Context context) {
        this(context, null);
        this.init(context);
    }

    public PointImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.pointCenterX = this.getMeasuredWidth() - this.radius - this.getPaddingRight();
        this.pointCenterY = this.radius + this.getPaddingTop();
    }

    private void init(Context context) {
        this.radius = context.getResources().getDimensionPixelSize(R.dimen.hp_common_point_radius);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showPoint) {
            if (null == this.mPaint) {
                this.mPaint = new Paint();
                this.mPaint.setColor(-383424);
                this.mPaint.setAntiAlias(true);
            }
            canvas.drawCircle((float)this.pointCenterX, (float)this.pointCenterY, (float)this.radius, this.mPaint);
        }
    }

    public void showPoint(boolean showPoint) {
        this.showPoint = showPoint;
        this.invalidate();
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.invalidate();
    }
}

