/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.viewholder;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.data.main.SubNavInfoData;
import com.yy.mobile.data.nav.LiveNavInfo;
import com.yy.mobile.data.nav.SubLiveNavItem;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.statistic.HiidoReportHelper;
import com.yy.mobile.ui.subnav.SubNavActivity;
import java.util.ArrayList;
import java.util.List;

public class TagRecyclerViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "TagRecyclerViewAdapter";
    private List<SubNavInfoData> mData = new ArrayList<SubNavInfoData>();
    private LiveNavInfo mNavInfo;
    private Context mContext;
    private String from;

    public TagRecyclerViewAdapter(Context mContext) {
        this.mContext = mContext;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hp_item_living_tag, null);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, final int position) {
        if (position >= this.mData.size()) {
            return;
        }
        final SubNavInfoData item = this.mData.get(position);
        try {
            holder.mTitle.setTextColor(Color.parseColor((String)item.getColor()));
        }
        catch (Exception e) {
            HPLog.INSTANCE.info(TAG, "onBindViewHolder ", e);
            holder.mTitle.setTextColor(Color.parseColor((String)"#333333"));
        }
        holder.mHotmageView.setVisibility(8);
        String key = "hotspot_pyf_" + item.getId();
        holder.mWrapLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TagRecyclerViewAdapter.this.notifyItemChanged(position);
                TagRecyclerViewAdapter.toLivingMorePageFrom(holder.mHotmageView.getContext(), item.getTitle(), TagRecyclerViewAdapter.this.mNavInfo, item);
                HiidoReportHelper.INSTANCE.sendSubItemClick(HiidoReportHelper.INSTANCE.getPageId(((TagRecyclerViewAdapter)TagRecyclerViewAdapter.this).mNavInfo.biz, item.getAction()));
            }
        });
        holder.mTitle.setText((CharSequence)item.getTitle());
    }

    public static void toLivingMorePageFrom(Context context, String name, LiveNavInfo info, SubNavInfoData subNavInfo) {
        Intent intent = new Intent(context, SubNavActivity.class);
        intent.putExtra("live_tab_name", name);
        intent.putExtra("live_nav_info", (Parcelable)info);
        SubLiveNavItem navItem = new SubLiveNavItem(info.serv, subNavInfo.getAction());
        intent.putExtra("live_sub_nav_info", (Parcelable)navItem);
        intent.putExtra("fragment_type", 1);
        context.startActivity(intent);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void setData(List<SubNavInfoData> datas) {
        this.mData.clear();
        this.mData.addAll(datas);
        this.notifyDataSetChanged();
    }

    public void setNavInfo(LiveNavInfo info, String from) {
        this.mNavInfo = info;
        this.from = from;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView mHotmageView;
        public TextView mTitle;
        public View mWrapLayout;

        public ViewHolder(View v) {
            super(v);
            this.mTitle = (TextView)v.findViewById(R.id.txt_title);
            this.mHotmageView = (ImageView)v.findViewById(R.id.img_tips);
            this.mWrapLayout = v.findViewById(R.id.tag_Wrap_layout);
        }
    }
}

