/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.logs;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.yy.mobile.api.HPLog;
import com.yy.mobile.logs.BasicConfig;
import com.yy.mobile.utils.ContextHolder;
import com.yy.mobile.utils.FP;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010\u0015\u001a\u00020\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u001dR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/yy/mobile/logs/BasicConfig;", "", "()V", "mConfigDir", "Ljava/io/File;", "mLogDir", "mPackageName", "", "getMPackageName", "()Ljava/lang/String;", "mRoot", "mSdkLogDir", "yyLogsDir", "yyMobileDir", "yySdkLogsDir", "getCacheDir", "context", "Landroid/content/Context;", "uniqueName", "getExternalCacheDir", "getLogDir", "getLogDirPath", "getSDKLogDir", "getSDKLogDirPath", "hasExternalStoragePermission", "", "isExternalStorageAvailable", "isExternalStorageRemovable", "setConfigDir", "", "dir", "setLogDir", "setRoot", "dirName", "setSDKLogDir", "Companion", "pluginunionhomepage_release"})
public final class BasicConfig {
    private final String yyMobileDir = "tieyy";
    private final String yyLogsDir = "logs";
    private final String yySdkLogsDir = "sdklog";
    private File mRoot;
    private File mConfigDir;
    private File mLogDir;
    private File mSdkLogDir;
    @NotNull
    private final String mPackageName = "com.unionyy";
    @NotNull
    public static final String TAG = "BasicConfig";
    @NotNull
    private static final Lazy mInstance$delegate;
    public static final Companion Companion;

    @NotNull
    public final String getMPackageName() {
        return this.mPackageName;
    }

    @NotNull
    public final File getCacheDir(@NotNull Context context, @NotNull String uniqueName) {
        String cachePath;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uniqueName, (String)"uniqueName");
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context) && (this.isExternalStorageAvailable() || !this.isExternalStorageRemovable())) {
            String string2 = this.getExternalCacheDir().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getExternalCacheDir().path");
            cachePath = string2;
        } else {
            File file = context.getCacheDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
            String string3 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.cacheDir.path");
            cachePath = string3;
        }
        return new File(cachePath + File.separator + uniqueName);
    }

    public final void setRoot(@NotNull String dirName) {
        File f;
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        Context context = ContextHolder.Companion.getInstance().getApplicationContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        if (!(f = this.getCacheDir(context, this.yyMobileDir)).exists()) {
            f.mkdirs();
        }
        this.mRoot = f;
    }

    public final void setConfigDir(@NotNull String dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        try {
            Context context = ContextHolder.Companion.getInstance().getApplicationContext();
            if (context == null) {
                Intrinsics.throwNpe();
            }
            File file = this.mConfigDir = this.getCacheDir(context, dir);
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (!file.exists()) {
                File file2 = this.mConfigDir;
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!file2.mkdirs()) {
                    HPLog.INSTANCE.error((Object)TAG, "Can't create config dir " + this.mConfigDir, new Object[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            HPLog.INSTANCE.error((Object)TAG, "Set config dir error", e, new Object[0]);
        }
    }

    public final void setLogDir() {
        try {
            File cacheDirectory;
            if (this.mLogDir != null) {
                File file = this.mLogDir;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.exists()) {
                    StringBuilder stringBuilder = new StringBuilder().append("log dir ");
                    File file2 = this.mLogDir;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    HPLog.INSTANCE.info(TAG, stringBuilder.append(file2.getAbsolutePath()).toString(), new Object[0]);
                    return;
                }
            }
            Context context = ContextHolder.Companion.getInstance().getApplicationContext();
            if (context == null) {
                Intrinsics.throwNpe();
            }
            if (!(cacheDirectory = this.getCacheDir(context, this.yyMobileDir)).exists()) {
                cacheDirectory.mkdirs();
            }
            if (cacheDirectory.exists()) {
                File file = this.mLogDir = new File(cacheDirectory.getAbsolutePath() + File.separator + this.yyLogsDir);
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (!file.exists()) {
                    File file3 = this.mLogDir;
                    if (file3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!file3.mkdirs()) {
                        HPLog.INSTANCE.error((Object)TAG, "Can't create log dir ", new Object[0]);
                    }
                }
            }
            File file = this.mLogDir;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (file.exists()) {
                File file4 = this.mLogDir;
                if (file4 == null) {
                    Intrinsics.throwNpe();
                }
                if (!file4.canWrite()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Context context2 = ContextHolder.Companion.getInstance().getApplicationContext();
                    if (context2 == null) {
                        Intrinsics.throwNpe();
                    }
                    File file5 = context2.getCacheDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"ContextHolder.instance.a\u2026icationContext!!.cacheDir");
                    cacheDirectory = new File(stringBuilder.append(file5.getPath()).append(File.separator).append(this.yyMobileDir).toString());
                    if (!cacheDirectory.exists()) {
                        cacheDirectory.mkdirs();
                    }
                    if (cacheDirectory.exists()) {
                        File file6 = this.mLogDir = new File(cacheDirectory.getAbsolutePath() + File.separator + this.yyLogsDir);
                        if (file6 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!file6.exists()) {
                            File file7 = this.mLogDir;
                            if (file7 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!file7.mkdirs()) {
                                HPLog.INSTANCE.error((Object)TAG, "Can't create log dir ", new Object[0]);
                            }
                        }
                    }
                }
            }
            HPLog.INSTANCE.info(TAG, "create mLogDir dir " + this.mLogDir, new Object[0]);
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)TAG, "Set log dir error", e, new Object[0]);
        }
    }

    private final boolean isExternalStorageRemovable() {
        return Build.VERSION.SDK_INT >= 9 ? Environment.isExternalStorageRemovable() : true;
    }

    private final boolean isExternalStorageAvailable() {
        return false;
    }

    private final File getExternalCacheDir() {
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
        return new File(file.getPath());
    }

    private final boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return perm == 0;
    }

    @NotNull
    public final String getLogDirPath() {
        String string2;
        File logDir = this.getLogDir();
        if (logDir == null || FP.INSTANCE.empty(logDir.getAbsolutePath())) {
            string2 = "/storage/emulated/0/" + this.yyMobileDir + '/' + this.yyLogsDir;
        } else {
            String string3 = logDir.getAbsolutePath();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"logDir.absolutePath");
        }
        return string2;
    }

    private final File getLogDir() {
        try {
            if (this.mLogDir == null) {
                this.setLogDir();
            }
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)TAG, "getLogDir log dir error", e, new Object[0]);
        }
        return this.mLogDir;
    }

    @NotNull
    public final String getSDKLogDirPath() {
        String string2;
        File sdkLogDir = this.getSDKLogDir();
        if (sdkLogDir == null || FP.INSTANCE.empty(sdkLogDir.getAbsolutePath())) {
            string2 = "/storage/emulated/0/" + this.yyMobileDir + '/' + this.yyLogsDir + '/' + this.yySdkLogsDir;
        } else {
            String string3 = sdkLogDir.getAbsolutePath();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sdkLogDir.absolutePath");
        }
        return string2;
    }

    private final File getSDKLogDir() {
        try {
            if (this.mSdkLogDir == null) {
                this.setSDKLogDir();
            }
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)TAG, "getLogDir log dir error", e, new Object[0]);
        }
        return this.mSdkLogDir;
    }

    public final void setSDKLogDir() {
        try {
            if (this.mSdkLogDir != null) {
                File file = this.mSdkLogDir;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.exists()) {
                    StringBuilder stringBuilder = new StringBuilder().append("mSdkLogDir dir ");
                    File file2 = this.mSdkLogDir;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    HPLog.INSTANCE.info(TAG, stringBuilder.append(file2.getAbsolutePath()).toString(), new Object[0]);
                    return;
                }
            }
            File logDirFile = this.getLogDir();
            File file = this.mSdkLogDir = new File(String.valueOf(logDirFile) + File.separator + this.yySdkLogsDir);
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (!file.exists()) {
                File file3 = this.mSdkLogDir;
                if (file3 == null) {
                    Intrinsics.throwNpe();
                }
                if (!file3.mkdirs()) {
                    HPLog.INSTANCE.error((Object)TAG, "Can't create log dir ", new Object[0]);
                }
            }
            HPLog.INSTANCE.info(TAG, "create mSdkLogDir dir " + this.mSdkLogDir, new Object[0]);
        }
        catch (Throwable e) {
            HPLog.INSTANCE.error((Object)TAG, "Set log dir error", e, new Object[0]);
        }
    }

    private BasicConfig() {
    }

    static {
        Companion = new Companion(null);
        mInstance$delegate = LazyKt.lazy((Function0)Companion.mInstance.2.INSTANCE);
    }

    public /* synthetic */ BasicConfig(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/yy/mobile/logs/BasicConfig$Companion;", "", "()V", "TAG", "", "mInstance", "Lcom/yy/mobile/logs/BasicConfig;", "getMInstance", "()Lcom/yy/mobile/logs/BasicConfig;", "mInstance$delegate", "Lkotlin/Lazy;", "pluginunionhomepage_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "mInstance", "getMInstance()Lcom/yy/mobile/logs/BasicConfig;"))};
        }

        @NotNull
        public final BasicConfig getMInstance() {
            Lazy lazy = mInstance$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (BasicConfig)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

