package com.yy.mobile.miyyapi

import android.app.Activity
import android.app.Application
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.util.Log
import com.yy.android.small.pluginbase.IPluginEntryPoint
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.replugin.ApiBridge
import com.yy.mobile.unionsdk.FinishListener
import com.yy.mobile.unionsdk.UnionYYSdk
import com.yy.mobile.util.DontProguardClass
import com.yy.mobile.util.DontProguardMethod
import com.yy.mobile.util.log.MLog
import java.lang.reflect.Proxy

/**
 * Created by wangfeihang on 2019-06-19.
 */
@DontProguardClass
object MPYYSDK : UnionYYSdk() {

    private const val TAG = "MPYYSDK"

    /**
     * 美拍获取我方实现的方法。
     * 调用该方法后，如果yy的sdk还没有被初始化，会先进行sdk的初始化，然后再执行接口内的业务逻辑
     * [actionCls] 双方定义的接口类的class
     * [application] 美拍application，用来进行sdk的初始化
     * [context] 美拍传进来的当前context，用来show sdk加载时的loading弹窗
     */
    fun <Action : Any> obtainAction(
        actionCls: Class<Action>,
        application: Application,
        context: Context
    ): Action? {
        if (isInstalling.get()) {
            Log.e(TAG, "sdk is isInstalling")
            return null
        }

        val invocationHandler = ApiInvocationHandler(
            realObj = { ApiBridge.getApi(actionCls) },
            beforeInvoke = { _, _ ->
                val loadingDialog = showSDKLoadingDialog(context)

                val initSuccess = initYYSdkSuc(application, object : FinishListener {
                    override fun onFinish() {
                        loadingDialog?.dismiss()
                        MLog.info(TAG, "dialog dismiss")
                    }
                })

                if (initSuccess) {
                    LoginUtil.synchronizeUnionLoginState()
                }

                !initSuccess
            }
        )
        return Proxy.newProxyInstance(
            invocationHandler.javaClass.classLoader,
            arrayOf(actionCls),
            invocationHandler
        ) as Action
    }

    @JvmStatic
    @JvmOverloads
    fun <Action : Any> obtainActionByCallBack(
        actionCls: Class<Action>,
        application: Application,
        actionCallback: ActionCallback<Action>,
        context: Context? = null
    ) {
        initYYSdkSuc(application, object : FinishListener {
            override fun onFinish() {
                MLog.info(TAG, "after async init finish")
//                if (ContextHolder.instance.applicationContext == null) {
//                    ContextHolder.instance.init(application)
//                }
                LoginUtil.synchronizeUnionLoginState()
                actionCallback.notifyActionInstance(ApiBridge.getApi(actionCls))
            }
        })
    }

    private fun showSDKLoadingDialog(context: Context): Dialog? {
        if (context is Activity && !context.isFinishing) {
            val progressDialog = ProgressDialog(context).apply {
                //this.setMessage("正在加载中...")
                this.setCancelable(false)
            }
            progressDialog.show()
            MLog.info(TAG, "dialog showing")
            return progressDialog
        }
        return null
    }

    /**
     * This method will be invoked by inflection. (Magnet)
     */
    @JvmStatic
    @JvmOverloads
    @DontProguardMethod
    fun initYYSdk(application: Application, finishListener: FinishListener? = null) {
        val time = System.currentTimeMillis()
        Log.i("MPYYSDK", "initYYSdk start - $time")
        var listener = object : FinishListener {
            override fun onFinish() {
                Log.i(TAG, "initYYSdk, onFinish - $time")
                finishListener?.onFinish()
            }
        }
        initYYSdkSuc(application, listener)
        Log.i("MPYYSDK", "initYYSdk end - $time")
    }

    override fun dealWithSvcState(pluginMap: Map<String, Pair<Set<String>?, IPluginEntryPoint>>) {
        finish(pluginMap.keys.toList())
    }

    override fun init(application: Application, isDebugPackage: Boolean) {
        super.init(application, isDebugPackage)
        //初始化美拍列表页相关
        MPYYExtraSDK.setHomepageListener(application)
    }

    interface ActionCallback<Action> {
        fun notifyActionInstance(action: Action?)
    }
}

