package com.yy.mobile.miyyapi.testapi.impl

import com.unionyy.mobile.magnet.core.login.AuthStateListener
import com.unionyy.mobile.magnet.core.repo.LoginException
import com.unionyy.mobile.magnet.core.repo.LoginSuccessEvent
import com.unionyy.mobile.magnet.southpole.Magnet
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.miyyapi.testapi.ITestLoginInit

/**
 * Created by wangfeihang on 2019-06-29.
 */
object TestLoginInit : ITestLoginInit {

    override fun init(refreshState: () -> Unit) {

        //同步联运的登录态
        LoginUtil.synchronizeUnionLoginState()

        refreshState()

        Magnet.addStateListener(object : AuthStateListener {

            override fun onNamedLogin(info: LoginSuccessEvent) {
                refreshState()
            }

            override fun onLogout() {
                refreshState()
            }

            override fun onLoginInterrupt(error: LoginException) {
                refreshState()
            }

            override fun onAnonymousLogin(anonymousUid: Long) {
                refreshState()
            }
        })
    }
}