package com.yy.mobile.miyyapi

import android.app.Activity
import android.app.Application
import android.content.Context
import com.alibaba.android.arouter.launcher.ARouter
import com.unionyy.mobile.meipai.api.MP2YYChannelAction
import com.yy.ent.mobile.mp.popularity.server.msg.nano.MeiPaiPopularity
import com.yy.mobile.api.HP2YYBasicActionCallback
import com.yy.mobile.api.HPBasicActionHandler
import com.yy.mobile.api.HPLog
import com.yy.mobile.api.HPLogCallback
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.config.BasicConfig
import com.yy.mobile.replugin.ApiBridge
import com.yy.mobile.ui.feedback.FeedbackData
import com.yy.mobile.ui.feedback.LogUploadTaskCompat
import com.yy.mobile.util.AppMetaDataUtil
import com.yy.mobile.util.TelephonyUtils
import com.yy.mobile.util.log.MLog
import com.yymobile.core.EnvUriSetting
import com.yymobile.core.ICoreManagerBase
import io.reactivex.android.schedulers.AndroidSchedulers

/**
 * Created BY PYF 2019-10-14
 * email: pengyangfan@yy.com
 * 美拍独有初始化
 */
object MPYYExtraSDK {

    const val TAG = "MPYYExtraSDK"

    fun registeFeedBackBroadCast() {
        if (ICoreManagerBase.getEntCore() == null) {
            MLog.error(TAG, "registeFeedBackBroadCast error = current GetEntCore is null")
            return
        }
        ICoreManagerBase.getEntCore().registerBroadcast(MeiPaiPopularity.LogBroadcast::class.java)
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({
                MLog.info(TAG, "-- recieve log broadcast = ${it.log}")
                val feedbackData =
                    FeedbackData.Builder("unionyy-android", LoginUtil.getUid(), it.log)
                        .setGuid(TelephonyUtils.getImei(BasicConfig.getInstance().appContext))
                        .setMarketChannel(AppMetaDataUtil.getChannelID(BasicConfig.getInstance().appContext))
                        .create()
                LogUploadTaskCompat.execute(feedbackData, true)
            }, {
                MLog.error(TAG, "registeFeedBackBroadCast error = $it")
            })
    }

    fun setHomepageListener(application: Application) {
        HPBasicActionHandler.apply {
            envType = when (EnvUriSetting.getUriSetting()) {
                EnvUriSetting.Product -> 0
                EnvUriSetting.Dev -> 1
                EnvUriSetting.Test -> 2
                null -> 2
            }
            setListener(object : HP2YYBasicActionCallback {
                override fun enterH5page(url: String, context: Context?) {
                    ARouter.getInstance().build(url).navigation(context ?: application)
                }

                override fun enterLiveRoom(
                    sid: Long,
                    ssid: Long,
                    context: Context?,
                    thumb: String
                ) {
                    if (context is Activity) {
                        ApiBridge.getApi(MP2YYChannelAction::class.java)?.instance(sid, ssid)
                            ?.thumb(thumb)?.from(MP2YYChannelAction.LIVE_CHANNEL)
                            ?.joinChannel(context)
                    } else {
                        ApiBridge.getApi(MP2YYChannelAction::class.java)?.instance(sid, ssid)
                            ?.thumb(thumb)?.from(MP2YYChannelAction.LIVE_CHANNEL)?.joinChannel(null)
                    }
                }

                override fun enterPersonalCenter() {
                }

                override fun enterSettingPage() {
                }

                override fun isLogin(): Boolean {
                    return LoginUtil.isLogined()
                }

                override fun loginUid(): Long {
                    return LoginUtil.getUid()
                }

                override fun queryUserInfo(uid: Long, type: Int) {
                }

                override fun loginOpenUid(): String {
                    return LoginUtil.getUnionOpenId() ?: ""
                }
            })
        }

        HPLog.setLogHandler(object : HPLogCallback {
            override fun debug(obj: Any, format: String, vararg args: Any) {
                MLog.debug(obj, format, args)
            }

            override fun error(obj: Any, format: String, vararg args: Any) {
                MLog.error(obj, format, args)
            }

            override fun error(obj: Any, format: String, t: Throwable, vararg args: Any) {
                MLog.error(obj, format, t, args)
            }

            override fun error(obj: Any, t: Throwable) {
                MLog.error(obj, t)
            }

            override fun info(obj: Any, format: String, vararg args: Any) {
                MLog.info(obj, format, args)
            }

            override fun verbose(obj: Any, format: String, vararg args: Any) {
                MLog.verbose(obj, format, args)
            }

            override fun warn(obj: Any, format: String, vararg args: Any) {
                MLog.warn(obj, format, args)
            }
        })
    }
}