package com.yy.mobile.miyyapi

import android.Manifest
import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.view.View
import com.duowan.mobile.aar.R
import com.gyf.immersionbar.ImmersionBar
import com.unionyy.mobile.magnet.core.state.CrossProcessLoginState
import com.unionyy.mobile.magnet.core.state.InterruptState
import com.unionyy.mobile.magnet.core.state.LoginState
import com.unionyy.mobile.magnet.core.state.LogoutState
import com.unionyy.mobile.magnet.southpole.Magnet
import com.unionyy.mobile.meipai.api.MP2YYChannelAction
import com.unionyy.mobile.meipai.api.MP2YYCustomServicePageAction
import com.unionyy.mobile.meipai.api.MP2YYFeedbackAction
import com.unionyy.mobile.meipai.api.MP2YYSettingAction
import com.unionyy.mobile.meipai.feedback.ui.MeipaiFeedbackQActivity
import com.unionyy.mobile.meipai.userinfo.MeiPaiUserInfoCore
import com.unionyy.opensdk.BuildConfig
import com.yanzhenjie.permission.AndPermission
import com.yy.mobile.miyyapi.testapi.ITestGotoLoginAction
import com.yy.mobile.miyyapi.testapi.ITestGotoSettingAction
import com.yy.mobile.miyyapi.testapi.ITestLoginInit
import com.yy.mobile.miyyapi.testapi.impl.TestGotoLoginActionImpl
import com.yy.mobile.miyyapi.testapi.impl.TestGotoSettingActionImpl
import com.yy.mobile.miyyapi.testapi.impl.TestLoginInit
import com.yy.mobile.util.RxUtils
import com.yy.mobile.ylink.bridge.CoreApiManager
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.meipai_activity_demo.*

class DemoActivity : FragmentActivity() {

    @SuppressLint("CheckResult")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.meipai_activity_demo)

        MPYYSDK.registerAction(ITestGotoLoginAction::class.java) { TestGotoLoginActionImpl() }
        MPYYSDK.registerAction(ITestGotoSettingAction::class.java) { TestGotoSettingActionImpl() }
        MPYYSDK.registerAction(ITestLoginInit::class.java) { TestLoginInit }

        ImmersionBar.with(this)
            .init()

//        askPermissions(
//            Manifest.permission.READ_PHONE_STATE,
//            Manifest.permission.WRITE_EXTERNAL_STORAGE,
//            Manifest.permission.READ_EXTERNAL_STORAGE,
//            Manifest.permission.INTERNET
//        ) {}

        AndPermission.with(this)
            .runtime()
            .permission(
                Manifest.permission.READ_PHONE_STATE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.INTERNET
            )
            .start()

        MPYYSDK.obtainAction(ITestLoginInit::class.java, this.application, this)?.init {
            refreshState()
        }

        passwordLogin.setOnClickListener {
            MPYYSDK.obtainAction(ITestGotoLoginAction::class.java)?.gotoLoginActivity(this)
        }

        customservice.setOnClickListener {
            MPYYSDK.obtainAction(MP2YYCustomServicePageAction::class.java)?.toCustomServicePage(this)
        }

        h5Test.setOnClickListener {
            CoreApiManager.getInstance().getApi(NavigationUtilApi::class.java)!!.toJSSupportedWebView(
                this,
                "http://webtest.yy.com/app_doc/index.html"
            )
        }

        feedBack.setOnClickListener {
            MPYYSDK.obtainAction(MP2YYFeedbackAction::class.java)?.gotoFeedbackPage(this)
        }

        tv_app_version.text = "YY版本号：${BuildConfig.YYSDK_VER}"

        btn_question_list.setOnClickListener {
            startActivity(Intent(this, MeipaiFeedbackQActivity::class.java))
        }
    }

    fun gotoChannel(v: View) {
        val sid = et_channel_sid.text.toString().toLongOrNull() ?: 1493896955
        val ssid = 0L
        MPYYSDK.obtainAction(MP2YYChannelAction::class.java)?.run {
            instance(sid, ssid)
                .joinChannel(this@DemoActivity)
        }
    }

    fun gotoSetting(v: View) {
        MPYYSDK.obtainAction(MP2YYSettingAction::class.java)?.gotoSettingActivity(this)
    }

    @SuppressLint("SetTextI18n")
    private fun refreshState() {
        val state = Magnet.getCurrentState()
        when (state) {
            is LoginState -> {
                currentStateText.text = "登录中-当前uid:${state.currentUid}, 第三方openId:${state.thirdPartyInfo?.openId}"
                MeiPaiUserInfoCore.requestMPPersonalCardUserInfo(state.currentUid).subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread()).subscribe(
                        Consumer {
                            currentStateText.text =
                                "登录中-当前uid:${state.currentUid}, 第三方openId:${state.thirdPartyInfo?.openId}" +
                                        ", 服务器查询返回的mpuid:${it.mpuid}"
                        }, RxUtils.errorConsumer("DemoActivity")
                    )
            }
            is InterruptState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}, 错误:${state.error?.message}"
            is LogoutState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}"
            is CrossProcessLoginState ->
                currentStateText.text = "跨进程登录中-当前uid:${state.currentUid}"
        }
    }
}