/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.controller;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveARAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveLargeAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveLargeBottomAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveLargeTopAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveSmallBottomGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveSmallGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveSmallTopGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GiftAnimationLayout;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.controller.GiftAnimateController;
import com.unionyy.mobile.meipai.gift.event.EventGift;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LiveGiftAnimateProcessor {
    public static final String TAG = LiveGiftAnimateProcessor.class.getSimpleName();
    private LiveARAnimateDecoder mARAnimateDecoder;
    private LiveLargeAnimateDecoder mLargeBottomAnimateDecoder;
    private LiveLargeAnimateDecoder mLargeTopAnimateDecoder;
    private LiveSmallGiftAnimateDecoder mSmallTopGiftAnimateDecoder;
    private LiveSmallGiftAnimateDecoder mSmallBottomAnimateDecoder;
    private GiftAnimateController mGiftAnimateController;
    private GlAnimationView mGlAnimationView;
    private GiftAnimationLayout mSmallGiftViewGroup;
    private GiftAnimationLayout mLargeGiftViewGroup;
    private EventGift mIncreData = new EventGift();
    private long queueDelayTime = 100L;
    private volatile boolean isPollStart = false;
    private Handler queueHandler = new Handler(Looper.myLooper());
    private Runnable queueRunnable = new Runnable(){

        @Override
        public void run() {
            if (LiveGiftAnimateProcessor.this.mIncreData.getGiftMessages() != null && !LiveGiftAnimateProcessor.this.mIncreData.getGiftMessages().isEmpty()) {
                LinkedList<GiftMessage> giftEvents = new LinkedList<GiftMessage>();
                giftEvents.add(LiveGiftAnimateProcessor.this.mIncreData.getGiftMessages().poll());
                LiveGiftAnimateProcessor.this.checkGiftMessages(giftEvents);
                LiveGiftAnimateProcessor.this.queueHandler.postDelayed((Runnable)this, LiveGiftAnimateProcessor.this.queueDelayTime);
            } else {
                LiveGiftAnimateProcessor.this.isPollStart = false;
            }
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            int giftType = msg.arg1;
            ArrayList giftMessages = (ArrayList)msg.obj;
            if (giftType == 1) {
                LiveGiftAnimateProcessor.this.dispatchLargeGiftAnimation(giftMessages);
            } else {
                LiveGiftAnimateProcessor.this.mGiftAnimateController.sendGift(giftMessages);
            }
        }
    };

    public void handlePostLiveMessage(GiftMessage event) {
        if (null == this.mIncreData.getGiftMessages()) {
            this.mIncreData.setGiftMessages(new ConcurrentLinkedQueue<GiftMessage>());
        }
        this.mIncreData.getGiftMessages().add(event);
        this.pollStart();
    }

    private void pollStart() {
        if (!this.isPollStart) {
            this.isPollStart = true;
            this.queueHandler.removeCallbacksAndMessages(null);
            this.queueHandler.postDelayed(this.queueRunnable, this.queueDelayTime);
        }
    }

    public LiveGiftAnimateProcessor(Context context, GiftAnimationLayout smallGiftGroup, GlAnimationView glAnimationView, GiftAnimationLayout largeGiftGroup, boolean isAnchorLive) {
        this.mSmallGiftViewGroup = smallGiftGroup;
        this.mLargeGiftViewGroup = largeGiftGroup;
        this.mGlAnimationView = glAnimationView;
        this.mGiftAnimateController = new GiftAnimateController(true);
        this.mSmallBottomAnimateDecoder = new LiveSmallBottomGiftAnimateDecoder(context, (ViewGroup)smallGiftGroup);
        this.mGiftAnimateController.registerDecoder(this.mSmallBottomAnimateDecoder);
        this.mSmallTopGiftAnimateDecoder = new LiveSmallTopGiftAnimateDecoder(context, (ViewGroup)largeGiftGroup);
        this.mGiftAnimateController.registerDecoder(this.mSmallTopGiftAnimateDecoder);
        this.mLargeBottomAnimateDecoder = new LiveLargeBottomAnimateDecoder(context, (ViewGroup)smallGiftGroup, this.mGiftAnimateController.getGiftMessageDispatcher());
        this.mGiftAnimateController.registerDecoder(this.mLargeBottomAnimateDecoder);
        this.mLargeTopAnimateDecoder = new LiveLargeTopAnimateDecoder(context, (ViewGroup)largeGiftGroup, this.mGiftAnimateController.getGiftMessageDispatcher());
        this.mGiftAnimateController.registerDecoder(this.mLargeTopAnimateDecoder);
        if (isAnchorLive && DeviceUtils.canUseLiveARMode()) {
            this.mARAnimateDecoder = new LiveARAnimateDecoder(this.mGiftAnimateController.getGiftMessageDispatcher());
            this.mGiftAnimateController.registerDecoder(this.mARAnimateDecoder);
        }
        smallGiftGroup.setGiftAnimateController(this.mGiftAnimateController);
        largeGiftGroup.setGiftAnimateController(this.mGiftAnimateController);
    }

    public void setOnUserInfoClickListener(GiftTarget.OnUserInfoClickListener onUserInfoClickListener) {
        if (this.mSmallBottomAnimateDecoder != null) {
            this.mSmallBottomAnimateDecoder.setOnUserInfoClickListener(onUserInfoClickListener);
        }
        if (this.mSmallTopGiftAnimateDecoder != null) {
            this.mSmallTopGiftAnimateDecoder.setOnUserInfoClickListener(onUserInfoClickListener);
        }
        if (this.mLargeTopAnimateDecoder != null) {
            this.mLargeTopAnimateDecoder.setOnUserInfoClickListener(onUserInfoClickListener);
        }
        if (this.mLargeBottomAnimateDecoder != null) {
            this.mLargeBottomAnimateDecoder.setOnUserInfoClickListener(onUserInfoClickListener);
        }
    }

    public void setAREffectListenerOnGiftDecoder(LiveARAnimateDecoder.IARGiftSetListener listener2) {
        if (this.mARAnimateDecoder != null) {
            this.mARAnimateDecoder.setIARGiftSetListener(listener2);
        }
    }

    public GlAnimationView getGlAnimationView() {
        return this.mGlAnimationView;
    }

    public void setGiftViewGroupVisibility(int visibility) {
        if (this.mSmallGiftViewGroup != null) {
            this.mSmallGiftViewGroup.setVisibility(visibility);
        }
        if (this.mLargeGiftViewGroup != null) {
            this.mLargeGiftViewGroup.setVisibility(visibility);
        }
    }

    public void dispatchLargeGiftAnimation(ArrayList<GiftMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        ArrayList<GiftMessage> levelBottomGifts = new ArrayList<GiftMessage>();
        ListIterator<GiftMessage> giftIterator = messages.listIterator();
        while (giftIterator.hasNext()) {
            GiftMessage tmpGift = (GiftMessage)giftIterator.next();
            if (tmpGift.getLevel() != 1) continue;
            giftIterator.remove();
            levelBottomGifts.add(tmpGift);
        }
        this.mGiftAnimateController.sendGift(levelBottomGifts);
        this.mGiftAnimateController.sendGift(messages);
    }

    public void setPause(boolean isPause) {
        this.mGiftAnimateController.setPause(isPause);
    }

    public void clear() {
        this.mGiftAnimateController.clear();
        if (this.mIncreData != null && this.mIncreData.getGiftMessages() != null) {
            this.mIncreData.getGiftMessages().clear();
        }
        this.queueHandler.removeCallbacksAndMessages(null);
    }

    public void release() {
        this.mGiftAnimateController.release();
        this.mARAnimateDecoder = null;
        this.mLargeBottomAnimateDecoder = null;
        this.mLargeTopAnimateDecoder = null;
        this.mSmallBottomAnimateDecoder = null;
        this.mSmallTopGiftAnimateDecoder = null;
        this.mGlAnimationView = null;
        this.mSmallGiftViewGroup = null;
        if (this.mIncreData != null && this.mIncreData.getGiftMessages() != null) {
            this.mIncreData.getGiftMessages().clear();
        }
        this.queueHandler.removeCallbacksAndMessages(null);
    }

    private void checkGiftMessages(List<GiftMessage> list2) {
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        long myUid = LoginUtil.getUid();
        HashMap<String, Integer[]> dHitIdMap = new HashMap<String, Integer[]>();
        GiftMessage[] giftShowArry = new GiftMessage[2];
        ArrayList<GiftMessage> largeGiftList = new ArrayList<GiftMessage>();
        int giftLowIndex = 0;
        for (GiftMessage liveMessageEventBean : list2) {
            if (liveMessageEventBean.getGift_type() == 1 || liveMessageEventBean.getGift_type() == 2) {
                GiftMessage message = this.getGiftMessageFromMessageEvent(liveMessageEventBean, null, myUid);
                if (message == null) continue;
                message.setBussiness(liveMessageEventBean.getBussiness());
                if (liveMessageEventBean.getBussiness() == 11) {
                    message.setGestureGiftUrl(liveMessageEventBean.getGestureGiftUrl());
                    message.setChannelId(liveMessageEventBean.getChannelId());
                }
                largeGiftList.add(message);
                continue;
            }
            String doubleHitId = liveMessageEventBean.getDouble_hit_id();
            if (!TextUtils.isEmpty((CharSequence)doubleHitId)) {
                int hitNum = liveMessageEventBean.getDoubleHit();
                Integer[] hitIdArry = dHitIdMap.get(doubleHitId);
                if (hitIdArry == null) {
                    hitIdArry = new Integer[]{hitNum, hitNum};
                    dHitIdMap.put(doubleHitId, hitIdArry);
                } else if (hitNum > hitIdArry[1]) {
                    hitIdArry[1] = hitNum;
                } else if (hitNum < hitIdArry[0]) {
                    hitIdArry[0] = hitNum;
                }
            }
            long uid = liveMessageEventBean.getUid();
            giftLowIndex = this.filterShowGif(liveMessageEventBean, giftShowArry, giftLowIndex, uid, myUid);
        }
        ArrayList<GiftMessage> showGiftArrary = this.getGiftMessageFromList(giftShowArry, dHitIdMap, myUid);
        if (showGiftArrary != null) {
            this.mHandler.obtainMessage(0, showGiftArrary).sendToTarget();
        }
        if (largeGiftList.size() > 0) {
            this.mHandler.obtainMessage(1, largeGiftList).sendToTarget();
        }
    }

    @Nullable
    private GiftMessage getArGiftFromGlobalGiftMessageIfExist(GiftMessage bean, long loginId) {
        GiftMessage giftMessage = new GiftMessage(bean.getGift_id(), bean.getGiftLocalPath());
        giftMessage.setUserName(bean.getUserName());
        giftMessage.setUid(bean.getUid());
        giftMessage.setLevel(bean.getLevel());
        giftMessage.setAvatar(bean.getAvatar());
        giftMessage.setGiftName(bean.getGiftName());
        giftMessage.setClient_order_id(bean.getClient_order_id());
        giftMessage.setAnchorName(bean.getAnchorName());
        giftMessage.setGiverMedalID(bean.getGiverMedalID());
        giftMessage.setGift_type(2);
        if (TextUtils.isEmpty((CharSequence)bean.getDouble_hit_id())) {
            giftMessage.setComboFrom(0);
            giftMessage.setComboTo(0);
        }
        giftMessage.setWeight(bean.getGift_weight());
        return giftMessage;
    }

    private ArrayList<GiftMessage> getGiftMessageFromList(GiftMessage[] gifShowArry, HashMap<String, Integer[]> sameHitIdMap, long loginId) {
        ArrayList<GiftMessage> giftMessages = null;
        for (int i = 0; i < gifShowArry.length; ++i) {
            GiftMessage giftMessage;
            GiftMessage bean = gifShowArry[i];
            if (bean == null || (giftMessage = this.getGiftMessageFromMessageEvent(bean, sameHitIdMap, loginId)) == null) continue;
            if (giftMessages == null) {
                giftMessages = new ArrayList<GiftMessage>();
            }
            giftMessages.add(giftMessage);
        }
        return giftMessages;
    }

    private GiftMessage getGiftMessageFromMessageEvent(GiftMessage bean, HashMap<String, Integer[]> sameHitIdMap, long loginId) {
        GiftMessage giftMessage = new GiftMessage(bean.getGift_id(), bean.getGiftLocalPath());
        giftMessage.setUserName(bean.getUserName());
        giftMessage.setUid(bean.getUid());
        giftMessage.setLevel(bean.getLevel());
        giftMessage.setAvatar(bean.getAvatar());
        giftMessage.setGiftName(bean.getGiftName());
        giftMessage.setClient_order_id(bean.getClient_order_id());
        giftMessage.setAnchorName(bean.getAnchorName());
        giftMessage.setGiverMedalID(bean.getGiverMedalID());
        giftMessage.setGift_type(bean.getGift_type());
        if (TextUtils.isEmpty((CharSequence)bean.getDouble_hit_id())) {
            giftMessage.setComboFrom(0);
            giftMessage.setComboTo(0);
        } else if (sameHitIdMap != null) {
            giftMessage.setDoublehitId(bean.getDouble_hit_id());
            Integer[] hitIdArry = sameHitIdMap.get(bean.getDouble_hit_id());
            if (hitIdArry != null && hitIdArry.length > 0) {
                giftMessage.setComboFrom(hitIdArry[0]);
            } else {
                giftMessage.setComboFrom(bean.getDoubleHit());
            }
            giftMessage.setComboTo(bean.getDoubleHit());
        }
        MLog.info((Object)"LiveGiftAnimateProcessor", (String)("ComboFrom" + giftMessage.getComboFrom()), (Object[])new Object[0]);
        MLog.info((Object)"LiveGiftAnimateProcessor", (String)("ComboTo" + giftMessage.getComboTo()), (Object[])new Object[0]);
        giftMessage.setWeight(bean.getGift_weight());
        giftMessage.setPopularity_of_gift(bean.getPopularity_of_gift());
        giftMessage.setWhenTypeIsLargeExtendAR(bean.getWhenTypeIsLargeExtendAR());
        giftMessage.setSendAmount(bean.getSendAmount());
        giftMessage.setSendAmountGiftAnimationName(bean.getSendAmountGiftAnimationName());
        return giftMessage;
    }

    private int filterShowGif(GiftMessage curBean, GiftMessage[] gifShowArry, int lowIndex, long uid, long myUid) {
        int filterAfterValue;
        if (uid <= 0L || curBean == null) {
            return lowIndex;
        }
        for (int i = 0; i < gifShowArry.length; ++i) {
            GiftMessage bean = gifShowArry[i];
            if (bean == null || TextUtils.isEmpty((CharSequence)bean.getDouble_hit_id()) || !bean.getDouble_hit_id().equals(curBean.getDouble_hit_id())) continue;
            lowIndex = i;
            break;
        }
        int curMsgBeanValue = GiftAnimateController.computeGiftValue(curBean.getDoubleHit(), curBean.getGift_weight());
        GiftMessage tmpBean = gifShowArry[lowIndex];
        if (tmpBean == null) {
            gifShowArry[lowIndex] = curBean;
            filterAfterValue = curMsgBeanValue;
        } else {
            int oldLowValue = GiftAnimateController.computeGiftValue(tmpBean.getDoubleHit(), tmpBean.getGift_weight());
            boolean firstBiggerThanSec = this.giftValueFirstBiggerThanSec(curMsgBeanValue, oldLowValue);
            if (firstBiggerThanSec) {
                gifShowArry[lowIndex] = curBean;
                filterAfterValue = curMsgBeanValue;
            } else {
                return lowIndex;
            }
        }
        int nextIndex = (lowIndex + 1) % 2;
        GiftMessage bean = gifShowArry[nextIndex];
        if (bean == null) {
            MLog.info((Object)"LiveGiftAnimateProcessor", (String)("nextIndex" + nextIndex), (Object[])new Object[0]);
            return nextIndex;
        }
        int newValue = GiftAnimateController.computeGiftValue(bean.getDoubleHit(), bean.getGift_weight());
        boolean firstBiggerThanSec = this.giftValueFirstBiggerThanSec(newValue, filterAfterValue);
        if (!firstBiggerThanSec) {
            MLog.info((Object)"LiveGiftAnimateProcessor", (String)("nextIndex" + nextIndex), (Object[])new Object[0]);
            return nextIndex;
        }
        MLog.info((Object)"LiveGiftAnimateProcessor", (String)("lowIndex" + lowIndex), (Object[])new Object[0]);
        return lowIndex;
    }

    private boolean giftValueFirstBiggerThanSec(int first, int sec) {
        if (first > sec) {
            return true;
        }
        if (first < sec) {
            return false;
        }
        return false;
    }

    public GiftAnimateController getGiftAnimateController() {
        return this.mGiftAnimateController;
    }
}

