/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.decoder.sub;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.callback.OnGiftPositionChangedListener;
import com.unionyy.mobile.meipai.gift.animation.decoder.AbstractAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftImageTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.DipUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.transvodplayer.PlayerListener;
import com.yy.transvodplayer.VideoPlayerView;
import java.util.ArrayList;

public class LiveEggAnimateDecoder
extends AbstractAnimateDecoder {
    private static String TAG = "LiveEggAnimateDecoder";
    public static int EGG_VIEW_PARTS = 1;
    private final ArrayList<GiftTarget> mEggsList = new ArrayList();
    private int mCurrentEggGiftSize = 0;
    private ILiveGiftEggAttachListener mListener;
    private ViewGroup.LayoutParams mPlayerLP = null;
    private GiftTarget.GiftImageDismissListener mEggGiftDismissListener = new GiftTarget.GiftImageDismissListener(){

        @Override
        public void onGiftDismiss(GiftTarget target) {
            LiveEggAnimateDecoder.this.mEggsList.remove(target);
            LiveEggAnimateDecoder.this.mCurrentEggGiftSize--;
            LiveEggAnimateDecoder.this.recycleGiftTarget(target);
        }
    };

    public LiveEggAnimateDecoder(Context context, ViewGroup viewGroup) {
        super(context, viewGroup);
    }

    @Override
    protected float getGiftViewHeight() {
        return (float)this.mHeight - this.marginTop - this.marginBottom;
    }

    @Override
    public boolean dealWithGiftMessage(GiftMessage giftMessage) {
        new LoadGiftResourceTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new GiftMessage[]{giftMessage});
        return true;
    }

    public void addGiftTargetToGroup(GiftTarget target, float x, float y) {
        ++this.mCurrentEggGiftSize;
        int indexPos = EGG_VIEW_PARTS * (this.mCurrentEggGiftSize - 1);
        target.addTo(this.mContext, this.mGiftViewGroup, x, y, indexPos, this.mWidth, GiftTarget.GiftFrom.LIVE_EGG);
        this.requestAutoInvalidate();
    }

    private void addMp4GiftTargetToGroup(final GiftTarget target, float x, float y) {
        String url = target.getGiftMessage().getGiftLocalPath();
        MLog.debug((Object)TAG, (String)("[zhk][addMp4GiftTargetToGroup]" + url), (Object[])new Object[0]);
        if (this.mVideoPlayerView == null) {
            this.mVideoPlayerView = new VideoPlayerView(this.mContext);
            this.mPlayerLP = new ViewGroup.LayoutParams(ScreenUtil.getInstance().dip2px(300), ScreenUtil.getInstance().dip2px(200));
            this.mGiftViewGroup.addView((View)this.mVideoPlayerView, this.mPlayerLP);
            this.mVideoPlayerView.setListener(new PlayerListener(){

                public void onPlayCompletion() {
                    LiveEggAnimateDecoder.this.mEggGiftDismissListener.onGiftDismiss(target);
                }
            });
        }
        this.mVideoPlayerView.setLeft((int)x);
        this.mVideoPlayerView.setTop((int)y);
        this.mVideoPlayerView.play(url, 0);
    }

    @Override
    public void addGestureGiftToGroup(GiftTarget target) {
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.mEggsList.size(); ++i) {
            GiftTarget eggTarget = this.mEggsList.get(i);
            this.recycleGiftTarget(eggTarget);
        }
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.release();
            this.mGiftViewGroup.removeView((View)this.mVideoPlayerView);
            this.mVideoPlayerView = null;
        }
        this.mCurrentEggGiftSize = 0;
        this.mEggsList.clear();
    }

    @Override
    public int desireGiftMessageType() {
        return -11;
    }

    private float[] updateGiftEggPosition(GiftTarget giftTarget, GiftTarget eggTarget, float moveToX, float moveToY) {
        if (null != giftTarget && !giftTarget.isImageTargetDismiss() && null != eggTarget) {
            int eggImageWidth = eggTarget.getGiftImageWidth();
            int eggImageHeight = eggTarget.getGiftImageHeight();
            float[] imageCenterPosition = null;
            GiftRule eggRule = eggTarget.getGiftRule();
            if (null != eggRule) {
                imageCenterPosition = eggRule.center_position;
            }
            int[] eggCenterPosition = new int[2];
            float[] littleGiftLeftTopPosition = new float[2];
            if (null != imageCenterPosition && imageCenterPosition.length == 2) {
                eggCenterPosition[0] = (int)(imageCenterPosition[0] * (float)eggImageWidth);
                eggCenterPosition[1] = (int)(imageCenterPosition[1] * (float)eggImageHeight);
            } else {
                eggCenterPosition[0] = eggImageWidth >> 1;
                eggCenterPosition[1] = eggImageHeight >> 1;
            }
            littleGiftLeftTopPosition[0] = moveToX > 0.0f ? moveToX : giftTarget.getGiftImageLeft();
            littleGiftLeftTopPosition[1] = moveToY > 0.0f ? moveToY : giftTarget.getGiftImageTop();
            float x = DipUtils.dip2px(230.0f) - eggCenterPosition[0];
            if (eggImageWidth + DipUtils.dip2px(2.0f) >= DeviceUtils.getScreenWidth()) {
                x = 0.0f;
            }
            float y = littleGiftLeftTopPosition[1] + (float)(giftTarget.getGiftImageHeight() >> 1) - (float)eggCenterPosition[1];
            return new float[]{x, y};
        }
        return null;
    }

    public int getCurrentEggGiftSize() {
        return this.mCurrentEggGiftSize;
    }

    public void setLiveEggAttachListener(ILiveGiftEggAttachListener listener2) {
        this.mListener = listener2;
    }

    private class OnLittleGiftPositionChangedImpl
    implements OnGiftPositionChangedListener {
        private OnLittleGiftPositionChangedImpl() {
        }

        @Override
        public void onChanged(@NonNull GiftTarget giftTarget, @Nullable GiftTarget eggTarget, float x, float y) {
            float[] position = LiveEggAnimateDecoder.this.updateGiftEggPosition(giftTarget, eggTarget, x, y);
            if (null != position && null != eggTarget) {
                eggTarget.setGiftImagePosition(position[0], position[1]);
                eggTarget.translateGiftImageY(eggTarget.getGiftImageTop());
            }
        }
    }

    private class LoadGiftResourceTask
    extends AsyncTask<GiftMessage, Void, Boolean> {
        private GiftTarget targetEgg;
        private GiftMessage giftEgg;

        protected Boolean doInBackground(GiftMessage ... params) {
            this.giftEgg = params[0];
            if (null != this.giftEgg) {
                if (this.giftEgg.getGiftLocalPath().endsWith(".mp4")) {
                    this.targetEgg = new GiftImageTarget();
                    this.targetEgg.setGiftMessage(this.giftEgg);
                } else {
                    this.targetEgg = LiveEggAnimateDecoder.this.loadGiftImageTarget(this.giftEgg);
                }
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            if (null != this.targetEgg) {
                LiveEggAnimateDecoder.this.mEggsList.add(this.targetEgg);
            }
            if (this.giftEgg != null && this.targetEgg != null) {
                GiftTarget littleGiftTarget;
                GiftTarget giftTarget = littleGiftTarget = LiveEggAnimateDecoder.this.mListener != null ? LiveEggAnimateDecoder.this.mListener.findEggTargetAttachOn(this.giftEgg) : null;
                if (null != littleGiftTarget && !littleGiftTarget.isImageTargetDismiss()) {
                    littleGiftTarget.setEggTarget(this.targetEgg);
                    littleGiftTarget.setGiftPositionChangedListener(new OnLittleGiftPositionChangedImpl());
                    float[] position = LiveEggAnimateDecoder.this.updateGiftEggPosition(littleGiftTarget, this.targetEgg, -1.0f, -1.0f);
                    if (null != position) {
                        if (this.targetEgg.getGiftMessage().getGiftLocalPath().endsWith(".mp4")) {
                            LiveEggAnimateDecoder.this.addMp4GiftTargetToGroup(this.targetEgg, position[0], position[1]);
                        } else {
                            this.targetEgg.setGiftImageDismissListener(LiveEggAnimateDecoder.this.mEggGiftDismissListener);
                            LiveEggAnimateDecoder.this.addGiftTargetToGroup(this.targetEgg, position[0], position[1]);
                        }
                    }
                }
            }
        }
    }

    public static interface ILiveGiftEggAttachListener {
        public GiftTarget findEggTargetAttachOn(GiftMessage var1);
    }
}

