/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.yy.mobile.util.log.MLog;

public class ConnectLoadingView
extends View {
    private final int DELAY_DURATION = 16;
    private final int MAX_SWEEP_ANGEL = 160;
    private final int MIN_SWEEP_ANGEL = 10;
    private final int SWEEP_ANGEL_SPEED = 8;
    private final int START_ANGEL_SPEED = 10;
    private Paint paint;
    private int[] strokeColors = new int[]{Color.parseColor((String)"#40BCF5"), Color.parseColor((String)"#FF5C6D")};
    private RectF rectF;
    private int startAngel = 0;
    private int sweepAngle = 150;
    private int strokeWidth = DeviceUtils.dip2px(1.5f);
    private boolean isAdd = false;
    private int stopTime = 0;
    private int markStrokeWidth = DeviceUtils.dip2px(2.5f);
    private int markColor = Color.parseColor((String)"#ffffff");
    private int d = DeviceUtils.dip2px(36.0f);
    private boolean mIsMark = true;
    private final int speed = DeviceUtils.dip2px(1.0f);
    private int mark_ts = 2000;
    private float startx;
    private float starty;
    private float endx;
    private float endy;
    private float cornerx;
    private float cornery;
    private float maxX;
    private float minY;
    private boolean corner = false;
    private Runnable drawRunnable = new Runnable(){

        @Override
        public void run() {
            ConnectLoadingView.this.invalidate();
        }
    };
    private float[] ops;

    public ConnectLoadingView(Context context) {
        super(context);
        this.init();
    }

    public ConnectLoadingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConnectLoadingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.strokeWidth);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.rectF = new RectF();
        this.mIsMark = false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIsMark) {
            this.drawMark(canvas);
        }
        this.rectF.set((float)this.strokeWidth, (float)this.strokeWidth, (float)(this.getWidth() - this.strokeWidth), (float)(this.getHeight() - this.strokeWidth));
        this.paint.setStrokeWidth((float)this.strokeWidth);
        this.paint.setColor(this.strokeColors[0]);
        canvas.drawArc(this.rectF, (float)this.startAngel, (float)this.sweepAngle, false, this.paint);
        this.paint.setColor(this.strokeColors[1]);
        canvas.drawArc(this.rectF, (float)(this.startAngel + 180), (float)this.sweepAngle, false, this.paint);
        this.startAngel += 10;
        this.startAngel %= 360;
        if (this.isAdd) {
            this.sweepAngle += 8;
            if (this.sweepAngle >= 160) {
                this.stopTime = 0;
                this.isAdd = false;
            }
        } else if (this.sweepAngle >= 160 && this.stopTime < 50) {
            this.stopTime += 10;
        } else {
            this.sweepAngle -= 8;
            if (this.sweepAngle <= 10) {
                this.isAdd = true;
            }
        }
        this.removeOrPostMessage(true);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.removeOrPostMessage(visibility == 0);
        this.mIsMark = false;
    }

    private void drawMark(Canvas canvas) {
        this.paint.setStrokeWidth((float)this.markStrokeWidth);
        this.paint.setColor(this.markColor);
        if (this.endx < this.maxX) {
            this.endx += (float)this.speed;
        }
        if (this.endx >= this.cornerx && !this.corner) {
            this.corner = true;
        }
        if (this.corner) {
            if (this.endy > this.minY) {
                this.endy -= (float)this.speed;
            }
        } else {
            this.endy += (float)this.speed;
        }
        if (canvas != null) {
            this.ops = this.corner ? new float[]{this.startx, this.starty, this.cornerx, this.cornery, this.cornerx, this.cornery, this.endx, this.endy} : new float[]{this.startx, this.starty, this.endx, this.endy};
            MLog.debug((Object)"ConnectLoadingView", (String)("opts:" + this.ops.length + ",startx:" + this.startx + ",starty:" + this.starty + ",corner:" + this.corner + ",cornerx:" + this.cornerx + "cornery:" + this.cornery + ",endx:" + this.endx + ",endy:" + this.endy), (Object[])new Object[0]);
            canvas.drawLines(this.ops, this.paint);
        }
    }

    public void showMark() {
        this.setVisibility(0);
        this.startx = (float)this.d * 0.22f;
        this.starty = (float)this.d * 0.5f;
        this.endx = this.startx;
        this.endy = this.starty;
        this.cornerx = (float)this.d * 0.44f;
        this.cornery = (float)this.d * 0.67f;
        this.maxX = (float)this.d * 0.8f;
        this.minY = (float)this.d * 0.33f;
        this.mIsMark = true;
        this.corner = false;
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ConnectLoadingView.this.mIsMark = false;
                ConnectLoadingView.this.corner = false;
                ConnectLoadingView.this.setVisibility(8);
            }
        }, (long)this.mark_ts);
    }

    private void removeOrPostMessage(boolean isPost) {
        if (this.getHandler() == null) {
            return;
        }
        this.getHandler().removeCallbacks(this.drawRunnable);
        if (isPost) {
            this.getHandler().postDelayed(this.drawRunnable, 16L);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOrPostMessage(false);
        this.getHandler().removeCallbacksAndMessages(null);
    }
}

