/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.controller;

import android.content.res.Configuration;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.PraiseAnimteDecoder;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.core.config.Middleware2MPGiftMgr;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class LivePraiseController {
    private static final String TAG = "LivePraiseController";
    private PraiseAnimteDecoder mPraiseAnimteDecoder;
    private Thread mDrawPraiseThread;
    private boolean mDrawPraiseThreadWork;
    private boolean misLianmaiing;
    private long mLiveId;
    private long mClickLikeNum;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private LinkedBlockingDeque<Long> mRecivLikeList = new LinkedBlockingDeque();
    private static final int MAX_ANIMATION_ACTION_IN_ONE_SECOND = 5;
    private static final int SEND_DATA_DUR = 3000;
    private static final int MAX_PATH_COUNT = 10;
    private static final String SPECIAL_LIKE_ROOT_DIR_NAME = Middleware2MPGiftMgr.Companion.getInstances().getGiftConfigPath() + "/speciallike";
    private ExecutorService mSingleExcutor = Executors.newSingleThreadExecutor();

    public LivePraiseController(GlAnimationView glAnimationView) {
        this.mPraiseAnimteDecoder = new PraiseAnimteDecoder();
        this.mPraiseAnimteDecoder.setRequestRenderCallBack(glAnimationView);
        glAnimationView.addAnimationDecoder(0, this.mPraiseAnimteDecoder);
        File specialLikeFilePath = new File(SPECIAL_LIKE_ROOT_DIR_NAME);
        if (!specialLikeFilePath.exists()) {
            specialLikeFilePath.mkdirs();
        }
    }

    public void setLiveId(long liveId) {
        this.mLiveId = liveId;
    }

    public PraiseAnimteDecoder getPraiseAnimteDecoder() {
        return this.mPraiseAnimteDecoder;
    }

    public void onCreate() {
        this.startDrawPraiseAnimationThread();
        this.startSendThread();
    }

    public void onDestory() {
        this.stopDrawPraiseAnimationThread();
        this.stopSendThread();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mPraiseAnimteDecoder != null) {
            this.mPraiseAnimteDecoder.onConfigurationChanged(newConfig.orientation);
        }
    }

    private void sendLike() {
    }

    private void startSendThread() {
        this.sendLike();
    }

    private void stopSendThread() {
        if (null != this.mHandler) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    private void startDrawPraiseAnimationThread() {
        this.mDrawPraiseThreadWork = true;
        this.mDrawPraiseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (LivePraiseController.this.mDrawPraiseThreadWork) {
                    try {
                        long counts;
                        Thread.sleep(500L);
                        Long c = (Long)LivePraiseController.this.mRecivLikeList.take();
                        long l = counts = null == c ? 0L : c;
                        if (counts == 0L) {
                            return;
                        }
                        if (counts > 5L) {
                            counts = 5L;
                        }
                        long time = 1500L / counts;
                        while (counts > 0L) {
                            try {
                                Thread.sleep(time);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LivePraiseController.this.mPraiseAnimteDecoder.doNormalPraise(LivePraiseController.this.misLianmaiing);
                            --counts;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "praise-animation-draw");
        this.mDrawPraiseThread.start();
    }

    private void stopDrawPraiseAnimationThread() {
        this.mDrawPraiseThreadWork = false;
        if (this.mDrawPraiseThread != null && this.mDrawPraiseThread.isAlive()) {
            this.mDrawPraiseThread.interrupt();
        }
        this.mDrawPraiseThread = null;
    }

    public void doOnClickPraise() {
        ++this.mClickLikeNum;
        this.mPraiseAnimteDecoder.doNormalPraise(this.misLianmaiing);
    }

    public void clearPraiseResource() {
        if (this.mPraiseAnimteDecoder != null) {
            this.mPraiseAnimteDecoder.updateResource(false, null);
        }
    }

    private void updateResource(String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            if (this.mPraiseAnimteDecoder != null) {
                this.mPraiseAnimteDecoder.updateResource(true, path + "/small/");
            }
        } else if (this.mPraiseAnimteDecoder != null) {
            this.mPraiseAnimteDecoder.updateResource(false, null);
        }
    }

    private boolean isSpecialLikeIconNoExist(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return true;
        }
        String smallPath = SPECIAL_LIKE_ROOT_DIR_NAME + name + "/small/";
        File smallFile = new File(smallPath);
        return !smallFile.exists() || smallFile.list() == null || smallFile.list().length < 1;
    }

    public void setMisLianmaiing(boolean misLianmaiing) {
        this.misLianmaiing = misLianmaiing;
    }
}

