/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.chat.parse;

import android.content.Context;
import android.graphics.Color;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ReplacementSpan;
import android.view.View;
import com.unionyy.mobile.meipai.chat.codec.MPCMTextFactory;
import com.unionyy.mobile.meipai.chat.codec.MeiPaiChannelMessageCodec;
import com.unionyy.mobile.meipai.chat.codec.img.MPCMImageCreator;
import com.unionyy.mobile.meipai.chat.message.MeiPaiChannelMessage;
import com.unionyy.mobile.meipai.chat.message.bean.MPCMIcon;
import com.unionyy.mobile.meipai.chat.message.bean.MPCMRenderEntry;
import com.unionyy.mobile.meipai.chat.message.bean.MPCMText;
import com.unionyy.mobile.meipai.chat.message.bean.MPCMUserInfo;
import com.unionyy.mobile.meipai.personalcard.MeipaiPersonalCardBuilder;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatBaseParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0003\u0010\u0016\u001a\u00020\u0004H\u0003J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/unionyy/mobile/meipai/chat/parse/MeiPaiPublicChatParser;", "Lcom/yy/mobile/ui/publicchat/model/parser/PublicChatBaseParser;", "()V", "endowIcon", "", "spannable", "Landroid/text/SpannableStringBuilder;", "start", "end", "entry", "Lcom/unionyy/mobile/meipai/chat/message/bean/MPCMIcon;", "imageCreator", "Lcom/unionyy/mobile/meipai/chat/codec/img/MPCMImageCreator;", "endowNickName", "Lcom/unionyy/mobile/meipai/chat/message/bean/MPCMUserInfo;", "parse", "", "message", "Lcom/yymobile/core/channel/ChannelMessage;", "parseColor", "color", "", "default", "parseMPCMText", "", "text", "Lcom/unionyy/mobile/meipai/chat/message/bean/MPCMText;", "cm", "Lcom/unionyy/mobile/meipai/chat/message/MeiPaiChannelMessage;", "Companion", "meipai_release"})
public final class MeiPaiPublicChatParser
extends PublicChatBaseParser {
    private static final String TAG = "MeiPaiPublicChatParser";
    public static final Companion Companion = new Companion(null);

    public boolean parse(@NotNull ChannelMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        MPCMImageCreator imageCreator = MPCMTextFactory.INSTANCE.getImageCreator();
        try {
            if (message instanceof MeiPaiChannelMessage) {
                String string2 = message.text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message.text");
                this.parseMPCMText(MeiPaiChannelMessageCodec.INSTANCE.deserialize(string2), (MeiPaiChannelMessage)message, imageCreator);
                return true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
        return super.parse(message);
    }

    private final void parseMPCMText(MPCMText text, MeiPaiChannelMessage cm, MPCMImageCreator imageCreator) {
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)text.getText());
        int textColor = MeiPaiPublicChatParser.parseColor$default(this, text.getTextColor(), 0, 2, null);
        spannable.setSpan((Object)new ForegroundColorSpan(textColor), 0, spannable.length(), 33);
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)text.getUsers(), (Iterable)text.getIcons());
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                MPCMRenderEntry it = (MPCMRenderEntry)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getPos());
                it = (MPCMRenderEntry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getPos();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List renderEntry = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        $this$sortedBy$iv = renderEntry;
        $i$f$sortedBy = false;
        if (!$this$sortedBy$iv.isEmpty()) {
            int curIdx = 0;
            int renderEntryIdx = 0;
            while (curIdx >= 0 && curIdx < spannable.length() && renderEntryIdx < renderEntry.size()) {
                int startIdx = StringsKt.indexOf$default((CharSequence)((CharSequence)spannable), (String)"%{", (int)curIdx, (boolean)false, (int)4, null);
                int endIdx = -1;
                if (startIdx != -1) {
                    MPCMRenderEntry entry;
                    endIdx = StringsKt.indexOf$default((CharSequence)((CharSequence)spannable), (String)"}", (int)startIdx, (boolean)false, (int)4, null);
                    if (endIdx == -1) break;
                    endIdx += "}".length();
                    if ((entry = (MPCMRenderEntry)renderEntry.get(renderEntryIdx++)) instanceof MPCMUserInfo) {
                        endIdx = this.endowNickName(spannable, startIdx, endIdx, (MPCMUserInfo)entry);
                    } else if (entry instanceof MPCMIcon) {
                        endIdx = this.endowIcon(spannable, startIdx, endIdx, (MPCMIcon)entry, imageCreator);
                    }
                }
                curIdx = endIdx;
            }
        }
        cm.spannable = spannable;
        cm.setBackgroundColor(MeiPaiPublicChatParser.parseColor$default(this, text.getBackColor(), 0, 2, null));
    }

    @ColorInt
    private final int parseColor(String color2, @ColorInt int n) {
        if (color2 != null) {
            CharSequence charSequence = color2;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                try {
                    return Color.parseColor((String)color2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    static /* synthetic */ int parseColor$default(MeiPaiPublicChatParser meiPaiPublicChatParser, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return meiPaiPublicChatParser.parseColor(string2, n);
    }

    private final int endowNickName(SpannableStringBuilder spannable, int start2, int end, MPCMUserInfo entry) {
        spannable.replace(start2, end, (CharSequence)entry.getNickName());
        int newEnd = start2 + entry.getNickName().length();
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#FFFEF899")), start2, newEnd, 33);
        spannable.setSpan((Object)new ClickableSpan(entry){
            final /* synthetic */ MPCMUserInfo $entry;

            public void updateDrawState(@NotNull TextPaint ds) {
                Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
                ds.setUnderlineText(false);
            }

            public void onClick(@Nullable View widget) {
                new MeipaiPersonalCardBuilder(this.$entry.getUid()).fromWhereArea(MeipaiPersonalCardBuilder.FromWhereArea.CHAT_USER).show();
            }
            {
                this.$entry = $captured_local_variable$0;
            }
        }, start2, newEnd, 33);
        return newEnd;
    }

    private final int endowIcon(SpannableStringBuilder spannable, int start2, int end, MPCMIcon entry, MPCMImageCreator imageCreator) {
        int n;
        Uri uri;
        String content = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.substring((CharSequence)((CharSequence)spannable), (IntRange)RangesKt.until((int)start2, (int)end)), (CharSequence)"%{"), (CharSequence)"}");
        boolean hasText = Intrinsics.areEqual((Object)content, (Object)"#") ^ true;
        Function0<Integer> $fun$handleException$1 = new Function0<Integer>(hasText, end, spannable, start2){
            final /* synthetic */ boolean $hasText;
            final /* synthetic */ int $end;
            final /* synthetic */ SpannableStringBuilder $spannable;
            final /* synthetic */ int $start;

            public final int invoke() {
                int n;
                if (this.$hasText) {
                    n = this.$end;
                } else {
                    this.$spannable.replace(this.$start, this.$end, (CharSequence)"");
                    n = this.$start;
                }
                return n;
            }
            {
                this.$hasText = bl;
                this.$end = n;
                this.$spannable = spannableStringBuilder;
                this.$start = n2;
                super(0);
            }
        };
        Uri uri2 = uri = Uri.parse((String)entry.getUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        if (imageCreator.canHandle(uri2)) {
            int n2;
            try {
                Context context = this.mContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
                ReplacementSpan imageSpan = imageCreator.create(context, hasText ? content : null, uri);
                spannable.setSpan((Object)imageSpan, start2, end, 33);
                n2 = end;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                n2 = $fun$handleException$1.invoke();
            }
            n = n2;
        } else {
            n = $fun$handleException$1.invoke();
        }
        return n;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unionyy/mobile/meipai/chat/parse/MeiPaiPublicChatParser$Companion;", "", "()V", "TAG", "", "meipai_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

