/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.Window;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.core.MeiPaiPkProtocols;
import com.unionyy.mobile.meipai.pk.ui.dialog.DialogManager;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiBottomComponentDialog;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiPKInviteDialogFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class MeiPaiPKInviteSettingDialog
extends MeiPaiBottomComponentDialog {
    private static final String TAG = "MeiPaiPKInviteSettingDialog";
    private Switch strangerSwitch;
    private Switch friendSwitch;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();

    @Override
    public int getLayoutId() {
        return R.layout.meipai_dialog_pk_invite_setting;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog2 = super.onCreateDialog(savedInstanceState);
        Window dialogWindow = dialog2.getWindow();
        dialogWindow.setLayout(-1, DimenConverter.dip2px((Context)this.getContext(), (float)300.0f));
        return dialog2;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.strangerSwitch = (Switch)view.findViewById(R.id.meipai_pk_invate_setting_stranger_switch);
        this.strangerSwitch.setVisibility(8);
        this.strangerSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (buttonView.isChecked()) {
                    MeiPaiPKInviteSettingDialog.this.setSwitch(1, 1);
                } else {
                    MeiPaiPKInviteSettingDialog.this.setSwitch(1, 0);
                }
            }
        });
        this.friendSwitch = (Switch)view.findViewById(R.id.meipai_pk_invate_setting_friend_switch);
        this.friendSwitch.setVisibility(8);
        this.friendSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (buttonView.isChecked()) {
                    MeiPaiPKInviteSettingDialog.this.setSwitch(2, 1);
                } else {
                    MeiPaiPKInviteSettingDialog.this.setSwitch(2, 0);
                }
            }
        });
        view.findViewById(R.id.meipai_pk_invate_setting_back_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogManager.getInstence().dismissAllPopupComponents(MeiPaiPKInviteSettingDialog.this.getActivity());
                DialogManager.getInstence().showPopupComponent(new MeiPaiPKInviteDialogFragment(), MeiPaiPKInviteSettingDialog.this.getActivity());
            }
        });
        this.initData();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.compositeDisposable.dispose();
    }

    private void initData() {
        Disposable disposable = this.core.reqPKGetFriendConfigReq(null).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiPkProtocols.PMeiPaiPKGetFriendConfigRsp>(){

            public void accept(MeiPaiPkProtocols.PMeiPaiPKGetFriendConfigRsp rsp) throws Exception {
                MLog.info((Object)MeiPaiPKInviteSettingDialog.TAG, (String)("[PK] PMeiPaiPKGetFriendConfigRsp accept" + rsp), (Object[])new Object[0]);
                int fs = Integer.parseInt(rsp.extendInfo.get("friend_pk"));
                MeiPaiPKInviteSettingDialog.this.friendSwitch.setVisibility(0);
                if (fs == 1) {
                    MeiPaiPKInviteSettingDialog.this.friendSwitch.setChecked(true);
                } else {
                    MeiPaiPKInviteSettingDialog.this.friendSwitch.setChecked(false);
                }
                int ss = Integer.parseInt(rsp.extendInfo.get("stranger_pk"));
                MeiPaiPKInviteSettingDialog.this.strangerSwitch.setVisibility(0);
                if (ss == 1) {
                    MeiPaiPKInviteSettingDialog.this.strangerSwitch.setChecked(true);
                } else {
                    MeiPaiPKInviteSettingDialog.this.strangerSwitch.setChecked(false);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                Toast.makeText((Context)MeiPaiPKInviteSettingDialog.this.getContext(), (CharSequence)"\u7f51\u7edc\u5f02\u5e38", (int)0).show();
                MLog.error((Object)MeiPaiPKInviteSettingDialog.TAG, (String)("[PK] PMeiPaiPKGetFriendConfigRsp throwable = " + throwable), (Object[])new Object[0]);
            }
        });
        this.compositeDisposable.add(disposable);
    }

    private void setSwitch(int mStype, int mOptype) {
        Disposable disposable = this.core.reqPKFriPKSwitch(mStype, mOptype, null).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiPkProtocols.PMeipaiPKFriPKSwitchRsp>(){

            public void accept(MeiPaiPkProtocols.PMeipaiPKFriPKSwitchRsp rsp) throws Exception {
                MLog.info((Object)MeiPaiPKInviteSettingDialog.TAG, (String)("[PK] PMeipaiPKFriPKSwitchRsp accept" + rsp), (Object[])new Object[0]);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)MeiPaiPKInviteSettingDialog.TAG, (String)("[PK] PMeipaiPKFriPKSwitchRsp throwable = " + throwable), (Object[])new Object[0]);
            }
        });
        this.compositeDisposable.add(disposable);
    }
}

