/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.Gson;
import com.gyf.immersionbar.ImmersionBar;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.core.IMeiPaiAnchorGiftCore;
import com.unionyy.mobile.meipai.gift.core.MeiPaiAnchorGiftListProtocols;
import com.unionyy.mobile.meipai.gift.core.MeiPaiAnchorGiftProtocols;
import com.unionyy.mobile.meipai.gift.data.bean.UserReceivedGiftBean;
import com.unionyy.mobile.meipai.gift.data.bean.UserReceivedGiftItemBean;
import com.unionyy.mobile.meipai.gift.data.bean.UserReceivedGiftSumBean;
import com.unionyy.mobile.meipai.pk.utils.AvatarRoundUtil;
import com.unionyy.mobile.meipai.pk.utils.NumberUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.pluginstartlive.component.cover.preview.BaseAnchorLiveComponent;
import com.yy.mobile.smartrefresh.layout.SmartRefreshLayout;
import com.yy.mobile.smartrefresh.layout.api.RefreshLayout;
import com.yy.mobile.smartrefresh.layout.listener.OnRefreshListener;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.List;

public class GiftReceiveInLiveDailog
extends BaseAnchorLiveComponent {
    public static final String TAG = GiftReceiveInLiveDailog.class.getSimpleName();
    private static final String LIVE_ID = "live_id";
    private String live_id = "123";
    private View mGiftReceiveCountTitle;
    private SmartRefreshLayout mListView;
    private RecyclerView mRecyclerView;
    private ViewGroup mNoDataParent;
    private ViewGroup mNetWorkErrorParent;
    private TextView tvRecevieNm;
    private TextView tvMeidouCount;
    private GiftsListAdapter mAdapter;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();

    public static GiftReceiveInLiveDailog newInstance(String live_id) {
        GiftReceiveInLiveDailog f = new GiftReceiveInLiveDailog();
        Bundle b = new Bundle();
        b.putSerializable(LIVE_ID, (Serializable)((Object)live_id));
        f.setArguments(b);
        return f;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog2 = super.onCreateDialog(savedInstanceState);
        dialog2.setCanceledOnTouchOutside(true);
        dialog2.requestWindowFeature(1);
        dialog2.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog2.getWindow().setGravity(80);
        dialog2.getWindow().setWindowAnimations(R.style.DialogAnimation);
        int height = (int)ResolutionUtils.convertDpToPixel((float)306.0f, (Context)BasicConfig.getInstance().getAppContext());
        dialog2.getWindow().setLayout(-1, height);
        dialog2.getWindow().clearFlags(2);
        return dialog2;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
        Bundle b = this.getArguments();
        if (null != b) {
            this.live_id = b.getString(LIVE_ID);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.compositeDisposable.clear();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.meipai_live_gift_recevice_view, container, false);
        this.tvRecevieNm = (TextView)view.findViewById(R.id.tv_recevie_num);
        this.tvMeidouCount = (TextView)view.findViewById(R.id.tv_meidou_count);
        this.mGiftReceiveCountTitle = view.findViewById(R.id.live_gift_receive_count);
        this.mListView = (SmartRefreshLayout)view.findViewById(R.id.meipai_pk_invate_oriented_smartRefreshLayout);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.meipai_pk_invate_oriented_recyclerView);
        this.mNoDataParent = (ViewGroup)view.findViewById(R.id.live_gift_receive_no_data);
        this.mNetWorkErrorParent = (ViewGroup)view.findViewById(R.id.live_gift_receive_net_error);
        this.mAdapter = new GiftsListAdapter();
        this.mListView.setEnableRefresh(true);
        this.mListView.setEnableLoadmore(false);
        this.showEmptyDataView();
        this.initListener();
        this.initData();
        this.getDialog().setCanceledOnTouchOutside(true);
        this.getDialog().setCancelable(true);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(1, 1));
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ImmersionBar.with((DialogFragment)this).init();
    }

    public void onStart() {
        super.onStart();
        this.setOrientation();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setOrientation();
    }

    private void setOrientation() {
        if (null != this.getDialog()) {
            int orientation = this.getResources().getConfiguration().orientation;
            try {
                Window window = this.getDialog().getWindow();
                WindowManager.LayoutParams windowParams = window.getAttributes();
                if (orientation == 1) {
                    windowParams.width = -1;
                    windowParams.gravity = 80;
                } else {
                    windowParams.width = (int)this.getResources().getDimension(R.dimen.meipai_live_live_gift_recevice_land_view_width);
                    windowParams.gravity = 17;
                }
                windowParams.dimAmount = 0.0f;
                windowParams.flags |= 2;
                window.setAttributes(windowParams);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showNoNetwork() {
        if (this.getActivity() != null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)BasicConfig.getInstance().getAppContext().getString(R.string.meipai_live_error_network), (int)0);
        }
    }

    private void initListener() {
        this.mNoDataParent.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mNetWorkErrorParent.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mListView.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(RefreshLayout refreshlayout) {
                GiftReceiveInLiveDailog.this.getOnlineDataUser();
            }
        });
    }

    private void initData() {
        this.getOnlinDataCount();
        this.getOnlineDataUser();
    }

    @SuppressLint(value={"CheckResult"})
    private void getOnlinDataCount() {
        this.compositeDisposable.add(((IMeiPaiAnchorGiftCore)ICoreManagerBase.getCore(IMeiPaiAnchorGiftCore.class)).getGiftInfo(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId(), this.live_id).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiAnchorGiftProtocols.PMeipaiAnchorGiftRsp>(){

            public void accept(MeiPaiAnchorGiftProtocols.PMeipaiAnchorGiftRsp rsp) throws Exception {
                MLog.info((Object)TAG, (String)("PMeipaiAnchorGiftRsp accept" + rsp), (Object[])new Object[0]);
                UserReceivedGiftSumBean bean = (UserReceivedGiftSumBean)new Gson().fromJson(rsp.resultRsp, UserReceivedGiftSumBean.class);
                GiftReceiveInLiveDailog.this.refreshCountSum(bean);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)TAG, (String)("PMeipaiAnchorGiftRsp throwable = " + throwable), (Object[])new Object[0]);
                GiftReceiveInLiveDailog.this.showNoNetwork();
                GiftReceiveInLiveDailog.this.showNetWorkErrorView();
            }
        }));
    }

    private void getOnlineDataUser() {
        this.compositeDisposable.add(((IMeiPaiAnchorGiftCore)ICoreManagerBase.getCore(IMeiPaiAnchorGiftCore.class)).getGiftListInfo(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId(), this.live_id).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiAnchorGiftListProtocols.PMeipaiAnchorGiftListRsp>(){

            public void accept(MeiPaiAnchorGiftListProtocols.PMeipaiAnchorGiftListRsp rsp) throws Exception {
                MLog.info((Object)TAG, (String)("PMeipaiAnchorGiftListRsp accept" + rsp), (Object[])new Object[0]);
                UserReceivedGiftBean bean = (UserReceivedGiftBean)new Gson().fromJson(rsp.resultRsp, UserReceivedGiftBean.class);
                GiftReceiveInLiveDailog.this.mListView.finishRefresh();
                if (null != GiftReceiveInLiveDailog.this.mAdapter && bean != null) {
                    GiftReceiveInLiveDailog.this.mAdapter.refreshAdapter(bean.getData());
                } else {
                    GiftReceiveInLiveDailog.this.showEmptyDataView();
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                GiftReceiveInLiveDailog.this.showNoNetwork();
                GiftReceiveInLiveDailog.this.showNetWorkErrorView();
            }
        }));
    }

    private void refreshCountSum(UserReceivedGiftSumBean bean) {
        if (null == bean || null == bean.getData() || null == bean.getData().getGiftCount() || null == bean.getData().getScore()) {
            return;
        }
        this.tvRecevieNm.setText((CharSequence)String.valueOf(bean.getData().getGiftCount()));
        this.tvMeidouCount.setText((CharSequence)String.valueOf(bean.getData().getScore()));
        this.mGiftReceiveCountTitle.setVisibility(0);
    }

    public void show(FragmentActivity activity) {
        this.show(activity.getSupportFragmentManager(), TAG);
    }

    private void showDataView() {
        if (null != this.mListView) {
            this.mListView.setVisibility(0);
        }
        if (null != this.mNoDataParent) {
            this.mNoDataParent.setVisibility(8);
        }
        if (null != this.mNetWorkErrorParent) {
            this.mNetWorkErrorParent.setVisibility(8);
        }
    }

    private void showEmptyDataView() {
        if (null != this.mListView) {
            this.mListView.setVisibility(8);
        }
        if (null != this.mNoDataParent) {
            this.mNoDataParent.setVisibility(0);
        }
        if (null != this.mNetWorkErrorParent) {
            this.mNetWorkErrorParent.setVisibility(8);
        }
    }

    private void showNetWorkErrorView() {
        if (null != this.mListView) {
            this.mListView.setVisibility(8);
        }
        if (null != this.mNoDataParent) {
            this.mNoDataParent.setVisibility(8);
        }
        if (null != this.mNetWorkErrorParent) {
            this.mNetWorkErrorParent.setVisibility(0);
        }
    }

    public class GiftViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivAvatar;
        ImageView ivVerify;
        TextView tvUserScreen;
        TextView tvCaption;
        TextView tvMeidou;

        public GiftViewHolder(View itemView) {
            super(itemView);
            this.ivAvatar = (ImageView)itemView.findViewById(R.id.ivw_avatar);
            this.ivVerify = (ImageView)itemView.findViewById(R.id.ivw_v);
            this.tvUserScreen = (TextView)itemView.findViewById(R.id.tv_user_screen_name);
            this.tvCaption = (TextView)itemView.findViewById(R.id.tv_caption);
            this.tvMeidou = (TextView)itemView.findViewById(R.id.tv_meidou);
        }
    }

    final class GiftsListAdapter
    extends RecyclerView.Adapter<GiftViewHolder> {
        private List<UserReceivedGiftItemBean> mReceivedGifsList;

        GiftsListAdapter() {
        }

        public void refreshAdapter(List<UserReceivedGiftItemBean> list2) {
            this.notifyDataSetChanged();
            if (this.mReceivedGifsList != null) {
                this.mReceivedGifsList.clear();
            }
            this.mReceivedGifsList = list2;
            if (null == this.mReceivedGifsList || this.mReceivedGifsList.isEmpty()) {
                GiftReceiveInLiveDailog.this.showEmptyDataView();
            } else {
                GiftReceiveInLiveDailog.this.showDataView();
            }
            this.notifyDataSetChanged();
        }

        @NonNull
        public GiftViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new GiftViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.meipai_live_list_item_received_gift, parent, false));
        }

        public void onBindViewHolder(@NonNull GiftViewHolder holder, int position) {
            String bean;
            UserReceivedGiftItemBean gift = this.mReceivedGifsList.get(position);
            if (null == gift) {
                return;
            }
            holder.tvCaption.setText((CharSequence)(gift.getPresentName() + "x" + (null == gift.getCount() ? "" : gift.getCount())));
            Glide.with((Context)holder.ivAvatar.getContext().getApplicationContext()).load(gift.getPortrait()).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(holder.ivAvatar.getContext(), R.drawable.meipai_default_avatar_small))).into(holder.ivAvatar);
            holder.tvUserScreen.setText((CharSequence)gift.getNick());
            if (gift.getSex() != null && gift.getSex().equalsIgnoreCase("0")) {
                holder.tvUserScreen.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.meipai_live_ic_sex_female, 0);
            } else {
                holder.tvUserScreen.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.meipai_live_ic_sex_male, 0);
            }
            holder.tvUserScreen.setCompoundDrawablePadding(DeviceUtils.dip2px(3.0f));
            String string2 = bean = null == gift.getCount() ? "" : gift.getCount();
            if (!TextUtils.isEmpty((CharSequence)bean)) {
                long sum = Long.valueOf(bean) * gift.getPrice();
                if (!TextUtils.isEmpty((CharSequence)bean)) {
                    holder.tvMeidou.setText((CharSequence)BasicConfig.getInstance().getAppContext().getString(R.string.meipai_live_plus_intimities, new Object[]{NumberUtils.formatPlayNumber(sum)}));
                } else {
                    holder.tvMeidou.setText(null);
                }
            }
            holder.tvMeidou.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.meipai_live_ic_meidou_small, 0);
        }

        public int getItemCount() {
            if (null != this.mReceivedGifsList) {
                return this.mReceivedGifsList.size();
            }
            return 0;
        }
    }
}

