/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.unionyy.mobile.meipai.R;

public class GiftCombosProgressView
extends View {
    private int bgColor;
    private int fgColor;
    private Paint bgPaint;
    private Paint fgPaint;
    private RectF oval;
    private float percent;
    private float startAngle;
    private long mDuration;
    private long mStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCombosProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.meipai_live_GiftCombosProgressView, 0, 0);
        try {
            this.bgColor = a.getColor(R.styleable.meipai_live_GiftCombosProgressView_GbgColor, -1710619);
            this.fgColor = a.getColor(R.styleable.meipai_live_GiftCombosProgressView_GfgColor, -35236);
            this.percent = a.getFloat(R.styleable.meipai_live_GiftCombosProgressView_Gpercent, 0.0f);
            this.startAngle = a.getFloat(R.styleable.meipai_live_GiftCombosProgressView_GstartAngle, 0.0f) + 270.0f;
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.bgPaint = new Paint(1);
        this.bgPaint.setColor(this.bgColor);
        this.fgPaint = new Paint(1);
        this.fgPaint.setColor(this.fgColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float xpad = this.getPaddingLeft() + this.getPaddingRight();
        float ypad = this.getPaddingBottom() + this.getPaddingTop();
        float wwd = (float)w - xpad;
        float hhd = (float)h - ypad;
        this.oval = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + wwd, (float)this.getPaddingTop() + hhd);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        long expensiveTime = System.currentTimeMillis() - this.mStartTime;
        this.percent = (float)expensiveTime * 100.0f / (float)this.mDuration;
        canvas.drawArc(this.oval, 0.0f, 360.0f, true, this.bgPaint);
        canvas.drawArc(this.oval, this.startAngle, this.percent * 3.6f, true, this.fgPaint);
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
        this.refreshTheLayout();
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(int fgColor) {
        this.fgColor = fgColor;
        this.refreshTheLayout();
    }

    private void refreshTheLayout() {
        this.invalidate();
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(float startAngle) {
        this.startAngle = startAngle + 270.0f;
        this.invalidate();
    }

    public float getPercent() {
        return this.percent;
    }

    public void start(long duration) {
        this.percent = 0.0f;
        this.mDuration = duration;
        this.mStartTime = System.currentTimeMillis();
    }
}

