/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.opengl;

import android.opengl.GLES20;
import android.util.Log;

public class ShaderUtil {
    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                Log.e((String)"ES20_ERROR", (String)("Could not compile shader " + shaderType + ":"));
                Log.e((String)"ES20_ERROR", (String)GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    public static int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = ShaderUtil.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = ShaderUtil.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            ShaderUtil.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)program, (int)pixelShader);
            ShaderUtil.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                Log.e((String)"ES20_ERROR", (String)"Could not link program: ");
                Log.e((String)"ES20_ERROR", (String)GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)"ES20_ERROR", (String)(op + ": glError " + error));
            throw new RuntimeException(op + ": glError " + error);
        }
    }
}

