/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.gift.core.config.MPGiftConfigParser;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pluginstartlive.component.cover.preview.core.AIGiftStateListener;
import com.yy.mobile.pluginstartlive.component.cover.preview.core.IStickerFilterCore;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.old.GiftStickerItem;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class ARGiftManager {
    private static final String PREFERENCE_NAME = "ARGiftManagerPreferences";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String STICKER_DIR = "giftstickers";
    private static final String NOMEDIA = ".nomedia";
    private static final String STICKER_PATH = BasicConfig.getInstance().getRootDir() + File.separator + "giftstickers" + File.separator;
    private static final String TAG = "ARGiftManager";
    private List<GiftStickerItem> mGiftStickeritems = Collections.synchronizedList(new ArrayList());
    private ArQueueManager mQueueManager = ArQueueManager.getIstance();
    private List<GiftStickerItem> mArWhenDowning = Collections.synchronizedList(new ArrayList());
    private SharedPreferences mARGiftManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)"ARGiftManagerPreferences", (int)0);

    @SuppressLint(value={"CheckResult"})
    private ARGiftManager() {
        File[] fs;
        File file = new File(STICKER_PATH);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (File f : fs = file.listFiles()) {
            String id2 = f.getName();
            GiftStickerItem item = new GiftStickerItem();
            item.id = id2;
            item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSED);
            String effectName = this.getAREffectName(item);
            String string2 = item.filePath = effectName == null ? null : STICKER_PATH + id2 + File.separator + effectName;
            if (TextUtils.isEmpty((CharSequence)item.filePath)) continue;
            this.mGiftStickeritems.add(item);
        }
    }

    public void startGift(String id2, String url) {
        this.initData(id2, url);
        this.openFaceStickerWithInfo(id2);
    }

    public void setMaIGiftStateListener(AIGiftStateListener maIGiftStateListener) {
        this.mQueueManager.setMaIGiftStateListener(maIGiftStateListener);
    }

    private void downloadAllWhatNeed() {
        for (int i = 0; i < this.mGiftStickeritems.size(); ++i) {
            final GiftStickerItem mGiftStickerItem = this.mGiftStickeritems.get(i);
            if (mGiftStickerItem.getGiftStickerStatus() != GiftStickerItem.GiftStickerStatus.UNDOWNLOAD) continue;
            mGiftStickerItem.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DOWNLOADING);
            this.downloadStickerFile(mGiftStickerItem.url, new ResponseListener(){

                @SuppressLint(value={"CheckResult"})
                public void onResponse(Object response) {
                    MLog.info((Object)ARGiftManager.TAG, (String)("downloadAllWhatNeed() download succeeded: " + mGiftStickerItem.url), (Object[])new Object[0]);
                    Observable.just((Object)mGiftStickerItem).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

                        public void accept(GiftStickerItem i) {
                            ARGiftManager.this.decompressStickResourceAndExecuteQueue(i);
                        }
                    });
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                    MLog.info((Object)ARGiftManager.TAG, (String)("downloadAllWhatNeed() download failed: " + mGiftStickerItem.url), (Object[])new Object[0]);
                    mGiftStickerItem.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult", "Rx#subscribe\u4f7f\u7528"})
    private void initData(String id2, String url) {
        this.checkPathAndNoMedia(BasicConfig.getInstance().getRootDir() + File.separator + STICKER_DIR);
        if (this.containId(id2, url)) {
            return;
        }
        GiftStickerItem item = new GiftStickerItem();
        item.url = url;
        item.id = id2;
        item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
        this.mGiftStickeritems.add(item);
        Observable.just(this.mGiftStickeritems).subscribeOn(Schedulers.computation()).subscribe((Consumer)new Consumer<List<GiftStickerItem>>(){

            public void accept(List<GiftStickerItem> items) {
                ARGiftManager.this.removeInaccuracyStickerFileCache(items.toArray(new GiftStickerItem[0]));
                for (GiftStickerItem item : items) {
                    String verifyMd5 = ARGiftManager.this.getPreferenceResourceMd5(item);
                    if (!TextUtils.isEmpty((CharSequence)verifyMd5) && verifyMd5.equals(ARGiftManager.this.cacheMd5(item))) {
                        item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSED);
                        continue;
                    }
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                }
                ARGiftManager.this.downloadAllWhatNeed();
            }
        });
    }

    private boolean containId(String id2, String url) {
        for (GiftStickerItem item : this.mGiftStickeritems) {
            if (!id2.equals(item.id)) continue;
            item.url = url;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"CheckResult"})
    private void openFaceStickerWithInfo(String id2) {
        GiftStickerItem item = null;
        for (GiftStickerItem i : this.mGiftStickeritems) {
            if (!id2.equals(i.id)) continue;
            item = i;
            break;
        }
        if (item == null) {
            return;
        }
        Observable.just(item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

            public void accept(final GiftStickerItem item) {
                ARGiftManager.this.removeInaccuracyStickerFileCache(new GiftStickerItem[]{item});
                ARGiftManager.this.downloadAllWhatNeed();
                switch (item.getGiftStickerStatus()) {
                    case UNDOWNLOAD: {
                        ARGiftManager.this.mArWhenDowning.add(item);
                        item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DOWNLOADING);
                        ARGiftManager.this.downloadStickerFile(item.url, new ResponseListener(){

                            public void onResponse(Object response) {
                                MLog.info((Object)ARGiftManager.TAG, (String)("openFaceStickerWithInfo() download succeeded: " + item.url), (Object[])new Object[0]);
                                Observable.just((Object)item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

                                    public void accept(GiftStickerItem i) {
                                        ARGiftManager.this.decompressStickResourceAndExecuteQueue(i);
                                    }
                                });
                            }
                        }, new ResponseErrorListener(){

                            public void onErrorResponse(RequestError error) {
                                MLog.info((Object)ARGiftManager.TAG, (String)("openFaceStickerWithInfo() download succeeded: " + item.url), (Object[])new Object[0]);
                                item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                            }
                        }, new ProgressListener(){

                            public void onProgress(ProgressInfo info) {
                            }
                        });
                        break;
                    }
                    case DOWNLOADING: {
                        ARGiftManager.this.mArWhenDowning.add(item);
                        break;
                    }
                    case DECOMPRESSING: {
                        ARGiftManager.this.mArWhenDowning.add(item);
                        break;
                    }
                    case DECOMPRESSED: {
                        ARGiftManager.this.showArGift(item);
                        break;
                    }
                }
            }
        });
    }

    public void ondispose() {
        this.mGiftStickeritems.clear();
        this.mQueueManager.destory();
        this.mArWhenDowning.clear();
    }

    private synchronized void removeInaccuracyStickerFileCache(GiftStickerItem ... giftStickerItems) {
        if (giftStickerItems == null) {
            return;
        }
        try {
            for (GiftStickerItem item : giftStickerItems) {
                if (item.getGiftStickerStatus() == GiftStickerItem.GiftStickerStatus.DECOMPRESSING) continue;
                File stickerFileDir = new File(STICKER_PATH + item.id);
                File[] resourceFiles = stickerFileDir.listFiles();
                if (!stickerFileDir.exists()) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("stickerFileDir is not exists. " + item), (Object[])new Object[0]);
                    continue;
                }
                if (resourceFiles == null) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("resourceFiles is not exists. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String fileEffect = this.getAREffectName(item);
                if (TextUtils.isEmpty((CharSequence)fileEffect)) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("can not get file \".oeffect\" path. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String effectFilePath = STICKER_PATH + item.id + File.separator + fileEffect;
                File effectFile = new File(effectFilePath);
                if (!effectFile.exists()) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("file \".oeffect\" not found. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String verifyMd5 = this.getPreferenceResourceMd5(item);
                String cacheMd5 = this.cacheMd5(item);
                if (!TextUtils.isEmpty((CharSequence)verifyMd5) && verifyMd5.equals(cacheMd5)) continue;
                item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                MLog.info((Object)TAG, (String)("Md5 verify failed. " + item), (Object[])new Object[0]);
                FileUtil.delete((File)stickerFileDir);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void checkPathAndNoMedia(String path) {
        File file;
        File stickerDir = new File(path);
        if (!stickerDir.exists()) {
            stickerDir.mkdir();
        }
        if (!stickerDir.isDirectory()) {
            stickerDir.delete();
            stickerDir.mkdir();
        }
        if (!(file = new File(path + File.separator + NOMEDIA)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)("Face checkPathAndNoMedia error  " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void downloadStickerFile(String url, ResponseListener responseListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        String filePath;
        File file;
        File stickerPath;
        MLog.info((Object)TAG, (String)("downloadStickerFile " + url), (Object[])new Object[0]);
        if (url == null) {
            MLog.info((Object)TAG, (String)("MAllGiftResMap size = " + MPGiftConfigParser.Companion.getINSTANCES().getMAllGiftResMap().size()), (Object[])new Object[0]);
            return;
        }
        File rootFile = BasicConfig.getInstance().getRootDir();
        if (!rootFile.exists()) {
            rootFile.mkdir();
        }
        if (!(stickerPath = new File(rootFile.getAbsolutePath() + File.separator + STICKER_DIR)).exists()) {
            stickerPath.mkdir();
        }
        if ((file = new File(filePath = stickerPath.getAbsolutePath() + File.separator + GiftStickerItem.getFileNameByUrl((String)url))).exists()) {
            FileUtil.delete((File)file);
        }
        RequestManager.instance().submitDownloadRequest(url, filePath, responseListener, errorListener, progressListener, false);
    }

    private synchronized void decompressStickResourceAndExecuteQueue(GiftStickerItem info) {
        this.decompressStickResource(info);
        if (this.mArWhenDowning.size() > 0) {
            ArrayList<GiftStickerItem> deleteData = new ArrayList<GiftStickerItem>();
            for (GiftStickerItem item : this.mArWhenDowning) {
                if (!this.showArGift(item)) continue;
                deleteData.add(item);
            }
            for (GiftStickerItem deleteItem : deleteData) {
                this.mArWhenDowning.remove(deleteItem);
            }
        }
    }

    private boolean showArGift(GiftStickerItem info) {
        String rootPath = STICKER_PATH + info.id + File.separator;
        File file = new File(rootPath);
        Object[] files2 = file.listFiles(new AREffectFilter());
        if (FP.empty((Object[])files2)) {
            return false;
        }
        String effectName = this.getAREffectName(info);
        String path = effectName == null ? null : STICKER_PATH + info.id + File.separator + effectName;
        ArEntity entity = new ArEntity(path, info.grade);
        this.doShowArGift(entity);
        MLog.info((Object)TAG, (String)("showArGift() will done! show ar now: " + info), (Object[])new Object[0]);
        return true;
    }

    private String getAREffectName(GiftStickerItem info) {
        String rootPath = STICKER_PATH + info.id + File.separator;
        File file = new File(rootPath);
        Object[] files2 = file.listFiles(new AREffectFilter());
        if (FP.empty((Object[])files2)) {
            return null;
        }
        return ((File)files2[0]).getName();
    }

    private synchronized void decompressStickResource(GiftStickerItem info) {
        MLog.info((Object)TAG, (String)("method decompressStickResource ready. " + info), (Object[])new Object[0]);
        String zipPath = STICKER_PATH + info.id;
        File zipFile = new File(STICKER_PATH + GiftStickerItem.getFileNameByUrl((String)info.url));
        if (!zipFile.exists()) {
            MLog.info((Object)TAG, (String)("method decompressStickResource ops. zip file not exists. " + info), (Object[])new Object[0]);
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
            return;
        }
        try {
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSING);
            FileUtil.unzip((File)zipFile, (String)zipPath, (String)"");
            zipFile.delete();
            String md5 = this.cacheMd5(info);
            this.setPreferenceResourceMd5(info, md5);
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSED);
            info.filePath = this.getAREffectName(info);
            MLog.info((Object)TAG, (String)("method decompressStickResource decompressed. " + info + " md5=" + md5), (Object[])new Object[0]);
        }
        catch (Exception e) {
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
            MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)("method decompressStickResource done. " + info), (Object[])new Object[0]);
    }

    void doShowArGift(ArEntity entity) {
        this.mQueueManager.add(entity);
    }

    private String cacheMd5(GiftStickerItem item) {
        try {
            Object[] resourceFiles = new File(STICKER_PATH + item.id).listFiles();
            if (FP.empty((Object[])resourceFiles)) {
                return "";
            }
            return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
        }
        catch (Exception e) {
            MLog.debug((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    private String getPreferenceResourceMd5(GiftStickerItem item) {
        return this.mARGiftManagerPreferences.getString(this.getPreferenceResourceMd5Key(item), "");
    }

    private void setPreferenceResourceMd5(GiftStickerItem item, String md5) {
        this.mARGiftManagerPreferences.edit().putString(this.getPreferenceResourceMd5Key(item), md5).apply();
    }

    private String getPreferenceResourceMd5Key(GiftStickerItem item) {
        return PREFERENCE_KEY_RES_MD5_PRE_FIX + item.id;
    }

    class AREffectFilter
    implements FileFilter {
        AREffectFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".ofeffect");
        }
    }

    public static class ArEntity
    implements Comparable {
        public int grade;
        public String path;

        public ArEntity(String path, int grade) {
            this.path = path;
            this.grade = grade;
        }

        public int compareTo(Object another) {
            ArEntity p = (ArEntity)another;
            return p.grade - this.grade;
        }

        public String toString() {
            return "ArEntity{grade=" + this.grade + ", path='" + this.path + '\'' + '}';
        }
    }

    static class ArQueueManager {
        private static volatile ArQueueManager instance;
        private static final String TAG = "ARGiftManager";
        private BlockingQueue<ArEntity> messages;
        private volatile boolean runFlag = false;
        private IStickerFilterCore stickerFilterCore = (IStickerFilterCore)ICoreManagerBase.getCore(IStickerFilterCore.class);
        private Thread arThread;
        private AIGiftStateListener maIGiftStateListener;
        private Runnable showArRunable = new Runnable(){

            @Override
            public void run() {
                while (ArQueueManager.this.runFlag) {
                    try {
                        ArEntity entity = (ArEntity)ArQueueManager.this.messages.take();
                        MLog.info((Object)"ARGiftManager", (String)("ArQueueManager// run():" + entity.toString()), (Object[])new Object[0]);
                        ArQueueManager.this.stickerFilterCore.setAIGiftEffect(entity.path, ArQueueManager.this.maIGiftStateListener);
                    }
                    catch (InterruptedException e) {
                        ArQueueManager.this.runFlag = false;
                    }
                }
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ArQueueManager getIstance() {
            if (instance != null) return instance;
            Class<ArQueueManager> clazz = ArQueueManager.class;
            synchronized (ArQueueManager.class) {
                if (instance != null) return instance;
                instance = new ArQueueManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private ArQueueManager() {
            this.messages = new PriorityBlockingQueue<ArEntity>();
        }

        public void setMaIGiftStateListener(AIGiftStateListener maIGiftStateListener) {
            this.maIGiftStateListener = maIGiftStateListener;
        }

        public synchronized void add(ArEntity entity) {
            if (this.messages != null) {
                this.messages.add(entity);
                this.start();
            }
        }

        public synchronized void start() {
            if (!this.runFlag) {
                this.runFlag = true;
                if (this.arThread == null) {
                    this.arThread = new Thread(this.showArRunable);
                    this.arThread.start();
                } else if (!this.arThread.isAlive()) {
                    this.arThread = new Thread(this.showArRunable);
                    this.arThread.start();
                }
            }
        }

        public void destory() {
            this.runFlag = false;
            this.messages.clear();
        }
    }

    public static class Holder {
        public static ARGiftManager manager = new ARGiftManager();
    }
}

