/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class LedBitmapLoader {
    private Bitmap mLedBitmap;
    private int mPadding = 3;
    private Paint mPaint;
    private Paint mDotPaint;
    private int mTextSize;
    private int mDotBackColor = 0;
    private int mDotColor = -1;
    private Paint.FontMetrics mFontMetrics;
    private float mDotRadiusScale = 0.33f;
    private String mText;
    private int mLedWidth;
    private int mLedHeight;

    public LedBitmapLoader(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint();
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mDotPaint = new Paint();
        this.mPadding = (int)TypedValue.applyDimension((int)1, (float)this.mPadding, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
    }

    public void setDotColor(int front, int back) {
        this.mDotColor = front;
        this.mDotBackColor = back;
    }

    public void setText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (this.mLedBitmap != null) {
            this.mLedBitmap.recycle();
            this.mLedBitmap = null;
        }
        this.mText = text;
    }

    public void createLedBitmap(int width, int height, Bitmap suffixText) {
        int textHeight = height - this.mPadding * 2;
        float len = (float)height / (float)this.mTextSize;
        float radius = len * this.mDotRadiusScale;
        this.mPaint.setTextSize((float)textHeight);
        this.mPaint.setColor(this.mDotColor);
        Bitmap shader = Bitmap.createBitmap((int)((int)Math.ceil(len)), (int)((int)Math.ceil(len)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas shaderCanvas = new Canvas(shader);
        this.mDotPaint.setShader(null);
        this.mDotPaint.setColor(this.mDotColor);
        shaderCanvas.drawCircle(len / 2.0f, len / 2.0f, radius, this.mDotPaint);
        this.mPaint.setShader((Shader)new BitmapShader(shader, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
        int textWidth = (int)Math.ceil(this.mPaint.measureText(this.mText)) + this.mPadding;
        int suffixHeight = (int)((float)textHeight * 0.85f);
        int suffixWidth = (int)((float)suffixHeight / (float)suffixText.getHeight() * (float)suffixText.getWidth());
        suffixText = this.extractAlpha(suffixText, suffixWidth, suffixHeight);
        this.mLedBitmap = Bitmap.createBitmap((int)(textWidth + suffixWidth + this.mPadding * 2), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mLedWidth = this.mLedBitmap.getWidth();
        this.mLedHeight = this.mLedBitmap.getHeight();
        Canvas ledCanvas = new Canvas(this.mLedBitmap);
        this.mFontMetrics = this.mPaint.getFontMetrics();
        float baseline = (float)(this.mLedBitmap.getHeight() / 2) - this.mFontMetrics.bottom - this.mFontMetrics.bottom / 4.0f + (this.mFontMetrics.bottom - this.mFontMetrics.top) / 2.0f;
        ledCanvas.drawText(this.mText, (float)(textWidth / 2), baseline, this.mPaint);
        int suffixPaddingTop = (this.mLedHeight - suffixHeight) / 2;
        ledCanvas.drawBitmap(suffixText, (float)(textWidth + this.mPadding), (float)suffixPaddingTop, this.mPaint);
    }

    private Bitmap extractAlpha(Bitmap bitmap, int width, int height) {
        Bitmap scaleBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
        Bitmap temp = scaleBitmap.extractAlpha();
        if (temp != scaleBitmap && scaleBitmap != bitmap) {
            scaleBitmap.recycle();
        }
        return temp;
    }

    public Bitmap getLedBitmap() {
        if (this.mLedBitmap == null || this.mLedBitmap.isRecycled()) {
            return null;
        }
        return this.mLedBitmap;
    }

    public int getLedWidth() {
        return this.mLedWidth;
    }

    public int getLedHeight() {
        return this.mLedHeight;
    }

    public void setLedBitmapSize(int width, int height) {
        this.mLedWidth = width;
        this.mLedHeight = height;
    }

    public void release() {
        if (this.mLedBitmap != null) {
            this.mLedBitmap.recycle();
            this.mLedBitmap = null;
        }
    }
}

