/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.dispatcher;

import android.os.AsyncTask;
import com.unionyy.mobile.meipai.gift.ARGiftManager;
import com.unionyy.mobile.meipai.gift.animation.decoder.INGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveARAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftARTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftImageTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.controller.GiftAnimateController;
import com.unionyy.mobile.meipai.gift.dispatcher.IGiftMessageDispatcher;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

public class GiftMessageDispatcher
implements IGiftMessageDispatcher {
    private static final String TAG = "GiftMessageDispatcher";
    private static final long MAX_GIFT_SIZE = (long)((float)Runtime.getRuntime().maxMemory() * 0.2f) / 4L;
    private volatile long mCurrentGiftSize = 0L;
    private volatile boolean mHasEmptyImagePlayer = true;
    private IGiftDispatcherListener mListener;
    private PriorityBlockingQueue<GiftMessage> mLargeGiftMessages = new PriorityBlockingQueue<GiftMessage>(10, new Comparator<GiftMessage>(){

        @Override
        public int compare(GiftMessage lhs, GiftMessage rhs) {
            return GiftAnimateController.getGiftValue(rhs) - GiftAnimateController.getGiftValue(lhs);
        }
    });

    public GiftMessageDispatcher(IGiftDispatcherListener listener2) {
        this.mListener = listener2;
    }

    @Override
    public boolean receivedGiftMessage(GiftMessage giftMessage) {
        if (giftMessage != null) {
            this.mLargeGiftMessages.add(giftMessage);
        }
        this.doLargeGiftAnimation();
        return true;
    }

    @Override
    public boolean receivedGiftMessage(ArrayList<GiftMessage> giftMessages) {
        if (giftMessages != null) {
            this.mLargeGiftMessages.addAll(giftMessages);
        }
        this.doLargeGiftAnimation();
        return true;
    }

    @Override
    public void callOnGiftImageAnimDismisss() {
        this.doLargeGiftAnimation();
    }

    @Override
    public INGiftAnimateDecoder findDecoderDealGiftMessage(GiftMessage message) {
        return this.mListener != null ? this.mListener.findDecoderDealGiftMessage(message) : null;
    }

    @Override
    public void clear() {
        this.setMemorySizeZero();
        this.mLargeGiftMessages.clear();
        this.callHasEmptyImagePlayer();
    }

    @Override
    public void release() {
        this.clear();
    }

    public synchronized boolean isCurrentStateSatisfyDispatch() {
        return this.mCurrentGiftSize < MAX_GIFT_SIZE;
    }

    public synchronized long getMemoryUsage() {
        return this.mCurrentGiftSize;
    }

    public synchronized void addMemoryUsage(long used) {
        this.mCurrentGiftSize += used;
    }

    public synchronized void reduceMemoryUsage(long used) {
        this.mCurrentGiftSize -= used;
    }

    public synchronized void setMemorySizeZero() {
        this.mCurrentGiftSize = 0L;
    }

    public synchronized void callHasEmptyImagePlayer() {
        this.mHasEmptyImagePlayer = true;
    }

    public synchronized boolean isHasEmptyImagePlayer() {
        return this.mHasEmptyImagePlayer;
    }

    public synchronized void setHasEmptyImagePlayer(boolean has) {
        this.mHasEmptyImagePlayer = has;
    }

    private void doLargeGiftAnimation() {
        if (this.mLargeGiftMessages.size() > 0 && this.isCurrentStateSatisfyDispatch()) {
            try {
                new LoadGiftResourceTask().execute(new GiftMessage[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class LoadGiftResourceTask
    extends AsyncTask<GiftMessage, Void, Boolean> {
        private ArrayList<GiftTarget> largeGiftTargets;
        private INGiftAnimateDecoder iGiftDecoder;
        private GiftMessage whenTypeIsLargeExtendAR;

        protected Boolean doInBackground(GiftMessage ... params) {
            boolean hasEmptyImagePlayer = GiftMessageDispatcher.this.isHasEmptyImagePlayer();
            if (!hasEmptyImagePlayer) {
                return false;
            }
            MLog.info((Object)GiftMessageDispatcher.TAG, (String)("doInBackground" + Thread.currentThread().getName()), (Object[])new Object[0]);
            ArrayList<GiftTarget> targetList = new ArrayList<GiftTarget>();
            this.whenTypeIsLargeExtendAR = null;
            long memoryUsage = 0L;
            if (GiftMessageDispatcher.this.mLargeGiftMessages.size() > 0 && GiftMessageDispatcher.this.getMemoryUsage() + memoryUsage < MAX_GIFT_SIZE) {
                GiftMessage gift = (GiftMessage)GiftMessageDispatcher.this.mLargeGiftMessages.poll();
                INGiftAnimateDecoder decoder = GiftMessageDispatcher.this.findDecoderDealGiftMessage(gift);
                if (gift != null && gift.getBussiness() == 11) {
                    if (gift.getGestureGiftUrl().isEmpty()) {
                        MLog.info((Object)GiftMessageDispatcher.TAG, (String)"gift.getGestureGiftUrl().isEmpty()", (Object[])new Object[0]);
                        GiftMessageDispatcher.this.callHasEmptyImagePlayer();
                        return false;
                    }
                    this.iGiftDecoder = decoder;
                    GiftImageTarget target = new GiftImageTarget();
                    target.setGiftMessage(gift);
                    targetList.add(target);
                } else if (gift != null && gift.getGiftLocalPath() != null && gift.getGiftLocalPath().endsWith(".mp4")) {
                    MLog.debug((Object)GiftMessageDispatcher.TAG, (String)("mLargeGiftMessages.size" + GiftMessageDispatcher.this.mLargeGiftMessages.size()), (Object[])new Object[0]);
                    this.iGiftDecoder = decoder;
                    GiftImageTarget target = new GiftImageTarget();
                    target.setGiftMessage(gift);
                    targetList.add(target);
                } else {
                    GiftDispatchMessage message;
                    this.iGiftDecoder = decoder;
                    if (decoder == null || (message = decoder.checkGiftNeedWatitForDispatch(gift)) == null) {
                        return false;
                    }
                    GiftTarget target = decoder.loadGiftImageTarget(gift, message.rule);
                    if (target == null) {
                        if (message.isNeedDispatch) {
                            GiftMessageDispatcher.this.callHasEmptyImagePlayer();
                        }
                        return false;
                    }
                    this.whenTypeIsLargeExtendAR = gift.getWhenTypeIsLargeExtendAR();
                    DispatcherAttachMessage dispatcherAttachMessage = new DispatcherAttachMessage();
                    dispatcherAttachMessage.arg1 = targetList.size();
                    this.iGiftDecoder.doSomeWithGiftTargetByDispatcher(target, dispatcherAttachMessage);
                    targetList.add(target);
                    if (gift.getWhenTypeIsLargeExtendAR() != null && gift.getWhenTypeIsLargeExtendAR().getGift_type() == 7 && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                        String arResPath = gift.getWhenTypeIsLargeExtendAR().getResource_ar();
                        MLog.info((Object)GiftMessageDispatcher.TAG, (String)("arResPath = " + arResPath), (Object[])new Object[0]);
                        ARGiftManager.Holder.manager.startGift(gift.getGiftId(), arResPath);
                    }
                }
            }
            this.largeGiftTargets = targetList;
            MLog.info((Object)GiftMessageDispatcher.TAG, (String)"doInBackground end", (Object[])new Object[0]);
            return true;
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                this.showARWithLargeGift();
                if (this.largeGiftTargets != null && this.iGiftDecoder != null) {
                    MLog.info((Object)GiftMessageDispatcher.TAG, (String)"onPostExecute by GiftDecoder do run animation", (Object[])new Object[0]);
                    GiftMessageDispatcher.this.setHasEmptyImagePlayer(false);
                    this.iGiftDecoder.addGiftTargetToGroup(this.largeGiftTargets);
                }
            }
        }

        private void showARWithLargeGift() {
            GiftDispatchMessage whenTypeIsLargeExtendArGDM;
            LiveARAnimateDecoder arAnimateDecoder;
            if (null != this.whenTypeIsLargeExtendAR && null != (arAnimateDecoder = (LiveARAnimateDecoder)GiftMessageDispatcher.this.findDecoderDealGiftMessage(this.whenTypeIsLargeExtendAR)) && null != (whenTypeIsLargeExtendArGDM = arAnimateDecoder.checkGiftNeedWatitForDispatch(this.whenTypeIsLargeExtendAR))) {
                GiftARTarget giftARTarget = new GiftARTarget(false);
                giftARTarget.setARMaterialPath(this.whenTypeIsLargeExtendAR.getGiftLocalPath());
                giftARTarget.setGiftRule(whenTypeIsLargeExtendArGDM.rule);
                arAnimateDecoder.addGiftTargetToGroup(giftARTarget);
            }
        }
    }

    public static class DispatcherAttachMessage {
        public int arg1;
    }

    public static class GiftDispatchMessage {
        public boolean isNeedDispatch;
        public GiftRule rule;
    }

    public static interface IGiftDispatcherListener {
        public INGiftAnimateDecoder findDecoderDealGiftMessage(GiftMessage var1);
    }
}

