/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import com.yy.mobile.config.BasicConfig;

public class MeiPaiScreenUtil {
    public static final String TAG = "MeiPaiScreenUtil";
    private int mRealSizeWidth;
    private int mRealSizeHeight;
    private static volatile MeiPaiScreenUtil singleton;

    private MeiPaiScreenUtil() {
        this.initRealSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MeiPaiScreenUtil getInstance() {
        if (singleton != null) return singleton;
        Class<MeiPaiScreenUtil> clazz = MeiPaiScreenUtil.class;
        synchronized (MeiPaiScreenUtil.class) {
            if (singleton != null) return singleton;
            singleton = new MeiPaiScreenUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private void initRealSize() {
        WindowManager windowManager = (WindowManager)BasicConfig.getInstance().getAppContext().getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point outPoint = new Point();
        if (Build.VERSION.SDK_INT >= 19) {
            display.getRealSize(outPoint);
        } else {
            display.getSize(outPoint);
        }
        if (outPoint.y > outPoint.x) {
            this.mRealSizeHeight = outPoint.y;
            this.mRealSizeWidth = outPoint.x;
        } else {
            this.mRealSizeHeight = outPoint.x;
            this.mRealSizeWidth = outPoint.y;
        }
    }

    public int getRealSizeWidth() {
        return this.mRealSizeWidth;
    }

    public int getRealSizeHeight() {
        return this.mRealSizeHeight;
    }

    public static void setWindowScreenBrightness(@NonNull Window window, int screenBrightness) {
        try {
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.screenBrightness = (float)screenBrightness / 255.0f;
            window.setAttributes(lp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=19)
    public static void useImmersiveMode(Activity context, boolean use) {
        if (!use || Build.VERSION.SDK_INT < 19) {
            return;
        }
        context.getWindow().getDecorView().setSystemUiVisibility(5894);
    }

    public static boolean is18And9HighScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        float ratio = height / width;
        return ratio >= 2.0f;
    }

    public static boolean is18And9BigScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        float ratio = height / width;
        return ratio >= 2.0f && width >= 1080.0f;
    }

    public static boolean is1280And640HighScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        return height == 1280.0f && width == 640.0f;
    }

    public static boolean is854And480HighScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        return height == 854.0f && width == 480.0f;
    }

    public static boolean is2280And1080HighScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        return height == 2280.0f && width == 1080.0f;
    }

    public static boolean is2244And1080HighScreen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        float height = MeiPaiScreenUtil.getInstance().getRealSizeHeight();
        return height == 2244.0f && width == 1080.0f;
    }

    public static boolean isLow540Screen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        return width <= 540.0f;
    }

    public static boolean isLow640Screen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        return width <= 640.0f;
    }

    public static boolean isLow720Screen() {
        float width = MeiPaiScreenUtil.getInstance().getRealSizeWidth();
        Log.e((String)TAG, (String)("isLow720Screen: " + width));
        return width < 720.0f;
    }

    public static int getBangsHairScreenFlag() {
        return 5890;
    }

    @TargetApi(value=19)
    public static void useImmersiveModeBy18And9HighScreen(Activity context, boolean use) {
        if (!use || Build.VERSION.SDK_INT < 19) {
            return;
        }
        context.getWindow().getDecorView().setSystemUiVisibility(MeiPaiScreenUtil.getBangsHairScreenFlag());
    }

    @TargetApi(value=17)
    public static boolean hasSoftKeys(WindowManager windowManager) {
        Display d2 = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        d2.getRealMetrics(realDisplayMetrics);
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d2.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    public static int getScreenWidth(Activity context) {
        WindowManager manager = context.getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        int width = outMetrics.widthPixels;
        return width;
    }

    public static int getScreenHeight(Activity context) {
        WindowManager manager = context.getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        int h = outMetrics.heightPixels;
        return h;
    }

    public static int getNavigationBarHeight(Activity context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        Log.v((String)"dbw", (String)("Navi height:" + height));
        return height;
    }
}

